/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.rest;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.openejb.rest.ThreadLocalContextResolver;
import org.apache.openejb.rest.ThreadLocalHttpHeaders;
import org.apache.openejb.rest.ThreadLocalHttpServletRequest;
import org.apache.openejb.rest.ThreadLocalHttpServletResponse;
import org.apache.openejb.rest.ThreadLocalProviders;
import org.apache.openejb.rest.ThreadLocalRequest;
import org.apache.openejb.rest.ThreadLocalSecurityContext;
import org.apache.openejb.rest.ThreadLocalServletConfig;
import org.apache.openejb.rest.ThreadLocalServletRequest;
import org.apache.openejb.rest.ThreadLocalUriInfo;

public class ThreadLocalContextManager {
    public static final ThreadLocalRequest REQUEST = new ThreadLocalRequest();
    public static final ThreadLocalServletConfig SERVLET_CONFIG = new ThreadLocalServletConfig();
    public static final ThreadLocalServletRequest SERVLET_REQUEST = new ThreadLocalServletRequest();
    public static final ThreadLocalHttpServletRequest HTTP_SERVLET_REQUEST = new ThreadLocalHttpServletRequest();
    public static final ThreadLocalHttpServletResponse HTTP_SERVLET_RESPONSE = new ThreadLocalHttpServletResponse();
    public static final ThreadLocalUriInfo URI_INFO = new ThreadLocalUriInfo();
    public static final ThreadLocalHttpHeaders HTTP_HEADERS = new ThreadLocalHttpHeaders();
    public static final ThreadLocalSecurityContext SECURITY_CONTEXT = new ThreadLocalSecurityContext();
    public static final ThreadLocalContextResolver CONTEXT_RESOLVER = new ThreadLocalContextResolver();
    public static final ThreadLocalProviders PROVIDERS = new ThreadLocalProviders();
    public static final ThreadLocal<Application> APPLICATION = new ThreadLocal();
    public static final ThreadLocal<Map<String, Object>> OTHERS = new ThreadLocal();

    public static void reset() {
        REQUEST.remove();
        SERVLET_REQUEST.remove();
        SERVLET_CONFIG.remove();
        HTTP_SERVLET_REQUEST.remove();
        HTTP_SERVLET_RESPONSE.remove();
        URI_INFO.remove();
        HTTP_HEADERS.remove();
        SECURITY_CONTEXT.remove();
        CONTEXT_RESOLVER.remove();
        PROVIDERS.remove();
        APPLICATION.remove();
        Map<String, Object> map = OTHERS.get();
        if (map != null) {
            map.clear();
        }
        OTHERS.remove();
    }

    public static Object findThreadLocal(Class<?> type) {
        if (Request.class.equals(type)) {
            return REQUEST;
        }
        if (UriInfo.class.equals(type)) {
            return URI_INFO;
        }
        if (HttpHeaders.class.equals(type)) {
            return HTTP_HEADERS;
        }
        if (SecurityContext.class.equals(type)) {
            return SECURITY_CONTEXT;
        }
        if (ContextResolver.class.equals(type)) {
            return CONTEXT_RESOLVER;
        }
        if (Providers.class.equals(type)) {
            return PROVIDERS;
        }
        if (ServletRequest.class.equals(type)) {
            return SERVLET_REQUEST;
        }
        if (HttpServletRequest.class.equals(type)) {
            return HTTP_SERVLET_REQUEST;
        }
        if (HttpServletResponse.class.equals(type)) {
            return HTTP_SERVLET_RESPONSE;
        }
        if (ServletConfig.class.equals(type)) {
            return SERVLET_CONFIG;
        }
        return null;
    }
}

