/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.web;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.ws.rs.core.Application;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Injection;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.ClassListInfo;
import org.apache.openejb.assembler.classic.FilterInfo;
import org.apache.openejb.assembler.classic.InjectionBuilder;
import org.apache.openejb.assembler.classic.JndiEncBuilder;
import org.apache.openejb.assembler.classic.ListenerInfo;
import org.apache.openejb.assembler.classic.ParamValueInfo;
import org.apache.openejb.assembler.classic.PortInfo;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.cdi.CdiBuilder;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.ArrayEnumeration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.web.WebInitialContext;
import org.apache.webbeans.web.lifecycle.test.MockServletContextEvent;

public class LightweightWebAppBuilder
implements WebAppBuilder {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, LightweightWebAppBuilder.class);
    private static Method addServletMethod = null;
    private static Method removeServletMethod = null;
    private static Method addFilterMethod = null;
    private static Method removeFilterMethod = null;
    private final Map<WebAppInfo, DeployedWebObjects> servletDeploymentInfo = new HashMap<WebAppInfo, DeployedWebObjects>();
    private final Map<WebAppInfo, List<Object>> listeners = new HashMap<WebAppInfo, List<Object>>();
    private final Map<WebAppInfo, ServletContextEvent> servletContextEvents = new HashMap<WebAppInfo, ServletContextEvent>();

    /*
     * WARNING - void declaration
     */
    @Override
    public void deployWebApps(AppInfo appInfo, ClassLoader classLoader) throws Exception {
        CoreContainerSystem cs = (CoreContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        AppContext appContext = cs.getAppContext(appInfo.appId);
        if (appContext == null) {
            throw new OpenEJBRuntimeException("Can't find app context for " + appInfo.appId);
        }
        for (WebAppInfo webAppInfo : appInfo.webApps) {
            int i$;
            HashSet<Injection> injections = new HashSet<Injection>(appContext.getInjections());
            injections.addAll(new InjectionBuilder(classLoader).buildInjections(webAppInfo.jndiEnc));
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.putAll(appContext.getBindings());
            bindings.putAll(new JndiEncBuilder(webAppInfo.jndiEnc, injections, webAppInfo.moduleId, "Bean", null, webAppInfo.uniqueId, classLoader).buildBindings(JndiEncBuilder.JndiScope.comp));
            WebContext webContext = new WebContext(appContext);
            webContext.setBindings(bindings);
            webContext.getBindings().putAll(new JndiEncBuilder(webAppInfo.jndiEnc, injections, webAppInfo.moduleId, "Bean", null, webAppInfo.uniqueId, classLoader).buildBindings(JndiEncBuilder.JndiScope.comp));
            webContext.setJndiEnc(WebInitialContext.create(bindings, appContext.getGlobalJndiContext()));
            webContext.setClassLoader(classLoader);
            webContext.setId(webAppInfo.moduleId);
            webContext.setContextRoot(webAppInfo.contextRoot);
            webContext.setHost(webAppInfo.host);
            webContext.getInjections().addAll(injections);
            webContext.setInitialContext(new EmbeddedInitialContext(webContext.getJndiEnc(), webContext.getBindings()));
            appContext.getWebContexts().add(webContext);
            cs.addWebContext(webContext);
            if (!appInfo.webAppAlone) {
                Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
                List<BeanContext> beanContexts = assembler.initEjbs(classLoader, appInfo, appContext, injections, new ArrayList<BeanContext>(), webAppInfo.moduleId);
                appContext.getBeanContexts().addAll(beanContexts);
                new CdiBuilder().build(appInfo, appContext, appContext.getBeanContexts(), webContext);
                assembler.startEjbs(true, beanContexts);
            }
            MockServletContextEvent sce = new MockServletContextEvent();
            this.servletContextEvents.put(webAppInfo, (ServletContextEvent)sce);
            for (ListenerInfo listener : webAppInfo.listeners) {
                List<Object> list;
                Class<?> clazz = webContext.getClassLoader().loadClass(listener.classname);
                Object object = webContext.newInstance(clazz);
                if (ServletContextListener.class.isInstance(object)) {
                    ((ServletContextListener)object).contextInitialized((ServletContextEvent)sce);
                }
                if ((list = this.listeners.get(webAppInfo)) == null) {
                    list = new ArrayList<Object>();
                    this.listeners.put(webAppInfo, list);
                }
                list.add(object);
            }
            DeployedWebObjects deployedWebObjects = new DeployedWebObjects();
            deployedWebObjects.webContext = webContext;
            this.servletDeploymentInfo.put(webAppInfo, deployedWebObjects);
            if (addServletMethod == null) continue;
            for (FilterInfo filterInfo : webAppInfo.filters) {
                for (String mapping : filterInfo.mappings) {
                    SimpleFilterConfig config = new SimpleFilterConfig(sce.getServletContext(), filterInfo.name, filterInfo.initParams);
                    try {
                        addFilterMethod.invoke(null, filterInfo.classname, webContext, mapping, config);
                        deployedWebObjects.filterMappings.add(mapping);
                    }
                    catch (Exception e) {
                        LOGGER.warning(e.getMessage(), e);
                    }
                }
            }
            for (ClassListInfo classListInfo : webAppInfo.webAnnotatedClasses) {
                String string = classListInfo.name;
                for (String filterPath : classListInfo.list) {
                    void var23_50;
                    Class<?> clazz = LightweightWebAppBuilder.loadFromUrls(webContext.getClassLoader(), string, filterPath);
                    WebFilter annotation = clazz.getAnnotation(WebFilter.class);
                    if (annotation == null) continue;
                    Properties initParams = new Properties();
                    WebInitParam[] webInitParamArray = annotation.initParams();
                    int len$ = webInitParamArray.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        WebInitParam webInitParam = webInitParamArray[i$];
                        initParams.put(webInitParam.name(), webInitParam.value());
                    }
                    SimpleFilterConfig simpleFilterConfig = new SimpleFilterConfig(sce.getServletContext(), classListInfo.name, initParams);
                    String[] arr$ = annotation.urlPatterns();
                    int len$2 = arr$.length;
                    boolean bl = false;
                    while (var23_50 < len$2) {
                        String mapping = arr$[var23_50];
                        try {
                            addFilterMethod.invoke(null, clazz.getName(), webContext, mapping, simpleFilterConfig);
                            deployedWebObjects.filterMappings.add(mapping);
                        }
                        catch (Exception e) {
                            LOGGER.warning(e.getMessage(), e);
                        }
                        ++var23_50;
                    }
                }
            }
            TreeMap<String, PortInfo> ports = new TreeMap<String, PortInfo>();
            for (PortInfo portInfo : webAppInfo.portInfos) {
                ports.put(portInfo.serviceLink, portInfo);
            }
            for (ServletInfo servletInfo : webAppInfo.servlets) {
                if ("true".equalsIgnoreCase(appInfo.properties.getProperty("openejb.jaxrs.on", "true"))) {
                    boolean skip = false;
                    for (ParamValueInfo pvi : servletInfo.initParams) {
                        if (!"javax.ws.rs.Application".equals(pvi.name) && !Application.class.getName().equals(pvi.name)) continue;
                        skip = true;
                    }
                    if (skip) continue;
                    if (servletInfo.servletClass == null) {
                        try {
                            if (Application.class.isAssignableFrom(classLoader.loadClass(servletInfo.servletName))) {
                                continue;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (ports.containsKey(servletInfo.servletName) || ports.containsKey(servletInfo.servletClass)) continue;
                for (String mapping : servletInfo.mappings) {
                    try {
                        addServletMethod.invoke(null, servletInfo.servletClass, webContext, mapping);
                        deployedWebObjects.mappings.add(mapping);
                    }
                    catch (Exception e) {
                        LOGGER.warning(e.getMessage(), e);
                    }
                }
            }
            for (ClassListInfo classListInfo : webAppInfo.webAnnotatedClasses) {
                String url = classListInfo.name;
                for (String servletPath : classListInfo.list) {
                    Class<?> clazz = LightweightWebAppBuilder.loadFromUrls(webContext.getClassLoader(), url, servletPath);
                    WebServlet annotation = clazz.getAnnotation(WebServlet.class);
                    if (annotation == null) continue;
                    String[] stringArray = annotation.urlPatterns();
                    int len$ = stringArray.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        String string = stringArray[i$];
                        try {
                            addServletMethod.invoke(null, clazz.getName(), webContext, string);
                            deployedWebObjects.mappings.add(string);
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.warning(e.getMessage(), e);
                        }
                    }
                }
            }
        }
    }

    private static Class<?> loadFromUrls(ClassLoader loader, String url, String path) throws ClassNotFoundException {
        String classname = "jar:file://!/WEB-INF/classes/".equals(url) && path.contains("classes/") ? path.substring(path.lastIndexOf("classes/") + "classes/".length()) : path.substring(url.length());
        try {
            return loader.loadClass(LightweightWebAppBuilder.className(classname));
        }
        catch (ClassNotFoundException cnfe) {
            return loader.loadClass(LightweightWebAppBuilder.className(path.substring(path.indexOf("!") + 2)));
        }
    }

    private static String className(String value) {
        return value.substring(0, value.length() - ".class".length()).replace(File.separatorChar, '/').replace('/', '.');
    }

    @Override
    public void undeployWebApps(AppInfo appInfo) throws Exception {
        for (WebAppInfo webAppInfo : appInfo.webApps) {
            DeployedWebObjects context = this.servletDeploymentInfo.remove(webAppInfo);
            ServletContextEvent sce = this.servletContextEvents.remove(webAppInfo);
            List<Object> listenerInstances = this.listeners.remove(webAppInfo);
            if (addServletMethod != null) {
                for (String mapping : context.mappings) {
                    try {
                        removeServletMethod.invoke(null, mapping, context.webContext);
                    }
                    catch (Exception e) {}
                }
                for (String mapping : context.filterMappings) {
                    try {
                        removeFilterMethod.invoke(null, mapping, context.webContext);
                    }
                    catch (Exception e) {}
                }
            }
            if (listenerInstances == null) continue;
            for (Object instance : listenerInstances) {
                if (!ServletContextListener.class.isInstance(instance)) continue;
                ((ServletContextListener)instance).contextDestroyed(sce);
            }
        }
    }

    @Override
    public Map<ClassLoader, Map<String, Set<String>>> getJsfClasses() {
        return Collections.emptyMap();
    }

    static {
        try {
            Class<?> utilClass = LightweightWebAppBuilder.class.getClassLoader().loadClass("org.apache.openejb.server.httpd.util.HttpUtil");
            addServletMethod = utilClass.getMethod("addServlet", String.class, WebContext.class, String.class);
            removeServletMethod = utilClass.getMethod("removeServlet", String.class, WebContext.class);
            addFilterMethod = utilClass.getMethod("addFilter", String.class, WebContext.class, String.class, FilterConfig.class);
            removeFilterMethod = utilClass.getMethod("removeFilter", String.class, WebContext.class);
        }
        catch (Exception e) {
            LOGGER.info("Web features will not be available, add openejb-http if you need them");
        }
    }

    private static class SimpleFilterConfig
    implements FilterConfig {
        private final Properties params;
        private final String name;
        private final ServletContext servletContext;

        public SimpleFilterConfig(ServletContext sc, String name, Properties initParams) {
            this.name = name;
            this.params = initParams;
            this.servletContext = sc;
        }

        public String getFilterName() {
            return this.name;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getInitParameter(String name) {
            return this.params.getProperty(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return new ArrayEnumeration(this.params.keySet());
        }
    }

    private static class EmbeddedInitialContext
    implements Context {
        private final Context delegate;
        private final Map<String, Object> bindings;

        public EmbeddedInitialContext(Context jndiEnc, Map<String, Object> bindings) {
            this.delegate = jndiEnc;
            this.bindings = bindings;
        }

        @Override
        public Object lookup(Name name) throws NamingException {
            return this.lookup(name.toString());
        }

        @Override
        public Object lookup(String name) throws NamingException {
            try {
                return this.delegate.lookup(name);
            }
            catch (NameNotFoundException nnfe) {
                return this.bindings.get(name);
            }
        }

        @Override
        public void bind(Name name, Object obj) throws NamingException {
        }

        @Override
        public void bind(String name, Object obj) throws NamingException {
        }

        @Override
        public void rebind(Name name, Object obj) throws NamingException {
        }

        @Override
        public void rebind(String name, Object obj) throws NamingException {
        }

        @Override
        public void unbind(Name name) throws NamingException {
        }

        @Override
        public void unbind(String name) throws NamingException {
        }

        @Override
        public void rename(Name oldName, Name newName) throws NamingException {
        }

        @Override
        public void rename(String oldName, String newName) throws NamingException {
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            return null;
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
            return null;
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            return null;
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
            return null;
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
        }

        @Override
        public void destroySubcontext(String name) throws NamingException {
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            return null;
        }

        @Override
        public Context createSubcontext(String name) throws NamingException {
            return null;
        }

        @Override
        public Object lookupLink(Name name) throws NamingException {
            return null;
        }

        @Override
        public Object lookupLink(String name) throws NamingException {
            return null;
        }

        @Override
        public NameParser getNameParser(Name name) throws NamingException {
            return null;
        }

        @Override
        public NameParser getNameParser(String name) throws NamingException {
            return null;
        }

        @Override
        public Name composeName(Name name, Name prefix) throws NamingException {
            return null;
        }

        @Override
        public String composeName(String name, String prefix) throws NamingException {
            return null;
        }

        @Override
        public Object addToEnvironment(String propName, Object propVal) throws NamingException {
            return null;
        }

        @Override
        public Object removeFromEnvironment(String propName) throws NamingException {
            return null;
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            return null;
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            return null;
        }
    }

    private static class DeployedWebObjects {
        public List<String> mappings = new ArrayList<String>();
        public List<String> filterMappings = new ArrayList<String>();
        public WebContext webContext;

        private DeployedWebObjects() {
        }
    }
}

