/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.ArrayList;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.JndiReference;

public class ClearEmptyMappedName
implements DynamicDeployer {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            for (EnterpriseBean consumer : ejbModule.getEjbJar().getEnterpriseBeans()) {
                this.clearEmptyMappedName((JndiConsumer)consumer);
            }
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            this.clearEmptyMappedName((JndiConsumer)clientModule.getApplicationClient());
        }
        for (WebModule webModule : appModule.getWebModules()) {
            this.clearEmptyMappedName((JndiConsumer)webModule.getWebApp());
        }
        return appModule;
    }

    private void clearEmptyMappedName(JndiConsumer consumer) {
        if (consumer == null) {
            return;
        }
        ArrayList refs = new ArrayList();
        refs.addAll(consumer.getEjbLocalRef());
        refs.addAll(consumer.getEjbRef());
        refs.addAll(consumer.getEnvEntry());
        refs.addAll(consumer.getMessageDestinationRef());
        refs.addAll(consumer.getPersistenceContextRef());
        refs.addAll(consumer.getPersistenceUnitRef());
        refs.addAll(consumer.getResourceEnvRef());
        refs.addAll(consumer.getResourceRef());
        refs.addAll(consumer.getServiceRef());
        for (JndiReference ref : refs) {
            if (ref.getMappedName() == null || ref.getMappedName().length() != 0) continue;
            ref.setMappedName(null);
        }
    }
}

