/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.openejb.resource.jdbc.logging.AbstractSQLLogger;
import org.apache.openejb.resource.jdbc.logging.TimeWatcherExecutor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class LoggingPreparedSqlStatement
extends AbstractSQLLogger
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB_SQL, LoggingPreparedSqlStatement.class);
    private final PreparedStatement delegate;
    private final String sql;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private int parameterIndex;

    public LoggingPreparedSqlStatement(PreparedStatement result, String query) {
        this.delegate = result;
        this.sql = query;
        this.parameterIndex = 0;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mtdName = method.getName();
        boolean execute = mtdName.startsWith("execute");
        TimeWatcherExecutor.TimerWatcherResult result = TimeWatcherExecutor.execute(method, this.delegate, args, execute);
        if (mtdName.startsWith("set") && args.length >= 2 && (args[0].getClass().equals(Integer.TYPE) || args[0].getClass().equals(Integer.class))) {
            this.parameters.add(new Parameter(mtdName.substring(3), this.parameterIndex, (Integer)args[0], args[1]));
        } else if (execute) {
            String str = this.sql;
            if (str.contains("?")) {
                Collections.sort(this.parameters);
                int lastBatch = 0;
                for (int i = 0; i < this.parameters.size(); ++i) {
                    Parameter param = this.parameters.get(i);
                    if (str.contains("?")) {
                        try {
                            str = str.replaceFirst("\\?", param.value.toString());
                        }
                        catch (Exception e) {
                            str = param.value == null ? str.replaceFirst("\\?", "null") : str.replaceFirst("\\?", param.value.getClass().getName());
                        }
                        lastBatch = param.batchIndex;
                        continue;
                    }
                    if (lastBatch != param.batchIndex) {
                        str = str + ", (";
                        lastBatch = param.batchIndex;
                    }
                    try {
                        str = str + param.value.toString();
                    }
                    catch (Exception e) {
                        str = param.value == null ? str + "null" : str + param.value.getClass().getName();
                    }
                    str = i == this.parameters.size() - 1 || this.parameters.get(i + 1).batchIndex != lastBatch ? str + ")" : str + ",";
                }
            }
            LOGGER.info(this.format(str, result.getDuration()));
        } else if ("clearParameters".equals(mtdName)) {
            this.parameters.clear();
            this.parameterIndex = 0;
        } else if ("addBatch".equals(mtdName)) {
            ++this.parameterIndex;
        }
        return result.getResult();
    }

    protected static class Parameter
    implements Comparable<Parameter> {
        private final String type;
        private final int batchIndex;
        private final int key;
        private final Object value;

        public Parameter(String type, int batchIdx, int key, Object value) {
            this.type = type;
            this.batchIndex = batchIdx;
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(Parameter o) {
            int comp = this.batchIndex - o.batchIndex;
            if (comp == 0) {
                return this.key - o.key;
            }
            return comp;
        }

        public String toString() {
            return this.value + " (" + this.type + ")";
        }
    }
}

