/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QuickContextXmlParser
extends DefaultHandler {
    private static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
    private String virtualClasspath = "";

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String className;
        if ("Loader".equalsIgnoreCase(localName) && (className = attributes.getValue("className")) != null && ("org.apache.catalina.loader.VirtualWebappLoader".equals(className) || "org.apache.tomee.catalina.ProvisioningWebappLoader".equals(className))) {
            this.virtualClasspath = attributes.getValue("virtualClasspath");
        }
    }

    public Collection<URL> getAdditionalURLs() {
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (this.virtualClasspath != null) {
            StringTokenizer tkn = new StringTokenizer(this.virtualClasspath, ";");
            while (tkn.hasMoreTokens()) {
                String token = tkn.nextToken().trim();
                if (token.isEmpty()) continue;
                set.addAll(Files.listJars((String)ProvisioningUtil.realLocation((String)PropertyPlaceHolderHelper.simpleValue(token))));
            }
        }
        return set;
    }

    public static QuickContextXmlParser parse(File contextXml) {
        QuickContextXmlParser handler = new QuickContextXmlParser();
        try {
            SAXParser parser = FACTORY.newSAXParser();
            parser.parse(contextXml, (DefaultHandler)handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler;
    }

    static {
        FACTORY.setNamespaceAware(true);
        FACTORY.setValidating(false);
    }
}

