/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jws.HandlerChain;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.MTOM;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.core.webservices.JaxWsUtils;
import org.apache.openejb.core.webservices.WsdlResolver;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.HandlerChains;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.PortComponent;
import org.apache.openejb.jee.ServiceImplBean;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.ServletMapping;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.jee.Webservices;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.xml.sax.InputSource;

public class WsDeployer
implements DynamicDeployer {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, WsDeployer.class.getPackage().getName());

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            this.processPorts(ejbModule);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            this.processPorts(webModule);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            for (EnterpriseBean enterpriseBean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                this.resolveServiceRefs(ejbModule, (JndiConsumer)enterpriseBean);
            }
        }
        for (WebModule webModule : appModule.getWebModules()) {
            this.resolveServiceRefs(webModule, (JndiConsumer)webModule.getWebApp());
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            this.resolveServiceRefs(clientModule, (JndiConsumer)clientModule.getApplicationClient());
        }
        return appModule;
    }

    private void resolveServiceRefs(DeploymentModule module, JndiConsumer jndiConsumer) {
        for (ServiceRef serviceRef : jndiConsumer.getServiceRef()) {
            if (serviceRef.getServiceQname() != null || serviceRef.getWsdlFile() == null) continue;
            try {
                String wsdlFile = serviceRef.getWsdlFile();
                Definition definition = this.getWsdl(module, wsdlFile);
                Set serviceQNames = definition.getServices().keySet();
                if (serviceQNames.size() == 1) {
                    QName serviceQName = (QName)serviceQNames.iterator().next();
                    serviceRef.setServiceQname(serviceQName);
                    continue;
                }
                if (serviceQNames.isEmpty()) {
                    logger.error("The service-ref " + serviceRef.getName() + " must define service-qname because the wsdl-file " + serviceRef.getWsdlFile() + " does not constain any service definitions ");
                    continue;
                }
                logger.error("The service-ref " + serviceRef.getName() + " must define service-qname because the wsdl-file " + serviceRef.getWsdlFile() + " constain more then one service definitions " + serviceQNames);
            }
            catch (Exception e) {
                logger.error("Unable to read wsdl file " + serviceRef.getWsdlFile());
            }
        }
    }

    private void processPorts(WebModule webModule) throws OpenEJBException {
        Webservices webservices = webModule.getWebservices();
        TreeMap<String, PortComponent> portMap = new TreeMap<String, PortComponent>();
        if (webservices != null) {
            for (WebserviceDescription webserviceDescription : webservices.getWebserviceDescription()) {
                for (PortComponent portComponent : webserviceDescription.getPortComponent()) {
                    ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
                    if (serviceImplBean == null || serviceImplBean.getServletLink() == null) continue;
                    portMap.put(serviceImplBean.getServletLink(), portComponent);
                }
            }
        }
        WebApp webApp = webModule.getWebApp();
        TreeMap<String, ServletMapping> servletMappings = new TreeMap<String, ServletMapping>();
        for (ServletMapping servletMapping : webApp.getServletMapping()) {
            servletMappings.put(servletMapping.getServletName(), servletMapping);
        }
        for (Servlet servlet : webApp.getServlet()) {
            String className = servlet.getServletClass();
            if (className == null) continue;
            try {
                PortComponent portComponent;
                WebserviceDescription webserviceDescription;
                Class<?> clazz = webModule.getClassLoader().loadClass(className);
                if (!JaxWsUtils.isWebService(clazz)) continue;
                ServletMapping servletMapping = (ServletMapping)servletMappings.get(servlet.getServletName());
                String serviceName = JaxWsUtils.getServiceName(clazz);
                if (servletMapping == null) {
                    servletMapping = new ServletMapping();
                    servletMapping.setServletName(servlet.getServletName());
                    String location = "/" + serviceName;
                    servletMapping.getUrlPattern().add(location);
                    webApp.getServletMapping().add(servletMapping);
                }
                if (webservices == null) {
                    webservices = new Webservices();
                    webModule.setWebservices(webservices);
                }
                if ((webserviceDescription = (WebserviceDescription)webservices.getWebserviceDescriptionMap().get(serviceName)) == null) {
                    webserviceDescription = new WebserviceDescription();
                    webserviceDescription.setWebserviceDescriptionName(serviceName);
                    webservices.getWebserviceDescription().add(webserviceDescription);
                }
                if ((portComponent = (PortComponent)portMap.get(servlet.getServletName())) == null) {
                    portComponent = new PortComponent();
                    portComponent.setPortComponentName(clazz.getSimpleName());
                    ServiceImplBean serviceImplBean = new ServiceImplBean();
                    serviceImplBean.setServletLink(servlet.getServletName());
                    portComponent.setServiceImplBean(serviceImplBean);
                    webserviceDescription.getPortComponent().add(portComponent);
                }
                if (portComponent.getId() == null) {
                    portComponent.setId(webModule.getModuleId() + "." + servlet.getServletName());
                }
                if (webserviceDescription.getId() == null) {
                    webserviceDescription.setId(webModule.getModuleId() + "." + servlet.getServletName());
                }
                if (portComponent.getServiceEndpointInterface() == null) {
                    portComponent.setServiceEndpointInterface(JaxWsUtils.getServiceInterface(clazz));
                }
                if (portComponent.getWsdlPort() == null) {
                    portComponent.setWsdlPort(JaxWsUtils.getPortQName(clazz));
                }
                if (webserviceDescription.getWsdlFile() == null) {
                    webserviceDescription.setWsdlFile(JaxWsUtils.getServiceWsdlLocation(clazz, webModule.getClassLoader()));
                }
                if (portComponent.getWsdlService() == null) {
                    Definition definition = this.getWsdl(webModule, webserviceDescription.getWsdlFile());
                    if (definition != null && definition.getServices().size() == 1) {
                        QName serviceQName = (QName)definition.getServices().keySet().iterator().next();
                        portComponent.setWsdlService(serviceQName);
                    } else {
                        portComponent.setWsdlService(JaxWsUtils.getServiceQName(clazz));
                    }
                }
                if (portComponent.getProtocolBinding() == null) {
                    portComponent.setProtocolBinding(JaxWsUtils.getBindingUriFromAnn(clazz));
                }
                this.configMtomAnnotation(clazz, portComponent);
                if ("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(portComponent.getProtocolBinding()) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(portComponent.getProtocolBinding())) {
                    portComponent.setEnableMtom(Boolean.valueOf(true));
                }
                if (portComponent.getHandlerChains() != null) continue;
                HandlerChains handlerChains = WsDeployer.getHandlerChains(clazz, portComponent.getServiceEndpointInterface(), webModule.getClassLoader());
                portComponent.setHandlerChains(handlerChains);
            }
            catch (Exception e) {
                throw new OpenEJBException("Unable to load servlet class: " + className, e);
            }
        }
    }

    private void configMtomAnnotation(Class<?> clazz, PortComponent portComponent) {
        MTOM mtom = clazz.getAnnotation(MTOM.class);
        if (mtom != null) {
            if (portComponent.getEnableMtom() == null) {
                portComponent.setEnableMtom(Boolean.valueOf(mtom.enabled()));
            }
            if (portComponent.getMtomThreshold() == null) {
                portComponent.setMtomThreshold(Integer.valueOf(mtom.threshold()));
            }
        }
    }

    private void processPorts(EjbModule ejbModule) throws OpenEJBException {
        Webservices webservices = ejbModule.getWebservices();
        TreeMap<String, PortComponent> portMap = new TreeMap<String, PortComponent>();
        if (webservices != null) {
            for (WebserviceDescription webserviceDescription : webservices.getWebserviceDescription()) {
                for (PortComponent portComponent : webserviceDescription.getPortComponent()) {
                    ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
                    if (serviceImplBean == null || serviceImplBean.getEjbLink() == null) continue;
                    portMap.put(serviceImplBean.getEjbLink(), portComponent);
                }
            }
        }
        Map deploymentsByEjbName = ejbModule.getOpenejbJar().getDeploymentsByEjbName();
        for (EnterpriseBean enterpriseBean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            Definition definition;
            PortComponent portComponent;
            Class<?> ejbClass;
            EjbDeployment deployment;
            SessionBean sessionBean;
            WebserviceDescription webserviceDescription;
            if (!(enterpriseBean instanceof SessionBean) || (sessionBean = (SessionBean)enterpriseBean).getSessionType() == SessionType.STATEFUL || sessionBean.getSessionType() == SessionType.MANAGED || sessionBean.getServiceEndpoint() == null || (deployment = (EjbDeployment)deploymentsByEjbName.get(sessionBean.getEjbName())) == null) continue;
            try {
                ejbClass = ejbModule.getClassLoader().loadClass(sessionBean.getEjbClass());
            }
            catch (ClassNotFoundException e) {
                throw new OpenEJBException("Unable to load ejb class: " + sessionBean.getEjbClass(), e);
            }
            if (!JaxWsUtils.isWebService(ejbClass)) continue;
            if (webservices == null) {
                webservices = new Webservices();
                ejbModule.setWebservices(webservices);
            }
            if ((webserviceDescription = (WebserviceDescription)webservices.getWebserviceDescriptionMap().get(JaxWsUtils.getServiceName(ejbClass))) == null) {
                webserviceDescription = new WebserviceDescription();
                if (JaxWsUtils.isWebService(ejbClass)) {
                    webserviceDescription.setWebserviceDescriptionName(JaxWsUtils.getServiceName(ejbClass));
                }
                webservices.getWebserviceDescription().add(webserviceDescription);
            }
            if ((portComponent = (PortComponent)portMap.get(sessionBean.getEjbName())) == null) {
                portComponent = new PortComponent();
                if (webserviceDescription.getPortComponentMap().containsKey(JaxWsUtils.getPortQName(ejbClass).getLocalPart())) {
                    portComponent.setPortComponentName(sessionBean.getEjbName());
                } else {
                    portComponent.setPortComponentName(JaxWsUtils.getPortQName(ejbClass).getLocalPart());
                }
                webserviceDescription.getPortComponent().add(portComponent);
                ServiceImplBean serviceImplBean = new ServiceImplBean();
                serviceImplBean.setEjbLink(sessionBean.getEjbName());
                portComponent.setServiceImplBean(serviceImplBean);
                if (portComponent.getProtocolBinding() == null) {
                    portComponent.setProtocolBinding(JaxWsUtils.getBindingUriFromAnn(ejbClass));
                }
                this.configMtomAnnotation(ejbClass, portComponent);
                if ("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(portComponent.getProtocolBinding()) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(portComponent.getProtocolBinding())) {
                    portComponent.setEnableMtom(Boolean.valueOf(true));
                }
            }
            if (portComponent.getId() == null) {
                portComponent.setId(deployment.getDeploymentId());
            }
            if (webserviceDescription.getId() == null) {
                webserviceDescription.setId(deployment.getDeploymentId());
            }
            if (portComponent.getServiceEndpointInterface() == null) {
                portComponent.setServiceEndpointInterface(sessionBean.getServiceEndpoint());
            }
            if (!JaxWsUtils.isWebService(ejbClass)) continue;
            if (portComponent.getWsdlPort() == null) {
                portComponent.setWsdlPort(JaxWsUtils.getPortQName(ejbClass));
            }
            if (webserviceDescription.getWsdlFile() == null) {
                webserviceDescription.setWsdlFile(JaxWsUtils.getServiceWsdlLocation(ejbClass, ejbModule.getClassLoader()));
            }
            if (portComponent.getWsdlService() == null) {
                definition = this.getWsdl(ejbModule, webserviceDescription.getWsdlFile());
                if (definition != null && definition.getServices().size() == 1) {
                    QName serviceQName = (QName)definition.getServices().keySet().iterator().next();
                    portComponent.setWsdlService(serviceQName);
                } else {
                    portComponent.setWsdlService(JaxWsUtils.getServiceQName(ejbClass));
                }
            }
            if (portComponent.getLocation() == null && webserviceDescription.getWsdlFile() != null) {
                definition = this.getWsdl(ejbModule, webserviceDescription.getWsdlFile());
                String locationURI = this.getLocationFromWsdl(definition, portComponent);
                portComponent.setLocation(locationURI);
            }
            if (portComponent.getProtocolBinding() == null) {
                portComponent.setProtocolBinding(JaxWsUtils.getBindingUriFromAnn(ejbClass));
            }
            if (portComponent.getHandlerChains() != null) continue;
            HandlerChains handlerChains = WsDeployer.getHandlerChains(ejbClass, sessionBean.getServiceEndpoint(), ejbModule.getClassLoader());
            portComponent.setHandlerChains(handlerChains);
        }
    }

    private Definition getWsdl(DeploymentModule module, String wsdlFile) {
        if (wsdlFile == null) {
            return null;
        }
        Object object = module.getAltDDs().get(wsdlFile);
        if (object instanceof Definition) {
            return (Definition)object;
        }
        try {
            URL wsdlUrl;
            if (object instanceof URL) {
                wsdlUrl = (URL)object;
            } else {
                URL baseUrl = this.getBaseUrl(module);
                wsdlUrl = new URL(baseUrl, wsdlFile);
            }
            Definition definition = WsDeployer.readWsdl(wsdlUrl);
            module.getAltDDs().put(wsdlFile, definition);
            return definition;
        }
        catch (Exception e) {
            logger.error("Unable to read wsdl file " + wsdlFile);
            return null;
        }
    }

    public static Definition readWsdl(URL url) throws OpenEJBException {
        Definition definition;
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", true);
            reader.setFeature("javax.wsdl.importDocuments", true);
            WsdlResolver wsdlResolver = new WsdlResolver(new URL(url, ".").toExternalForm(), new InputSource(IO.read((URL)url)));
            definition = reader.readWSDL((WSDLLocator)wsdlResolver);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the wsdl file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the wsdl file: " + url.toExternalForm(), e);
        }
        return definition;
    }

    private URL getBaseUrl(DeploymentModule module) throws MalformedURLException {
        File file = new File(module.getJarLocation());
        if (!file.exists()) {
            return new URL(module.getJarLocation());
        }
        URL baseUrl = file.toURI().toURL();
        if (file.isFile()) {
            baseUrl = new URL("jar", null, baseUrl.toExternalForm() + "!/");
        }
        return baseUrl;
    }

    private String getLocationFromWsdl(Definition definition, PortComponent portComponent) {
        if (definition == null) {
            return null;
        }
        try {
            Service service = definition.getService(portComponent.getWsdlService());
            if (service == null) {
                return null;
            }
            Port port = service.getPort(portComponent.getWsdlPort().getLocalPart());
            if (port == null) {
                return null;
            }
            for (Object element : port.getExtensibilityElements()) {
                if (element instanceof SOAPAddress) {
                    SOAPAddress soapAddress = (SOAPAddress)element;
                    URI uri = URLs.uri(soapAddress.getLocationURI());
                    return uri.getPath();
                }
                if (!(element instanceof HTTPAddress)) continue;
                HTTPAddress httpAddress = (HTTPAddress)element;
                URI uri = URLs.uri(httpAddress.getLocationURI());
                return uri.getPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static HandlerChains getHandlerChains(Class<?> declaringClass, String serviceEndpoint, ClassLoader classLoader) throws OpenEJBException {
        HandlerChain handlerChain = declaringClass.getAnnotation(HandlerChain.class);
        if (handlerChain == null && serviceEndpoint != null) {
            try {
                declaringClass = classLoader.loadClass(serviceEndpoint);
                handlerChain = declaringClass.getAnnotation(HandlerChain.class);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        HandlerChains handlerChains = null;
        if (handlerChain != null) {
            try {
                URL handlerFileURL = declaringClass.getResource(handlerChain.file());
                handlerChains = ReadDescriptors.readHandlerChains(handlerFileURL);
            }
            catch (Throwable e) {
                throw new OpenEJBException("Unable to load handler chain file: " + handlerChain.file(), e);
            }
        }
        return handlerChains;
    }
}

