/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.Flushable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.CommonDataSource;
import org.apache.openejb.resource.jdbc.DataSourceFactory;
import org.apache.openejb.resource.jdbc.managed.local.ManagedDataSource;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class FlushableDataSourceHandler
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, FlushableDataSourceHandler.class);
    private final FlushConfig config;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile CommonDataSource delegate;

    public FlushableDataSourceHandler(CommonDataSource original, FlushConfig config) {
        this.config = config;
        this.delegate = original;
    }

    private void createANewDelegate() {
        CommonDataSource old = this.delegate;
        try {
            this.delegate = DataSourceFactory.create(this.config.name, this.config.configuredManaged, this.config.impl, this.config.definition, this.config.maxWaitTime, this.config.timeBetweenEvictionRuns, this.config.minEvictableIdleTime);
        }
        catch (Exception e) {
            LOGGER.error("Can't recreate the datasource, keeping old one", e);
            this.delegate = old;
            return;
        }
        if (DataSourceFactory.knows(old)) {
            try {
                DataSourceFactory.destroy(old);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ManagedDataSource.class.isInstance(old)) {
                ((ManagedDataSource)ManagedDataSource.class.cast(old)).clean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class == method.getDeclaringClass() && "hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if (Flushable.class == method.getDeclaringClass()) {
            Lock l = this.lock.writeLock();
            l.lock();
            try {
                this.createANewDelegate();
                if (Flushable.class.isInstance(this.delegate)) {
                    ((Flushable)Flushable.class.cast(this.delegate)).flush();
                }
            }
            finally {
                l.unlock();
            }
            return null;
        }
        Lock l = this.lock.readLock();
        l.lock();
        try {
            Object object = method.invoke((Object)this.delegate, args);
            return object;
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        finally {
            l.unlock();
        }
    }

    public CommonDataSource getDelegate() {
        return this.delegate;
    }

    public static class FlushConfig {
        public final String name;
        public final boolean configuredManaged;
        public final Class impl;
        public final String definition;
        public final Duration maxWaitTime;
        public final Duration timeBetweenEvictionRuns;
        public final Duration minEvictableIdleTime;

        public FlushConfig(String name, boolean configuredManaged, Class impl, String definition, Duration maxWaitTime, Duration timeBetweenEvictionRuns, Duration minEvictableIdleTime) {
            this.name = name;
            this.impl = impl;
            this.configuredManaged = configuredManaged;
            this.definition = definition;
            this.maxWaitTime = maxWaitTime;
            this.timeBetweenEvictionRuns = timeBetweenEvictionRuns;
            this.minEvictableIdleTime = minEvictableIdleTime;
        }
    }
}

