/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.util;

import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;

/**
 * @version $Rev: 1607852 $ $Date: 2014-07-04 15:32:03 +0200 (Fri, 04 Jul 2014) $
 */
public class OptionsLog implements Options.Log {

    private final Logger logger;

    public OptionsLog() {
        this(Logger.getInstance(LogCategory.OPENEJB.createChild("options"), OptionsLog.class));
    }

    public OptionsLog(final Logger logger) {
        this.logger = logger;
    }

    public static void install() {
        SystemInstance.get().getOptions().setLogger(new OptionsLog());
    }

    public boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return logger.isInfoEnabled();
    }

    public boolean isWarningEnabled() {
        return logger.isWarningEnabled();
    }

    public void debug(final String message) {
        logger.debug(message);
    }

    public void debug(final String message, final Throwable t) {
        logger.debug(message, t);
    }

    public void info(final String message) {
        logger.info(message);
    }

    public void info(final String message, final Throwable t) {
        logger.info(message, t);
    }

    public void warning(final String message) {
        logger.warning(message);
    }

    public void warning(final String message, final Throwable t) {
        logger.warning(message, t);
    }
}
