/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Computable;
import org.apache.openejb.util.JuliLogStreamFactory;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.LogStream;
import org.apache.openejb.util.LogStreamAsync;
import org.apache.openejb.util.LogStreamFactory;
import org.apache.openejb.util.Memoizer;
import org.apache.openejb.util.Slf4jLogStreamFactory;

public class Logger {
    private static final String SUFFIX = ".Messages";
    private static final String OPENEJB = "org.apache.openejb";
    private static LogStreamFactory logStreamFactory;
    private static final Computable<String, String> heirarchyResolver;
    private static final Computable<String, ResourceBundle> bundleResolver;
    private static final Computable<Object[], Logger> loggerResolver;
    private static final Computable<String, MessageFormat> messageFormatResolver;
    private static final Computable<String, String> heirarchyCache;
    private static final Computable<String, ResourceBundle> bundleCache;
    private static final Computable<Object[], Logger> loggerCache;
    private static final Computable<String, MessageFormat> messageFormatCache;
    private final LogCategory category;
    private final LogStream logStream;
    private final String baseName;
    private static Boolean isLog4j;

    public static String delegateClass() {
        if (logStreamFactory == null) {
            throw new IllegalStateException("Call this method after having configured the logger");
        }
        return logStreamFactory.getClass().getName();
    }

    public static synchronized void configure() {
        if (logStreamFactory != null) {
            return;
        }
        String factoryName = SystemInstance.get().getOptions().get("openejb.log.factory", JuliLogStreamFactory.class.getName());
        if ("jul".equalsIgnoreCase(factoryName) || "juli".equalsIgnoreCase(factoryName)) {
            factoryName = JuliLogStreamFactory.class.getName();
        } else if ("slf4j".equalsIgnoreCase(factoryName)) {
            factoryName = Slf4jLogStreamFactory.class.getName();
        } else if ("log4j".equalsIgnoreCase(factoryName)) {
            if (Logger.exists("org.apache.log4j.Logger")) {
                factoryName = "org.apache.openejb.util.Log4jLogStreamFactory";
            } else {
                System.out.println("Cannot respect 'openejb.log.factory=log4j' setting as Log4j is not in the classpath.");
            }
        } else if ("pax".equalsIgnoreCase(factoryName)) {
            factoryName = "org.apache.openejb.util.PaxLogStreamFactory";
        }
        if (factoryName != null) {
            logStreamFactory = Logger.createFactory(factoryName);
        }
        if (Logger.isLog4jImplied()) {
            logStreamFactory = Logger.createFactory("org.apache.openejb.util.Log4jLogStreamFactory");
        }
        if (logStreamFactory == null) {
            logStreamFactory = new JuliLogStreamFactory();
        }
        Logger.checkForIgnoredLog4jConfig();
    }

    private static void checkForIgnoredLog4jConfig() {
        if (logStreamFactory.getClass().getName().equals("org.apache.openejb.util.Log4jLogStreamFactory")) {
            return;
        }
        try {
            Properties configFile = Logger.log4j(Logger.loadLoggingProperties());
            Properties systemProperties = Logger.log4j(SystemInstance.get().getProperties());
            if (configFile.size() == 0 && systemProperties.size() == 0) {
                return;
            }
            LogStream stream = logStreamFactory.createLogStream(LogCategory.OPENEJB);
            stream.warn("Log4j not installed. The following properties will be ignored.");
            String format = "Ignored %s property '%s'";
            for (Object key : configFile.keySet()) {
                stream.warn(String.format("Ignored %s property '%s'", "conf/logging.properties", key));
            }
            for (Object key : systemProperties.keySet()) {
                stream.warn(String.format("Ignored %s property '%s'", "Property overrides", key));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static LogStreamFactory createFactory(String factoryName) {
        Class<?> factoryClass = Logger.load(factoryName);
        if (factoryClass == null) {
            return null;
        }
        try {
            return (LogStreamFactory)factoryClass.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<?> load(String factoryName) {
        try {
            ClassLoader classLoader = Logger.class.getClassLoader();
            return classLoader.loadClass(factoryName);
        }
        catch (Throwable e) {
            try {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                return contextClassLoader.loadClass(factoryName);
            }
            catch (Throwable e1) {
                try {
                    return Class.forName(factoryName);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        }
    }

    public static Logger getInstance(LogCategory category, String baseName) {
        try {
            return loggerCache.compute(new Object[]{category, baseName});
        }
        catch (InterruptedException e) {
            LogStream logStream = logStreamFactory.createLogStream(category);
            return new Logger(category, logStream, baseName);
        }
    }

    public Logger(LogCategory category, LogStream logStream, String baseName) {
        this.category = category;
        this.baseName = baseName;
        this.logStream = "true".equals(SystemInstance.get().getProperty("openejb.log.async", "false")) ? new LogStreamAsync(logStream) : logStream;
    }

    public static Logger getInstance(LogCategory category, Class clazz) {
        return Logger.getInstance(category, Logger.packageName(clazz));
    }

    private static String packageName(Class clazz) {
        String name = clazz.getName();
        return name.substring(0, name.lastIndexOf("."));
    }

    public static boolean isLog4jImplied() {
        if (null == isLog4j) {
            isLog4j = false;
            ArrayList<String> locations = new ArrayList<String>();
            Properties configFile = Logger.log4j(Logger.loadLoggingProperties());
            Properties systemProperties = Logger.log4j(SystemInstance.get().getProperties());
            if (configFile.size() > 0) {
                locations.add("conf/logging.properties");
            }
            if (systemProperties.size() > 0) {
                locations.add("Properties overrides");
            }
            if (locations.size() > 0 && Logger.exists("org.apache.log4j.Logger")) {
                isLog4j = true;
            }
        }
        return isLog4j;
    }

    private static boolean exists(String s) {
        return Logger.load(s) != null;
    }

    private static Properties log4j(Properties system) {
        Properties properties = new Properties();
        for (Map.Entry<Object, Object> entry : system.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("log4j.") || key.equals("log4j.configuration")) continue;
            properties.put(key, entry.getValue());
        }
        return properties;
    }

    private static Properties loadLoggingProperties() {
        try {
            File conf = SystemInstance.get().getConf(null);
            File file = new File(conf, "logging.properties");
            return IO.readProperties((File)file);
        }
        catch (IOException e) {
            return new Properties();
        }
    }

    public Logger getChildLogger(String child) {
        return Logger.getInstance(this.category.createChild(child), this.baseName);
    }

    private String formatMessage(String message, Object ... args) {
        if (args.length == 0) {
            return message;
        }
        try {
            MessageFormat mf = messageFormatCache.compute(message);
            return mf.format(args);
        }
        catch (Exception e) {
            return "Error in formatting message " + message;
        }
    }

    public boolean isDebugEnabled() {
        return this.logStream.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logStream.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logStream.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logStream.isInfoEnabled();
    }

    public boolean isWarningEnabled() {
        return this.logStream.isWarnEnabled();
    }

    public boolean isLevelEnable(String level2) {
        if ("info".equals(level2.toLowerCase())) {
            return this.isInfoEnabled();
        }
        if ("debug".equals(level2.toLowerCase())) {
            return this.isDebugEnabled();
        }
        if ("warning".equals(level2.toLowerCase())) {
            return this.isWarningEnabled();
        }
        if ("fatal".equals(level2.toLowerCase())) {
            return this.isFatalEnabled();
        }
        if ("error".equals(level2.toLowerCase())) {
            return this.isErrorEnabled();
        }
        return false;
    }

    public void log(String level2, String message) {
        if ("info".equals(level2.toLowerCase())) {
            this.info(message);
        } else if ("debug".equals(level2.toLowerCase())) {
            this.debug(message);
        } else if ("warning".equals(level2.toLowerCase())) {
            this.warning(message);
        } else if ("fatal".equals(level2.toLowerCase())) {
            this.fatal(message);
        } else if ("error".equals(level2.toLowerCase())) {
            this.error(message);
        }
    }

    public String debug(String message) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.debug(msg);
            return msg;
        }
        return message;
    }

    public String debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.debug(msg);
            return msg;
        }
        return message;
    }

    public String debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.debug(msg, t);
            return msg;
        }
        return message;
    }

    public String debug(String message, Throwable t, Object ... args) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.debug(msg, t);
            return msg;
        }
        return message;
    }

    public String error(String message) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.error(msg);
            return msg;
        }
        return message;
    }

    public String error(String message, Object ... args) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.error(msg);
            return msg;
        }
        return message;
    }

    public String error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.error(msg, t);
            return msg;
        }
        return message;
    }

    public String error(String message, Throwable t, Object ... args) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.error(msg, t);
            return msg;
        }
        return message;
    }

    public String fatal(String message) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.fatal(msg);
            return msg;
        }
        return message;
    }

    public String fatal(String message, Object ... args) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.fatal(msg);
            return msg;
        }
        return message;
    }

    public String fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.fatal(msg, t);
            return msg;
        }
        return message;
    }

    public String fatal(String message, Throwable t, Object ... args) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.fatal(msg, t);
            return msg;
        }
        return message;
    }

    public String info(String message) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.info(msg);
            return msg;
        }
        return message;
    }

    public String info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.info(msg);
            return msg;
        }
        return message;
    }

    public String info(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.info(msg, t);
            return msg;
        }
        return message;
    }

    public String info(String message, Throwable t, Object ... args) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.info(msg, t);
            return msg;
        }
        return message;
    }

    public String warning(String message) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.warn(msg);
            return msg;
        }
        return message;
    }

    public String warning(String message, Object ... args) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.warn(msg);
            return msg;
        }
        return message;
    }

    public String warning(String message, Throwable t) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.warn(msg, t);
            return msg;
        }
        return message;
    }

    public String warning(String message, Throwable t, Object ... args) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.warn(msg, t);
            return msg;
        }
        return message;
    }

    private String getMessage(String key, String baseName) {
        try {
            ResourceBundle bundle = bundleCache.compute(baseName);
            if (bundle != null) {
                try {
                    return bundle.getString(key);
                }
                catch (MissingResourceException e) {
                    String parentName = heirarchyCache.compute(baseName);
                    if (parentName == null) {
                        return key;
                    }
                    return this.getMessage(key, parentName);
                }
            }
            String parentName = heirarchyCache.compute(baseName);
            if (parentName == null) {
                return key;
            }
            return this.getMessage(key, parentName);
        }
        catch (InterruptedException interruptedException) {
            return key;
        }
    }

    static {
        Logger.configure();
        heirarchyResolver = new Computable<String, String>(){

            @Override
            public String compute(String key) throws InterruptedException {
                int index = key.lastIndexOf(".");
                String parent = key.substring(0, index);
                if (parent.contains(Logger.OPENEJB)) {
                    return parent;
                }
                return null;
            }
        };
        bundleResolver = new Computable<String, ResourceBundle>(){

            @Override
            public ResourceBundle compute(String baseName) throws InterruptedException {
                try {
                    return ResourceBundle.getBundle(baseName + Logger.SUFFIX);
                }
                catch (MissingResourceException e) {
                    return null;
                }
            }
        };
        loggerResolver = new Computable<Object[], Logger>(){

            @Override
            public Logger compute(Object[] args) throws InterruptedException {
                LogCategory category = (LogCategory)args[0];
                LogStream logStream = logStreamFactory.createLogStream(category);
                String baseName = (String)args[1];
                return new Logger(category, logStream, baseName);
            }
        };
        messageFormatResolver = new Computable<String, MessageFormat>(){

            @Override
            public MessageFormat compute(String message) throws InterruptedException {
                return new MessageFormat(message);
            }
        };
        heirarchyCache = new Memoizer<String, String>(heirarchyResolver);
        bundleCache = new Memoizer<String, ResourceBundle>(bundleResolver);
        loggerCache = new Memoizer<Object[], Logger>(loggerResolver);
        messageFormatCache = new Memoizer<String, MessageFormat>(messageFormatResolver);
    }
}

