/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ejb.embeddable.EJBContainer;
import org.apache.openejb.Extensions;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.Vendor;
import org.apache.openejb.api.Proxy;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.BmpEntityContainerInfo;
import org.apache.openejb.assembler.classic.ClientInfo;
import org.apache.openejb.assembler.classic.CmpEntityContainerInfo;
import org.apache.openejb.assembler.classic.ConnectionManagerInfo;
import org.apache.openejb.assembler.classic.ConnectorInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.ContainerSystemInfo;
import org.apache.openejb.assembler.classic.DeploymentExceptionManager;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.FacilitiesInfo;
import org.apache.openejb.assembler.classic.HandlerChainInfo;
import org.apache.openejb.assembler.classic.HandlerInfo;
import org.apache.openejb.assembler.classic.JndiContextInfo;
import org.apache.openejb.assembler.classic.ManagedContainerInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.OpenEjbConfigurationFactory;
import org.apache.openejb.assembler.classic.ProxyFactoryInfo;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.SecurityServiceInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.SingletonSessionContainerInfo;
import org.apache.openejb.assembler.classic.StatefulSessionContainerInfo;
import org.apache.openejb.assembler.classic.StatelessSessionContainerInfo;
import org.apache.openejb.assembler.classic.TransactionServiceInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.component.ClassLoaderEnricher;
import org.apache.openejb.config.ActivationConfigPropertyOverride;
import org.apache.openejb.config.AnnotationDeployer;
import org.apache.openejb.config.AppContextConfigDeployer;
import org.apache.openejb.config.AppInfoBuilder;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ApplicationProperties;
import org.apache.openejb.config.ApplyOpenejbJar;
import org.apache.openejb.config.AutoConfig;
import org.apache.openejb.config.AutoDeployer;
import org.apache.openejb.config.BeanProperties;
import org.apache.openejb.config.CleanEnvEntries;
import org.apache.openejb.config.ClearEmptyMappedName;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.CmpJpaConversion;
import org.apache.openejb.config.ConfigUtils;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.ConvertDataSourceDefinitions;
import org.apache.openejb.config.DebuggableVmHackery;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.GeneratedClientModules;
import org.apache.openejb.config.GeronimoMappedName;
import org.apache.openejb.config.InitEjbDeployments;
import org.apache.openejb.config.LegacyProcessor;
import org.apache.openejb.config.LinkBuiltInTypes;
import org.apache.openejb.config.MappedNameBuilder;
import org.apache.openejb.config.ModuleProperties;
import org.apache.openejb.config.NoSuchProviderException;
import org.apache.openejb.config.OpenEjb2Conversion;
import org.apache.openejb.config.OutputGeneratedDescriptors;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.RemoveWebServices;
import org.apache.openejb.config.Service;
import org.apache.openejb.config.ServiceUtils;
import org.apache.openejb.config.SunConversion;
import org.apache.openejb.config.SystemApps;
import org.apache.openejb.config.SystemPropertiesOverride;
import org.apache.openejb.config.ValidateModules;
import org.apache.openejb.config.ValidationFailedException;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WlsConversion;
import org.apache.openejb.config.WsDeployer;
import org.apache.openejb.config.sys.AbstractService;
import org.apache.openejb.config.sys.AdditionalDeployments;
import org.apache.openejb.config.sys.ConnectionManager;
import org.apache.openejb.config.sys.Container;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.config.sys.JndiProvider;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.config.sys.ProxyFactory;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.SecurityService;
import org.apache.openejb.config.sys.ServiceProvider;
import org.apache.openejb.config.sys.TransactionManager;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.Handler;
import org.apache.openejb.jee.HandlerChain;
import org.apache.openejb.jee.HandlerChains;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.resource.jdbc.DataSourceFactory;
import org.apache.openejb.resource.jdbc.pool.DataSourceCreator;
import org.apache.openejb.resource.jdbc.pool.DefaultDataSourceCreator;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.openejb.util.SuperProperties;
import org.apache.openejb.util.URISupport;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.openejb.util.proxy.QueryProxy;
import org.apache.xbean.finder.MetaAnnotatedClass;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class ConfigurationFactory
implements OpenEjbConfigurationFactory {
    public static final String OPENEJB_JDBC_DATASOURCE_CREATOR = "openejb.jdbc.datasource-creator";
    public static final String ADDITIONAL_DEPLOYMENTS = "conf/deployments.xml";
    static final String CONFIGURATION_PROPERTY = "openejb.configuration";
    static final String CONF_FILE_PROPERTY = "openejb.conf.file";
    private static final String DEBUGGABLE_VM_HACKERY_PROPERTY = "openejb.debuggable-vm-hackery";
    protected static final String VALIDATION_SKIP_PROPERTY = "openejb.validation.skip";
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, ConfigurationFactory.class);
    private static final Messages messages = new Messages(ConfigurationFactory.class);
    private static final String IGNORE_DEFAULT_VALUES_PROP = "IgnoreDefaultValues";
    private static final boolean WSDL4J_AVAILABLE = ConfigurationFactory.exists("javax.wsdl.xml.WSDLLocator");
    private String configLocation;
    private OpenEjbConfiguration sys;
    private Openejb openejb;
    private final DynamicDeployer deployer;
    private final DeploymentLoader deploymentLoader;
    private final boolean offline;
    private final boolean serviceTypeIsAdjustable;
    private static final String CLASSPATH_AS_EAR = "openejb.deployments.classpath.ear";
    static final String WEBSERVICES_ENABLED = "openejb.webservices.enabled";
    static final String OFFLINE_PROPERTY = "openejb.offline";
    private static final Map<Class<? extends ServiceInfo>, DefaultService> defaultProviders = new HashMap<Class<? extends ServiceInfo>, DefaultService>();
    private static final Map<Class<? extends ServiceInfo>, Class<? extends Service>> types = new HashMap<Class<? extends ServiceInfo>, Class<? extends Service>>();
    private static final Map<String, Class<? extends ContainerInfo>> containerTypes;

    public ConfigurationFactory() {
        this(!ConfigurationFactory.shouldAutoDeploy());
    }

    private static boolean exists(String s) {
        try {
            ConfigurationFactory.class.getClassLoader().loadClass(s);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private static boolean shouldAutoDeploy() {
        Options options;
        boolean b = (options = SystemInstance.get().getOptions()).get(OFFLINE_PROPERTY, false);
        return options.get("tomee.autoconfig", !b);
    }

    public ConfigurationFactory(boolean offline) {
        this(offline, (DynamicDeployer)null);
    }

    public ConfigurationFactory(boolean offline, DynamicDeployer preAutoConfigDeployer) {
        this.offline = offline;
        this.serviceTypeIsAdjustable = SystemInstance.get().getOptions().get("openejb.service-type-adjustement", true);
        this.deploymentLoader = new DeploymentLoader();
        LocalMBeanServer.reset();
        Options options = SystemInstance.get().getOptions();
        if (SystemInstance.get().getComponent(DataSourceCreator.class) == null) {
            String creator = options.get(OPENEJB_JDBC_DATASOURCE_CREATOR, (String)null);
            if (creator == null) {
                SystemInstance.get().setComponent(DataSourceCreator.class, (Object)new DefaultDataSourceCreator());
            } else {
                try {
                    SystemInstance.get().setComponent(DataSourceCreator.class, (Object)DataSourceFactory.creator(creator, false));
                }
                catch (Exception e) {
                    logger.error("can't load " + creator + " will use the default creator", e);
                    SystemInstance.get().setComponent(DataSourceCreator.class, (Object)new DefaultDataSourceCreator());
                }
            }
        }
        if (SystemInstance.get().getComponent(ClassLoaderEnricher.class) == null) {
            SystemInstance.get().setComponent(ClassLoaderEnricher.class, (Object)new ClassLoaderEnricher());
        }
        SystemInstance.get().setComponent(ConfigurationFactory.class, (Object)this);
        AnnotationDeployer annotationDeployer = new AnnotationDeployer();
        BeanProperties beanProperties = new BeanProperties();
        AppContextConfigDeployer appContextConfigDeployer = new AppContextConfigDeployer(annotationDeployer.getEnvEntriesPropertiesDeployer(), beanProperties);
        Chain chain = new Chain();
        chain.add(new SystemPropertiesOverride());
        chain.add(new GeneratedClientModules.Add());
        chain.add(new ReadDescriptors());
        chain.add(appContextConfigDeployer);
        chain.add(new ApplicationProperties());
        chain.add(new ModuleProperties());
        chain.add(new LegacyProcessor());
        chain.add(annotationDeployer);
        chain.add(beanProperties);
        chain.add(new ProxyBeanClassUpdate());
        chain.add(new GeneratedClientModules.Prune());
        chain.add(new ClearEmptyMappedName());
        if (!options.get(VALIDATION_SKIP_PROPERTY, false)) {
            chain.add(new ValidateModules());
        } else {
            DeploymentLoader.logger.info("validationDisabled", VALIDATION_SKIP_PROPERTY);
        }
        chain.add(new InitEjbDeployments());
        if (options.get(DEBUGGABLE_VM_HACKERY_PROPERTY, false)) {
            chain.add(new DebuggableVmHackery());
        }
        if (options.get(WEBSERVICES_ENABLED, true) && WSDL4J_AVAILABLE) {
            chain.add(new WsDeployer());
        } else {
            chain.add(new RemoveWebServices());
        }
        chain.add(new CmpJpaConversion());
        Set support = SystemInstance.get().getOptions().getAll("openejb.vendor.config", (Enum[])Vendor.values());
        if (support.contains((Object)Vendor.GERONIMO) || SystemInstance.get().hasProperty("openejb.geronimo")) {
            chain.add(new OpenEjb2Conversion());
        }
        if (support.contains((Object)Vendor.GLASSFISH)) {
            chain.add(new SunConversion());
        }
        if (support.contains((Object)Vendor.WEBLOGIC)) {
            chain.add(new WlsConversion());
        }
        if (SystemInstance.get().hasProperty("openejb.geronimo")) {
            chain.add(new GeronimoMappedName());
        }
        if (null != preAutoConfigDeployer) {
            chain.add(preAutoConfigDeployer);
        }
        chain.add(new ConvertDataSourceDefinitions());
        chain.add(new CleanEnvEntries());
        chain.add(new LinkBuiltInTypes());
        if (offline) {
            AutoConfig autoConfig = new AutoConfig(this);
            autoConfig.autoCreateResources(false);
            autoConfig.autoCreateContainers(false);
            chain.add(autoConfig);
        } else {
            chain.add(new AutoConfig(this));
        }
        chain.add(new ApplyOpenejbJar());
        chain.add(new MappedNameBuilder());
        chain.add(new ActivationConfigPropertyOverride());
        chain.add(new OutputGeneratedDescriptors());
        this.deployer = chain;
    }

    public ConfigurationFactory(boolean offline, OpenEjbConfiguration configuration) {
        this(offline, (DynamicDeployer)null, configuration);
    }

    public ConfigurationFactory(boolean offline, DynamicDeployer preAutoConfigDeployer, OpenEjbConfiguration configuration) {
        this(offline, preAutoConfigDeployer);
        this.sys = configuration;
    }

    public ConfigurationFactory(boolean offline, Chain deployerChain, OpenEjbConfiguration configuration) {
        this.offline = offline;
        this.deploymentLoader = new DeploymentLoader();
        this.deployer = deployerChain;
        this.sys = configuration;
        this.serviceTypeIsAdjustable = true;
    }

    public static List<HandlerChainInfo> toHandlerChainInfo(HandlerChains chains) {
        ArrayList<HandlerChainInfo> handlerChains = new ArrayList<HandlerChainInfo>();
        if (chains == null) {
            return handlerChains;
        }
        for (HandlerChain handlerChain : chains.getHandlerChain()) {
            HandlerChainInfo handlerChainInfo = new HandlerChainInfo();
            handlerChainInfo.serviceNamePattern = handlerChain.getServiceNamePattern();
            handlerChainInfo.portNamePattern = handlerChain.getPortNamePattern();
            handlerChainInfo.protocolBindings.addAll(handlerChain.getProtocolBindings());
            for (Handler handler : handlerChain.getHandler()) {
                HandlerInfo handlerInfo = new HandlerInfo();
                handlerInfo.handlerName = handler.getHandlerName();
                handlerInfo.handlerClass = handler.getHandlerClass();
                handlerInfo.soapHeaders.addAll(handler.getSoapHeader());
                handlerInfo.soapRoles.addAll(handler.getSoapRole());
                for (ParamValue param : handler.getInitParam()) {
                    handlerInfo.initParams.setProperty(param.getParamName(), param.getParamValue());
                }
                handlerChainInfo.handlers.add(handlerInfo);
            }
            handlerChains.add(handlerChainInfo);
        }
        return handlerChains;
    }

    @Override
    public void init(Properties props) throws OpenEJBException {
        this.configLocation = props.getProperty(CONF_FILE_PROPERTY);
        if (this.configLocation == null) {
            this.configLocation = props.getProperty(CONFIGURATION_PROPERTY);
        }
        this.configLocation = ConfigUtils.searchForConfiguration(this.configLocation);
        if (this.configLocation != null) {
            logger.info("openejb configuration file is '" + this.configLocation + "'");
            props.setProperty(CONFIGURATION_PROPERTY, this.configLocation);
        }
    }

    protected void install(ContainerInfo serviceInfo) throws OpenEJBException {
        if (this.sys != null) {
            this.sys.containerSystem.containers.add(serviceInfo);
        } else if (!this.offline) {
            Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
            assembler.createContainer(serviceInfo);
        }
    }

    protected void install(ResourceInfo serviceInfo) throws OpenEJBException {
        if (this.sys != null) {
            this.sys.facilities.resources.add(serviceInfo);
        } else if (!this.offline) {
            Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
            assembler.createResource(serviceInfo);
        }
    }

    public OpenEjbConfiguration getOpenEjbConfiguration(File configuartionFile) throws OpenEJBException {
        if (configuartionFile != null) {
            return this.getOpenEjbConfiguration(JaxbOpenejb.readConfig(configuartionFile.getAbsolutePath()));
        }
        return this.getOpenEjbConfiguration((Openejb)null);
    }

    public OpenEjbConfiguration getOpenEjbConfiguration(Openejb providedConf) throws OpenEJBException {
        AppInfo appInfo;
        ServiceInfo info;
        if (this.sys != null) {
            return this.sys;
        }
        this.openejb = providedConf != null ? providedConf : (this.configLocation != null ? JaxbOpenejb.readConfig(this.configLocation) : JaxbOpenejb.createOpenejb());
        ConfigurationFactory.loadPropertiesDeclaredConfiguration(this.openejb);
        this.sys = new OpenEjbConfiguration();
        this.sys.containerSystem = new ContainerSystemInfo();
        this.sys.facilities = new FacilitiesInfo();
        for (org.apache.openejb.config.sys.Service service : this.openejb.getServices()) {
            info = this.configureService(service, ServiceInfo.class);
            this.sys.facilities.services.add(info);
        }
        for (JndiProvider provider : this.openejb.getJndiProvider()) {
            info = this.configureService(provider, JndiContextInfo.class);
            this.sys.facilities.remoteJndiContexts.add((JndiContextInfo)info);
        }
        this.sys.facilities.securityService = this.configureService(this.openejb.getSecurityService(), SecurityServiceInfo.class);
        this.sys.facilities.transactionService = this.configureService(this.openejb.getTransactionManager(), TransactionServiceInfo.class);
        ArrayList<ResourceInfo> resources = new ArrayList<ResourceInfo>();
        for (Resource resource : this.openejb.getResource()) {
            ResourceInfo resourceInfo = this.configureService(resource, ResourceInfo.class);
            resources.add(resourceInfo);
        }
        Collections.sort(resources, new ResourceInfoComparator(resources));
        this.sys.facilities.resources.addAll(resources);
        if (this.openejb.getProxyFactory() != null) {
            this.sys.facilities.intraVmServer = this.configureService(this.openejb.getProxyFactory(), ProxyFactoryInfo.class);
        }
        for (Container declaration : this.openejb.getContainer()) {
            ContainerInfo info2 = this.createContainerInfo(declaration);
            this.sys.containerSystem.containers.add(info2);
        }
        List<File> declaredApps = this.getDeclaredApps();
        for (File jarFile : declaredApps) {
            try {
                appInfo = this.configureApplication(jarFile);
                this.sys.containerSystem.applications.add(appInfo);
            }
            catch (OpenEJBException alreadyHandled) {
                DeploymentExceptionManager exceptionManager = (DeploymentExceptionManager)SystemInstance.get().getComponent(DeploymentExceptionManager.class);
                if (exceptionManager == null) continue;
                exceptionManager.pushDelpoymentException(alreadyHandled);
            }
        }
        boolean embedded = SystemInstance.get().hasProperty(EJBContainer.class.getName());
        Options options = SystemInstance.get().getOptions();
        if (options.get("openejb.system.apps", false)) {
            try {
                appInfo = this.configureApplication(new AppModule((DeploymentModule[])new EjbModule[]{SystemApps.getSystemModule()}));
                appInfo.properties.put("openejb.cdi.activated", "false");
                this.sys.containerSystem.applications.add(appInfo);
            }
            catch (OpenEJBException e) {
                logger.error("Unable to load the system applications.", e);
            }
        } else if (options.get("openejb.deployments.classpath", !embedded)) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ArrayList<File> jarFiles = this.getModulesFromClassPath(declaredApps, classLoader);
            String appId = "classpath.ear";
            boolean classpathAsEar = options.get(CLASSPATH_AS_EAR, true);
            try {
                if (classpathAsEar && !jarFiles.isEmpty()) {
                    AppInfo appInfo2 = this.configureApplication(classLoader, "classpath.ear", jarFiles);
                    this.sys.containerSystem.applications.add(appInfo2);
                } else {
                    for (File jarFile : jarFiles) {
                        AppInfo appInfo3 = this.configureApplication(jarFile);
                        this.sys.containerSystem.applications.add(appInfo3);
                    }
                }
                if (jarFiles.size() == 0) {
                    logger.warning("config.noModulesFoundToDeploy");
                }
            }
            catch (OpenEJBException alreadyHandled) {
                logger.debug("config.alreadyHandled");
            }
        }
        for (Deployments deployments : this.openejb.getDeployments()) {
            if (!deployments.isAutoDeploy() || deployments.getDir() == null) continue;
            this.sys.containerSystem.autoDeploy.add(deployments.getDir());
        }
        OpenEjbConfiguration finished = this.sys;
        this.sys = null;
        this.openejb = null;
        return finished;
    }

    @Override
    public OpenEjbConfiguration getOpenEjbConfiguration() throws OpenEJBException {
        return this.getOpenEjbConfiguration((Openejb)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> getDeclaredApps() {
        List<Object> additionalDeploymentsList;
        ArrayList<Deployments> deployments;
        block16: {
            deployments = new ArrayList<Deployments>();
            if (this.openejb != null) {
                deployments.addAll(this.openejb.getDeployments());
            }
            additionalDeploymentsList = Collections.emptyList();
            try {
                File additionalDeploymentFile = SystemInstance.get().getBase().getFile(ADDITIONAL_DEPLOYMENTS, false);
                if (!additionalDeploymentFile.exists()) break block16;
                InputStream fis = null;
                try {
                    fis = IO.read((File)additionalDeploymentFile);
                    AdditionalDeployments additionalDeployments = JaxbOpenejb.unmarshal(AdditionalDeployments.class, fis);
                    additionalDeploymentsList = additionalDeployments.getDeployments();
                }
                catch (Exception e) {
                    logger.error("can't read conf/deployments.xml", e);
                }
                finally {
                    IO.close((Closeable)fis);
                }
            }
            catch (Exception e) {
                logger.info("No additional deployments found: " + e);
            }
        }
        FileUtils base = SystemInstance.get().getBase();
        ArrayList<Deployments> autoDeploy = new ArrayList<Deployments>();
        ArrayList<File> declaredAppsUrls = new ArrayList<File>();
        for (Deployments deployments2 : deployments) {
            try {
                DeploymentsResolver.loadFrom(deployments2, base, declaredAppsUrls);
                if (!deployments2.isAutoDeploy()) continue;
                autoDeploy.add(deployments2);
            }
            catch (SecurityException se) {
                logger.warning("Security check failed on deployment: " + deployments2.getFile(), se);
            }
        }
        for (Deployments deployments3 : additionalDeploymentsList) {
            if (deployments3.getFile() != null) {
                declaredAppsUrls.add(Files.path((File)base.getDirectory().getAbsoluteFile(), (String[])new String[]{deployments3.getFile()}));
            } else if (deployments3.getDir() != null) {
                declaredAppsUrls.add(Files.path((File)base.getDirectory().getAbsoluteFile(), (String[])new String[]{deployments3.getDir()}));
            }
            if (!deployments3.isAutoDeploy()) continue;
            autoDeploy.add(deployments3);
        }
        if (autoDeploy.size() > 0) {
            AutoDeployer autoDeployer = new AutoDeployer(this, autoDeploy);
            SystemInstance.get().setComponent(AutoDeployer.class, (Object)autoDeployer);
            SystemInstance.get().addObserver((Object)autoDeployer);
        }
        return declaredAppsUrls;
    }

    public ArrayList<File> getModulesFromClassPath(List<File> declaredApps, ClassLoader classLoader) {
        FileUtils base = SystemInstance.get().getBase();
        ArrayList<URL> classpathAppsUrls = new ArrayList<URL>();
        DeploymentsResolver.loadFromClasspath(base, classpathAppsUrls, classLoader);
        ArrayList<File> jarFiles = new ArrayList<File>();
        for (URL path : classpathAppsUrls) {
            File file = URLs.toFile(path);
            if (declaredApps != null && declaredApps.contains(file)) continue;
            jarFiles.add(file);
        }
        return jarFiles;
    }

    public ContainerInfo createContainerInfo(Container container) throws OpenEJBException {
        Class<? extends ContainerInfo> infoClass = ConfigurationFactory.getContainerInfoType(container.getType());
        if (infoClass == null) {
            throw new OpenEJBException(messages.format("unrecognizedContainerType", container.getType()));
        }
        return this.configureService(container, infoClass);
    }

    public static void loadPropertiesDeclaredConfiguration(Openejb openejb) {
        Properties sysProps = new Properties(System.getProperties());
        sysProps.putAll((Map<?, ?>)SystemInstance.get().getProperties());
        ConfigurationFactory.fillOpenEjb(openejb, sysProps);
    }

    public static void fillOpenEjb(Openejb openejb, Properties sysProps) {
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            Object o = entry.getValue();
            if (!(o instanceof String) || !((String)o).startsWith("new://")) continue;
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                Object service = ConfigurationFactory.toConfigDeclaration(name, value);
                openejb.add(service);
            }
            catch (URISyntaxException e) {
                logger.error("Error declaring service '" + name + "'. Invalid Service URI '" + value + "'.  java.net.URISyntaxException: " + e.getMessage());
            }
            catch (OpenEJBException e) {
                logger.error(e.getMessage());
            }
        }
    }

    protected static Object toConfigDeclaration(String name, String value) throws URISyntaxException, OpenEJBException {
        value = value.replaceFirst("(provider=[^#=&]+)#", "$1%23");
        URI uri = URLs.uri(value);
        return ConfigurationFactory.toConfigDeclaration(name, uri);
    }

    public static Object toConfigDeclaration(String id, URI uri) throws OpenEJBException {
        try {
            Map<String, String> map;
            Object object;
            String serviceType = uri.getHost();
            try {
                object = JaxbOpenejb.create(serviceType);
            }
            catch (Exception e) {
                throw new OpenEJBException("Invalid URI '" + uri + "'. " + e.getMessage());
            }
            try {
                map = URISupport.parseParamters(uri);
            }
            catch (URISyntaxException e) {
                throw new OpenEJBException("Unable to parse URI parameters '" + uri + "'. URISyntaxException: " + e.getMessage());
            }
            if (object instanceof AbstractService) {
                AbstractService service = (AbstractService)object;
                service.setId(id);
                service.setType(map.remove("type"));
                service.setProvider(map.remove("provider"));
                service.setClassName(map.remove("class-name"));
                service.setConstructor(map.remove("constructor"));
                service.setFactoryName(map.remove("factory-name"));
                service.setPropertiesProvider(map.remove("properties-provider"));
                String cp = map.remove("classpath");
                if (null != cp) {
                    service.setClasspath(cp);
                }
                if (object instanceof Resource) {
                    Resource resource = (Resource)Resource.class.cast(object);
                    String aliases = map.remove("aliases");
                    if (aliases != null) {
                        resource.getAliases().addAll(Arrays.asList(aliases.split(",")));
                    }
                    resource.setPostConstruct(map.remove("post-construct"));
                    resource.setPreDestroy(map.remove("pre-destroy"));
                }
                service.getProperties().putAll(map);
            } else if (object instanceof Deployments) {
                Deployments deployments = (Deployments)object;
                deployments.setDir(map.remove("dir"));
                deployments.setFile(map.remove("jar"));
                String cp = map.remove("classpath");
                if (cp != null) {
                    String[] paths = cp.split(File.pathSeparator);
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (String path : paths) {
                        urls.add(new File(PropertyPlaceHolderHelper.value(ProvisioningUtil.realLocation((String)path))).toURI().normalize().toURL());
                    }
                    deployments.setClasspath(new URLClassLoaderFirst(urls.toArray(new URL[urls.size()]), ParentClassLoaderFinder.Helper.get()));
                }
            }
            return object;
        }
        catch (Exception e) {
            throw new OpenEJBException("Error declaring service '" + id + "'. Unable to create Service definition from URI '" + uri.toString() + "'", e);
        }
    }

    public AppInfo configureApplication(File jarFile) throws OpenEJBException {
        logger.debug("Beginning load: " + jarFile.getAbsolutePath());
        try {
            AppModule appModule = this.deploymentLoader.load(jarFile);
            AppInfo appInfo = this.configureApplication(appModule);
            appInfo.paths.add(appInfo.path);
            appInfo.paths.add(jarFile.getAbsolutePath());
            return appInfo;
        }
        catch (ValidationFailedException e) {
            logger.warning("configureApplication.loadFailed", jarFile.getAbsolutePath(), e.getMessage());
            throw e;
        }
        catch (OpenEJBException e) {
            logger.warning("configureApplication.loadFailed", e, jarFile.getAbsolutePath(), e.getMessage());
            throw e;
        }
    }

    public AppInfo configureApplication(ClassLoader classLoader, String id, List<File> jarFiles) throws OpenEJBException {
        AppInfo appInfo;
        AppModule collection = this.loadApplication(classLoader, id, jarFiles);
        try {
            appInfo = this.configureApplication(collection);
        }
        catch (ValidationFailedException e) {
            logger.warning("configureApplication.loadFailed", collection.getModuleId(), e.getMessage());
            throw e;
        }
        catch (OpenEJBException e) {
            logger.warning("configureApplication.loadFailed", e, collection.getModuleId(), e.getMessage());
            throw e;
        }
        return appInfo;
    }

    public AppModule loadApplication(ClassLoader classLoader, String id, List<File> jarFiles) throws OpenEJBException {
        boolean standaloneModule;
        boolean bl = standaloneModule = id == null;
        if (standaloneModule) {
            id = "";
        }
        Application application = new Application();
        application.setApplicationName(id);
        AppModule collection = new AppModule(classLoader, id, application, standaloneModule);
        Map<String, Object> altDDs = collection.getAltDDs();
        for (File jarFile : jarFiles) {
            logger.info("Beginning load: " + jarFile.getAbsolutePath());
            try {
                AppModule module = this.deploymentLoader.load(jarFile);
                collection.getAdditionalLibraries().addAll(module.getAdditionalLibraries());
                collection.getClientModules().addAll(module.getClientModules());
                collection.getEjbModules().addAll(module.getEjbModules());
                collection.addPersistenceModules(module.getPersistenceModules());
                collection.getConnectorModules().addAll(module.getConnectorModules());
                collection.getWebModules().addAll(module.getWebModules());
                collection.getWatchedResources().addAll(module.getWatchedResources());
                for (Map.Entry<String, Object> entry : module.getAltDDs().entrySet()) {
                    Object values;
                    Object existingValue = altDDs.get(entry.getKey());
                    if (existingValue == null) {
                        altDDs.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (entry.getValue() instanceof Collection) {
                        if (!(existingValue instanceof Collection)) continue;
                        values = (Collection)existingValue;
                        values.addAll((Collection)entry.getValue());
                        continue;
                    }
                    if (!(entry.getValue() instanceof Map) || !(existingValue instanceof Map)) continue;
                    values = (Map)existingValue;
                    values.putAll((Map)entry.getValue());
                }
            }
            catch (ValidationFailedException e) {
                logger.warning("configureApplication.loadFailed", jarFile.getAbsolutePath(), e.getMessage());
                throw e;
            }
            catch (OpenEJBException e) {
                logger.warning("configureApplication.loadFailed", e, jarFile.getAbsolutePath(), e.getMessage());
                throw e;
            }
        }
        return collection;
    }

    public EjbJarInfo configureApplication(EjbJar ejbJar) throws OpenEJBException {
        EjbModule ejbModule = new EjbModule(ejbJar);
        return this.configureApplication(ejbModule);
    }

    public EjbJarInfo configureApplication(EjbModule ejbModule) throws OpenEJBException {
        AppInfo appInfo = this.configureApplication(new AppModule((DeploymentModule[])new EjbModule[]{ejbModule}));
        return appInfo.ejbJars.get(0);
    }

    public ClientInfo configureApplication(ClientModule clientModule) throws OpenEJBException {
        AppInfo appInfo = this.configureApplication(new AppModule((DeploymentModule[])new ClientModule[]{clientModule}));
        return appInfo.clients.get(0);
    }

    public ConnectorInfo configureApplication(ConnectorModule connectorModule) throws OpenEJBException {
        AppInfo appInfo = this.configureApplication(new AppModule((DeploymentModule[])new ConnectorModule[]{connectorModule}));
        return appInfo.connectors.get(0);
    }

    public WebAppInfo configureApplication(WebModule webModule) throws OpenEJBException {
        AppInfo appInfo = this.configureApplication(new AppModule((DeploymentModule[])new WebModule[]{webModule}));
        return appInfo.webApps.get(0);
    }

    public AppInfo configureApplication(AppModule appModule) throws OpenEJBException {
        HashSet extensions = new HashSet();
        HashSet notLoaded = new HashSet();
        List<URL> libs = appModule.getAdditionalLibraries();
        if (libs != null && libs.size() > 0) {
            Extensions.Finder finder = new Extensions.Finder("META-INF", false, libs.toArray(new URL[libs.size()]));
            extensions.addAll(Extensions.findExtensions(finder));
            notLoaded.addAll(finder.getResourcesNotLoaded());
        }
        for (EjbModule ejb : appModule.getEjbModules()) {
            try {
                URI uri = ejb.getModuleUri();
                if (!uri.isAbsolute()) continue;
                URL url = uri.toURL();
                if (libs == null || libs.contains(url)) continue;
                Extensions.Finder finder = new Extensions.Finder("META-INF", false, url);
                extensions.addAll(Extensions.findExtensions(finder));
                notLoaded.addAll(finder.getResourcesNotLoaded());
            }
            catch (IllegalArgumentException iae) {
                logger.debug("can't look for server event listener for module " + ejb.getModuleUri(), iae);
            }
            catch (MalformedURLException mue) {
                logger.debug("can't look for server event listener for module " + ejb.getModuleUri(), mue);
            }
            catch (Exception e) {
                logger.error("can't look for server event listener for module " + ejb.getJarLocation());
            }
        }
        for (WebModule web : appModule.getWebModules()) {
            List<URL> webLibs = web.getScannableUrls();
            if (webLibs == null || webLibs.size() <= 0) continue;
            Extensions.Finder finder = new Extensions.Finder("META-INF", false, webLibs.toArray(new URL[webLibs.size()]));
            extensions.addAll(Extensions.findExtensions(finder));
            notLoaded.addAll(finder.getResourcesNotLoaded());
        }
        Extensions.addExtensions(extensions);
        String location = appModule.getJarLocation();
        logger.info("config.configApp", null != location ? location : appModule.getModuleId());
        this.deployer.deploy(appModule);
        AppInfoBuilder appInfoBuilder = new AppInfoBuilder(this);
        AppInfo info = appInfoBuilder.build(appModule);
        info.eventClassesNeedingAppClassloader.addAll(notLoaded);
        return info;
    }

    public <T extends ServiceInfo> T configureService(Class<? extends T> type) throws OpenEJBException {
        return this.configureService((Service)null, type);
    }

    private <T extends ServiceInfo> Service getDefaultService(Class<? extends T> type) throws OpenEJBException {
        Service service;
        DefaultService defaultService = defaultProviders.get(type);
        if (defaultService == null) {
            return null;
        }
        try {
            service = (Service)JaxbOpenejb.create(defaultService.type);
            service.setType(defaultService.id);
        }
        catch (Exception e) {
            String name = defaultService.type == null ? "null" : defaultService.type.getName();
            throw new OpenEJBException("Cannot instantiate class " + name, e);
        }
        return service;
    }

    public <T extends ServiceInfo> T configureService(Service service, Class<? extends T> infoType) throws OpenEJBException {
        try {
            ServiceInfo info;
            if (infoType == null) {
                throw new NullPointerException("type");
            }
            if (service == null && (service = this.getDefaultService(infoType)) == null) {
                throw new OpenEJBException(messages.format("configureService.noDefaultService", infoType.getName()));
            }
            String providerType = ConfigurationFactory.getProviderType(service);
            ServiceProvider provider = this.resolveServiceProvider(service, infoType);
            if (provider == null) {
                List<ServiceProvider> providers = ServiceUtils.getServiceProvidersByServiceType(providerType);
                StringBuilder sb = new StringBuilder();
                ArrayList<String> types = new ArrayList<String>();
                for (ServiceProvider p : providers) {
                    for (String type : p.getTypes()) {
                        if (types.contains(type)) continue;
                        types.add(type);
                        sb.append(System.getProperty("line.separator"));
                        sb.append("  <").append(p.getService());
                        sb.append(" id=\"").append(service.getId()).append('\"');
                        sb.append(" type=\"").append(type).append("\"/>");
                    }
                }
                String noProviderMessage = messages.format("configureService.noProviderForService", providerType, service.getId(), service.getType(), service.getProvider(), sb.toString());
                throw new NoSuchProviderException(noProviderMessage);
            }
            if (service.getId() == null) {
                service.setId(provider.getId());
            }
            Properties overrides = ConfigurationFactory.trim(ConfigurationFactory.getSystemProperties(this.overrideKey(service), provider.getService()));
            Properties serviceProperties = service.getProperties();
            ConfigurationFactory.trim(serviceProperties);
            ConfigurationFactory.trim(provider.getProperties());
            logger.info("configureService.configuring", service.getId(), provider.getService(), provider.getId());
            if (logger.isDebugEnabled()) {
                Object value;
                Object key;
                for (Map.Entry<Object, Object> entry : serviceProperties.entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (key instanceof String && "password".equalsIgnoreCase((String)key)) {
                        value = "<hidden>";
                    }
                    logger.debug("[" + key + "=" + value + "]");
                }
                for (Map.Entry<Object, Object> entry : overrides.entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (key instanceof String && "password".equalsIgnoreCase((String)key)) {
                        value = "<hidden>";
                    }
                    logger.debug("Override [" + key + "=" + value + "]");
                }
            }
            SuperProperties props = new SuperProperties().caseInsensitive(true);
            if (serviceProperties == null || "false".equals(serviceProperties.getProperty(IGNORE_DEFAULT_VALUES_PROP, "false"))) {
                ((Properties)props).putAll((Map<?, ?>)provider.getProperties());
            }
            ((Properties)props).putAll((Map<?, ?>)serviceProperties);
            ((Properties)props).putAll((Map<?, ?>)overrides);
            String propertiesProvider = service.getPropertiesProvider();
            if (propertiesProvider == null) {
                propertiesProvider = SystemInstance.get().getProperty("org.apache.openejb.api.resource.PropertiesResourceProvider");
            }
            if (propertiesProvider != null) {
                ObjectRecipe recipe = new ObjectRecipe(propertiesProvider);
                recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
                recipe.allow(Option.PRIVATE_PROPERTIES);
                recipe.allow(Option.FIELD_INJECTION);
                recipe.allow(Option.NAMED_PARAMETERS);
                recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                recipe.setFactoryMethod("provides");
                recipe.setProperty("serviceId", (Object)service.getId());
                recipe.setProperties((Object)props);
                recipe.setProperty("properties", (Object)props);
                Properties p = (Properties)Properties.class.cast(recipe.create());
                ((Properties)props).putAll((Map<?, ?>)p);
            }
            ((Properties)props).remove(IGNORE_DEFAULT_VALUES_PROP);
            if (providerType != null && !provider.getService().equals(providerType)) {
                throw new OpenEJBException(messages.format("configureService.wrongProviderType", service.getId(), providerType));
            }
            try {
                info = (ServiceInfo)infoType.newInstance();
            }
            catch (Exception e) {
                throw new OpenEJBException(messages.format("configureService.cannotInstantiateClass", infoType.getName()), e);
            }
            info.service = provider.getService();
            info.types.addAll(provider.getTypes());
            info.description = provider.getDescription();
            info.displayName = provider.getDisplayName();
            info.className = provider.getClassName();
            info.factoryMethod = provider.getFactoryName();
            info.id = service.getId();
            info.properties = props;
            info.constructorArgs.addAll(this.parseConstructorArgs(provider));
            if (info instanceof ResourceInfo && service instanceof Resource) {
                ResourceInfo ri = (ResourceInfo)ResourceInfo.class.cast(info);
                Resource resource = (Resource)Resource.class.cast(service);
                ri.jndiName = resource.getJndi();
                ri.postConstruct = resource.getPostConstruct();
                ri.preDestroy = resource.getPreDestroy();
                ri.aliases.addAll(resource.getAliases());
            }
            if (service.getClasspath() != null && service.getClasspath().length() > 0) {
                info.classpath = ConfigurationFactory.resolveClasspath(service.getClasspath());
            }
            this.specialProcessing(info);
            return (T)info;
        }
        catch (NoSuchProviderException e) {
            String message = logger.fatal("configureService.failed", e, null != service ? service.getId() : "");
            throw new OpenEJBException(message + ": " + e.getMessage());
        }
        catch (Throwable e) {
            String message = logger.fatal("configureService.failed", e, null != service ? service.getId() : "");
            throw new OpenEJBException(message, e);
        }
    }

    public static URI[] resolveClasspath(String rawstring) throws IOException {
        FileUtils base = SystemInstance.get().getBase();
        String[] strings = rawstring.split(File.pathSeparator);
        URI[] classpath = new URI[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            String pathname = PropertyPlaceHolderHelper.simpleValue(ProvisioningUtil.realLocation((String)string));
            File file = base.getFile(pathname, false);
            classpath[i] = file.toURI();
        }
        return classpath;
    }

    private String overrideKey(Service service) {
        String origin = (String)String.class.cast(service.getProperties().remove("OriginalId"));
        if (origin != null) {
            return origin;
        }
        return service.getId();
    }

    private static String getProviderType(Service service) {
        Class<?> clazz = service.getClass();
        if (AbstractService.class.isAssignableFrom(clazz)) {
            while (!clazz.getSuperclass().equals(AbstractService.class)) {
                clazz = clazz.getSuperclass();
            }
        }
        return clazz.getSimpleName();
    }

    private static Properties trim(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object o = entry.getValue();
            if (!(o instanceof String)) continue;
            String value = (String)o;
            String trimmed = value.trim();
            if (value.length() == trimmed.length()) continue;
            properties.put(entry.getKey(), trimmed);
        }
        return properties;
    }

    private <T extends ServiceInfo> void specialProcessing(T info) {
        TopicOrQueueDefaults.process(info);
    }

    private ServiceProvider resolveServiceProvider(Service service, Class infoType) throws OpenEJBException {
        Service defaultService;
        Properties properties;
        if (service.getClassName() != null) {
            if (service.getType() == null) {
                service.setType(service.getClassName());
            }
            ServiceProvider provider = new ServiceProvider();
            provider.setId(service.getId());
            provider.setService(ConfigurationFactory.getProviderType(service));
            provider.getTypes().add(service.getType());
            provider.setClassName(service.getClassName());
            provider.setConstructor(service.getConstructor());
            provider.setFactoryName(service.getFactoryName());
            return provider;
        }
        if (service.getProvider() != null) {
            return ServiceUtils.getServiceProvider(service.getProvider());
        }
        if (service.getType() == null && this.serviceTypeIsAdjustable && ((properties = service.getProperties()).containsKey("JdbcDriver") || properties.containsKey("JdbcUrl") || properties.containsKey("url")) && (properties.containsKey("JtaManaged") || properties.containsKey("UserName") || properties.containsKey("Password"))) {
            service.setType("javax.sql.DataSource");
        }
        if (service.getType() != null) {
            return ServiceUtils.getServiceProviderByType(ConfigurationFactory.getProviderType(service), service.getType());
        }
        if (service.getId() != null) {
            try {
                return ServiceUtils.getServiceProvider(service.getId());
            }
            catch (NoSuchProviderException e) {
                logger.debug("resolveServiceProvider", e);
            }
        }
        if (infoType != null && (defaultService = this.getDefaultService(infoType)) != null) {
            return this.resolveServiceProvider(defaultService, null);
        }
        return null;
    }

    public <T extends ServiceInfo> T configureService(String id, Class<? extends T> type) throws OpenEJBException {
        return this.configureService(type, id, null, id, null);
    }

    public <T extends ServiceInfo> T configureService(Class<? extends T> type, String serviceId, Properties declaredProperties, String providerId, String serviceType) throws OpenEJBException {
        Service service;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        Class<? extends Service> serviceClass = types.get(type);
        if (serviceClass == null) {
            throw new OpenEJBException("Unsupported service info type: " + type.getName());
        }
        try {
            service = serviceClass.newInstance();
        }
        catch (Exception e) {
            throw new OpenEJBException(messages.format("configureService.cannotInstantiateClass", serviceClass.getName()), e);
        }
        service.setId(serviceId);
        service.setProvider(providerId);
        if (declaredProperties != null) {
            service.getProperties().putAll((Map<?, ?>)declaredProperties);
        }
        return this.configureService(service, type);
    }

    protected static Properties getSystemProperties(String serviceId, String serviceType) {
        Properties sysProps = new Properties(System.getProperties());
        sysProps.putAll((Map<?, ?>)SystemInstance.get().getProperties());
        return ConfigurationFactory.getOverrides(sysProps, serviceId, serviceType);
    }

    protected static Properties getOverrides(Properties properties, String serviceId, String serviceType) {
        String fullPrefix = serviceType.toUpperCase() + "." + serviceId + ".";
        String fullPrefix2 = serviceType.toUpperCase() + "." + serviceId + "|";
        String shortPrefix = serviceId + ".";
        String shortPrefix2 = serviceId + "|";
        Properties overrides = new Properties();
        block0: for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            for (String prefix : Arrays.asList(fullPrefix, fullPrefix2, shortPrefix, shortPrefix2)) {
                if (!name.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                name = name.substring(prefix.length());
                String value = entry.getValue().toString();
                overrides.setProperty(name, value);
                continue block0;
            }
        }
        return overrides;
    }

    protected static Class<? extends ContainerInfo> getContainerInfoType(String ctype) {
        return containerTypes.get(ctype);
    }

    private List<String> parseConstructorArgs(ServiceProvider service) {
        String constructor = service.getConstructor();
        if (constructor == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(constructor.split("[ ,]+"));
    }

    protected List<String> getResourceIds() {
        return this.getResourceIds(null);
    }

    protected List<String> getResourceIds(String type) {
        return this.getResourceIds(type, null);
    }

    public List<String> getResourceIds(String type, Properties required) {
        OpenEjbConfiguration runningConfig;
        ArrayList<String> resourceIds = new ArrayList<String>();
        if (required == null) {
            required = new Properties();
        }
        if ((runningConfig = this.getRunningConfig()) != null) {
            for (ResourceInfo resourceInfo : runningConfig.facilities.resources) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Trying to match resource type %s with classname %s, service %s.", type, resourceInfo.className, resourceInfo.service));
                }
                if ((type == null || !type.equals(resourceInfo.className)) && !ConfigurationFactory.isResourceType(resourceInfo.service, resourceInfo.types, type) || !ServiceUtils.implies(required, resourceInfo.properties)) continue;
                resourceIds.add(resourceInfo.id);
                resourceIds.addAll(resourceInfo.aliases);
            }
        }
        if (this.sys != null) {
            for (ResourceInfo resourceInfo : this.sys.facilities.resources) {
                if (!ConfigurationFactory.isResourceType(resourceInfo.service, resourceInfo.types, type) || !ServiceUtils.implies(required, resourceInfo.properties)) continue;
                resourceIds.add(resourceInfo.id);
                resourceIds.addAll(resourceInfo.aliases);
            }
            if (this.openejb != null) {
                for (Resource resource : this.openejb.getResource()) {
                    ArrayList<String> types = new ArrayList<String>();
                    if (resource.getType() != null) {
                        types.add(resource.getType());
                    }
                    if (!ConfigurationFactory.isResourceType("Resource", types, type) || !ServiceUtils.implies(required, resource.getProperties())) continue;
                    resourceIds.add(resource.getId());
                    resourceIds.addAll(resource.getAliases());
                }
            }
        }
        return resourceIds;
    }

    protected ResourceInfo getResourceInfo(String id) {
        OpenEjbConfiguration runningConfig = this.getRunningConfig();
        if (runningConfig != null) {
            for (ResourceInfo resourceInfo : runningConfig.facilities.resources) {
                if (id.equals(resourceInfo.id)) {
                    return resourceInfo;
                }
                for (String alias : resourceInfo.aliases) {
                    if (!alias.equals(id)) continue;
                    return resourceInfo;
                }
            }
        }
        if (this.sys != null) {
            for (ResourceInfo resourceInfo : this.sys.facilities.resources) {
                if (id.equals(resourceInfo.id)) {
                    return resourceInfo;
                }
                for (String alias : resourceInfo.aliases) {
                    if (!alias.equals(id)) continue;
                    return resourceInfo;
                }
            }
        }
        return null;
    }

    public static boolean isResourceType(String service, List<String> types, String type) {
        return type == null || service != null && types.contains(type);
    }

    protected List<String> getContainerIds() {
        ArrayList<String> containerIds = new ArrayList<String>();
        OpenEjbConfiguration runningConfig = this.getRunningConfig();
        if (runningConfig != null) {
            for (ContainerInfo containerInfo : runningConfig.containerSystem.containers) {
                containerIds.add(containerInfo.id);
            }
        }
        if (this.sys != null) {
            for (ContainerInfo containerInfo : this.sys.containerSystem.containers) {
                containerIds.add(containerInfo.id);
            }
            if (this.openejb != null) {
                for (Container container : this.openejb.getContainer()) {
                    containerIds.add(container.getId());
                }
            }
        }
        return containerIds;
    }

    protected List<ContainerInfo> getContainerInfos() {
        ArrayList<ContainerInfo> containers = new ArrayList<ContainerInfo>();
        OpenEjbConfiguration runningConfig = this.getRunningConfig();
        if (runningConfig != null) {
            for (ContainerInfo containerInfo : runningConfig.containerSystem.containers) {
                containers.add(containerInfo);
            }
        }
        if (this.sys != null) {
            for (ContainerInfo containerInfo : this.sys.containerSystem.containers) {
                containers.add(containerInfo);
            }
        }
        return containers;
    }

    private OpenEjbConfiguration getRunningConfig() {
        return (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
    }

    static {
        defaultProviders.put(MdbContainerInfo.class, new DefaultService("MESSAGE", Container.class));
        defaultProviders.put(ManagedContainerInfo.class, new DefaultService("MANAGED", Container.class));
        defaultProviders.put(StatefulSessionContainerInfo.class, new DefaultService("STATEFUL", Container.class));
        defaultProviders.put(StatelessSessionContainerInfo.class, new DefaultService("STATELESS", Container.class));
        defaultProviders.put(SingletonSessionContainerInfo.class, new DefaultService("SINGLETON", Container.class));
        defaultProviders.put(CmpEntityContainerInfo.class, new DefaultService("CMP_ENTITY", Container.class));
        defaultProviders.put(BmpEntityContainerInfo.class, new DefaultService("BMP_ENTITY", Container.class));
        defaultProviders.put(SecurityServiceInfo.class, new DefaultService("SecurityService", SecurityService.class));
        defaultProviders.put(TransactionServiceInfo.class, new DefaultService("TransactionManager", TransactionManager.class));
        defaultProviders.put(ConnectionManagerInfo.class, new DefaultService("ConnectionManager", ConnectionManager.class));
        defaultProviders.put(ProxyFactoryInfo.class, new DefaultService("ProxyFactory", ProxyFactory.class));
        for (Map.Entry<Class<? extends ServiceInfo>, DefaultService> entry : defaultProviders.entrySet()) {
            types.put(entry.getKey(), entry.getValue().type);
        }
        types.put(ResourceInfo.class, Resource.class);
        containerTypes = new HashMap<String, Class<? extends ContainerInfo>>();
        containerTypes.put("SINGLETON", SingletonSessionContainerInfo.class);
        containerTypes.put("MANAGED", ManagedContainerInfo.class);
        containerTypes.put("STATELESS", StatelessSessionContainerInfo.class);
        containerTypes.put("STATEFUL", StatefulSessionContainerInfo.class);
        containerTypes.put("BMP_ENTITY", BmpEntityContainerInfo.class);
        containerTypes.put("CMP_ENTITY", CmpEntityContainerInfo.class);
        containerTypes.put("MESSAGE", MdbContainerInfo.class);
    }

    public static class ResourceInfoComparator
    implements Comparator<ResourceInfo> {
        private final List<String> ids = new ArrayList<String>();
        private static final int EQUAL = 0;
        private static final int GREATER = 1;
        private static final int LESS = -1;

        public ResourceInfoComparator(List<ResourceInfo> resources) {
            for (ResourceInfo info : resources) {
                this.ids.add(info.id);
            }
        }

        @Override
        public int compare(ResourceInfo a, ResourceInfo b) {
            String refA = this.getReference(a);
            String refB = this.getReference(b);
            if (refA == null && refB == null || refA != null && refA.equals(refB)) {
                return 0;
            }
            if (a.id.equals(refB)) {
                return -1;
            }
            if (b.id.equals(refA)) {
                return 1;
            }
            if (refA != null && refB == null) {
                return 1;
            }
            if (refA == null) {
                return -1;
            }
            return 0;
        }

        public int hasReference(ResourceInfo info) {
            for (Object value : info.properties.values()) {
                if (!String.class.isInstance(value) || !this.ids.contains(value)) continue;
                return 1;
            }
            return 0;
        }

        public String getReference(ResourceInfo info) {
            for (Object value : info.properties.values()) {
                String string;
                if (!String.class.isInstance(value) || (string = ((String)String.class.cast(value)).trim()).isEmpty()) continue;
                if (this.ids.contains(string)) {
                    return (String)value;
                }
                if (string.contains(",")) {
                    for (String s : string.split(",")) {
                        String trimmed = s.trim();
                        if (!this.ids.contains(trimmed)) continue;
                        return s;
                    }
                }
                for (String s : this.ids) {
                    if (!s.endsWith("/" + string)) continue;
                    return s;
                }
            }
            return null;
        }
    }

    private static class TopicOrQueueDefaults {
        private TopicOrQueueDefaults() {
        }

        public static void process(ServiceInfo provider) {
            if (!provider.service.equals("Resource")) {
                return;
            }
            if (!provider.types.contains("Topic") && !provider.types.contains("Queue")) {
                return;
            }
            if (!provider.className.matches("org.apache.activemq.command.ActiveMQ(Topic|Queue)")) {
                return;
            }
            String dest = provider.properties.getProperty("destination");
            if (dest == null || dest.length() == 0) {
                provider.properties.setProperty("destination", provider.id);
            }
        }
    }

    private static class DefaultService {
        private final Class<? extends Service> type;
        private final String id;

        public DefaultService(String id, Class<? extends Service> type) {
            this.id = id;
            this.type = type;
        }
    }

    public static class Chain
    implements DynamicDeployer {
        private final List<DynamicDeployer> chain = new ArrayList<DynamicDeployer>();

        public boolean add(DynamicDeployer o) {
            return this.chain.add(o);
        }

        @Override
        public AppModule deploy(AppModule appModule) throws OpenEJBException {
            for (DynamicDeployer deployer : this.chain) {
                appModule = deployer.deploy(appModule);
            }
            return appModule;
        }
    }

    public static class ProxyBeanClassUpdate
    implements DynamicDeployer {
        @Override
        public AppModule deploy(AppModule appModule) throws OpenEJBException {
            for (EjbModule module : appModule.getEjbModules()) {
                for (EnterpriseBean eb : module.getEjbJar().getEnterpriseBeans()) {
                    Class<?> ejbClass;
                    if (!(eb instanceof SessionBean)) continue;
                    SessionBean bean = (SessionBean)eb;
                    try {
                        ejbClass = module.getClassLoader().loadClass(bean.getEjbClass());
                    }
                    catch (ClassNotFoundException e) {
                        logger.warning("can't load " + bean.getEjbClass());
                        continue;
                    }
                    if (!ejbClass.isInterface()) continue;
                    bean.setLocal(ejbClass.getName());
                    Proxy proxyAnnotation = (Proxy)new MetaAnnotatedClass(ejbClass).getAnnotation(Proxy.class);
                    Class proxyClass = proxyAnnotation != null ? proxyAnnotation.value() : QueryProxy.class;
                    bean.setProxy(proxyClass.getName());
                    for (EnvEntry entry : bean.getEnvEntry()) {
                        if (!"java:comp/env/implementingInterfaceClass".equals(entry.getName())) continue;
                        entry.setEnvEntryValue(ejbClass.getName());
                    }
                }
            }
            return appModule;
        }
    }
}

