/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerFactoryHandler;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.ra.ActiveMQResourceAdapter;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterFactory;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.util.URISupport;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.propertyeditor.PropertyEditorException;
import org.apache.xbean.propertyeditor.PropertyEditors;

public class ActiveMQ5Factory
implements BrokerFactoryHandler {
    private static Properties properties;
    private static final Map<URI, BrokerService> brokers;
    private static Throwable throwable;
    private static final AtomicBoolean started;

    public static void setThreadProperties(Properties p) {
        properties = p;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized BrokerService createBroker(URI brokerURI) throws Exception {
        PersistenceAdapter persistenceAdapter;
        Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("ActiveMQ5Factory creating broker");
        BrokerService broker = brokers.get(brokerURI);
        if (null != broker && broker.isStarted()) return broker;
        Properties properties = this.getLowerCaseProperties();
        URISupport.CompositeData compositeData = URISupport.parseComposite((URI)new URI(brokerURI.getRawSchemeSpecificPart()));
        HashMap<String, String> params = new HashMap<String, String>(compositeData.getParameters());
        if ("true".equals(params.remove("usekahadb"))) {
            persistenceAdapter = ActiveMQ5Factory.createPersistenceAdapter("org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter", "kahadb", params);
        } else if ("true".equals(params.remove("useleveldb"))) {
            persistenceAdapter = ActiveMQ5Factory.createPersistenceAdapter("org.apache.activemq.store.leveldb.LevelDBPersistenceAdapter", "leveldb", params);
        } else if (params.get("persistenceadapter") != null) {
            String adapter = (String)params.remove("persistenceadapter");
            persistenceAdapter = ActiveMQ5Factory.createPersistenceAdapter(adapter, "persistence", params);
        } else {
            persistenceAdapter = null;
        }
        URI uri = new URI(ActiveMQ5Factory.cleanUpUri(brokerURI.getSchemeSpecificPart(), compositeData.getParameters(), params));
        broker = BrokerFactory.createBroker((URI)uri);
        brokers.put(brokerURI, broker);
        if (persistenceAdapter != null) {
            broker.setPersistenceAdapter(persistenceAdapter);
            broker.setPersistenceFactory((PersistenceAdapterFactory)new ProvidedPersistenceAdapterPersistenceAdapterFactory(persistenceAdapter));
            broker.setPersistent(true);
            this.tomeeConfig(broker);
        } else {
            boolean notXbean;
            boolean bl = notXbean = !uri.getScheme().toLowerCase().startsWith("xbean");
            if (notXbean) {
                DataSource dataSource;
                Object value = properties.get("datasource");
                if (String.class.isInstance(value) && value.toString().length() == 0) {
                    value = null;
                }
                if (value != null) {
                    if (DataSource.class.isInstance(value)) {
                        dataSource = (DataSource)DataSource.class.cast(value);
                    } else {
                        if (!String.class.isInstance(value)) throw new IllegalArgumentException("Unexpected datasource definition: " + value);
                        String resouceId = (String)String.class.cast(value);
                        try {
                            ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
                            Context context = containerSystem.getJNDIContext();
                            Object obj = context.lookup("openejb/Resource/" + resouceId);
                            if (!(obj instanceof DataSource)) {
                                throw new IllegalArgumentException("Resource with id " + resouceId + " is not a DataSource, but is " + obj.getClass().getName());
                            }
                            dataSource = (DataSource)obj;
                        }
                        catch (NamingException e) {
                            throw new IllegalArgumentException("Unknown datasource " + resouceId);
                        }
                    }
                } else {
                    dataSource = null;
                }
                if (null != dataSource) {
                    JDBCPersistenceAdapter adapter = new JDBCPersistenceAdapter();
                    if (properties.containsKey("usedatabaselock")) {
                        adapter.setUseLock(Boolean.parseBoolean(properties.getProperty("usedatabaselock", "true")));
                    }
                    adapter.setDataSource(dataSource);
                    broker.setPersistent(true);
                    broker.setPersistenceAdapter((PersistenceAdapter)adapter);
                } else {
                    broker.setPersistenceAdapter((PersistenceAdapter)new MemoryPersistenceAdapter());
                }
                this.tomeeConfig(broker);
            }
        }
        broker.setUseShutdownHook(false);
        broker.setSystemExitOnShutdown(false);
        broker.setStartAsync(false);
        final BrokerService bs = broker;
        Thread start = new Thread("ActiveMQFactory start and checkpoint"){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(ActiveMQResourceAdapter.class.getClassLoader());
                try {
                    if (!bs.isStarted()) {
                        Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("Starting ActiveMQ BrokerService");
                        bs.start();
                    }
                    bs.waitUntilStarted();
                    Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("Starting ActiveMQ checkpoint");
                    bs.getPersistenceAdapter().checkpoint(true);
                    started.set(true);
                }
                catch (Throwable t) {
                    throwable = t;
                }
            }
        };
        int timeout = 30000;
        try {
            timeout = Integer.parseInt(properties.getProperty("startuptimeout", "30000"));
            Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("Using ActiveMQ startup timeout of " + timeout + "ms");
        }
        catch (Throwable e) {
            // empty catch block
        }
        start.setDaemon(true);
        start.start();
        try {
            start.join(timeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (null != throwable) {
            Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").error("ActiveMQ failed to start broker", throwable);
            return broker;
        } else if (started.get()) {
            Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("ActiveMQ broker started");
            return broker;
        } else {
            Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").warning("ActiveMQ failed to start broker within " + timeout + " seconds - It may be unusable");
        }
        return broker;
    }

    private static String cleanUpUri(String schemeSpecificPart, Map<String, String> parameters, Map<String, String> params) {
        String uri = schemeSpecificPart;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String kv;
            int idx;
            if (params.containsKey(entry.getKey()) || (idx = uri.indexOf(kv = entry.getKey() + "=" + entry.getValue())) < 0) continue;
            int andIdx = idx + kv.length();
            if (andIdx < uri.length() && uri.charAt(andIdx) == '&') {
                uri = uri.replace(kv + "&", "");
                continue;
            }
            uri = uri.replace(kv, "");
        }
        return uri;
    }

    private static PersistenceAdapter createPersistenceAdapter(String clazz, String prefix, Map<String, String> params) throws IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        PersistenceAdapter persistenceAdapter = (PersistenceAdapter)PersistenceAdapter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(clazz).newInstance());
        for (Method m : KahaDBPersistenceAdapter.class.getDeclaredMethods()) {
            String key;
            String field;
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1 || !Modifier.isPublic(m.getModifiers()) || (field = params.remove(key = prefix + "." + m.getName().substring(3).toLowerCase(Locale.ENGLISH))) == null) continue;
            try {
                Object toSet = PropertyEditors.getValue(m.getParameterTypes()[0], (String)field.toString());
                m.invoke((Object)persistenceAdapter, toSet);
            }
            catch (PropertyEditorException cantConvertException) {
                throw new IllegalArgumentException("can't convert " + field + " for " + m.getName(), cantConvertException);
            }
        }
        return persistenceAdapter;
    }

    private void tomeeConfig(BrokerService broker) {
        broker.setUseLoggingForShutdownErrors(Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).isErrorEnabled());
    }

    private Properties getLowerCaseProperties() {
        Properties newProperties = new Properties();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    key = ((String)key).toLowerCase();
                }
                newProperties.put(key, entry.getValue());
            }
        }
        return newProperties;
    }

    public Collection<BrokerService> getBrokers() {
        return brokers.values();
    }

    static {
        brokers = new HashMap<URI, BrokerService>();
        started = new AtomicBoolean(false);
    }

    private static class ProvidedPersistenceAdapterPersistenceAdapterFactory
    implements PersistenceAdapterFactory {
        private final PersistenceAdapter instance;

        public ProvidedPersistenceAdapterPersistenceAdapterFactory(PersistenceAdapter persistenceAdapter) {
            this.instance = persistenceAdapter;
        }

        public PersistenceAdapter createPersistenceAdapter() throws IOException {
            return this.instance;
        }
    }
}

