/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import javax.annotation.ManagedBean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ClientInjections;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEjbContainer;
import org.apache.openejb.api.LocalClient;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.inject.OWBInjector;

public class Injector {
    private static Logger logger;

    public static <T> T inject(T object) {
        assert (object != null);
        Class<?> clazz = object.getClass();
        BeanContext context = Injector.resolve(clazz);
        if (context != null) {
            InjectionProcessor<T> processor = new InjectionProcessor<T>(object, context.getInjections(), context.getJndiContext());
            Injector.cdiInjections(context, object);
            try {
                return processor.createInstance();
            }
            catch (OpenEJBException e) {
                throw new InjectionException(clazz.getName(), e);
            }
        }
        if (!Injector.isAnnotatedLocalClient(clazz)) {
            throw new NoInjectionMetaDataException(clazz.getName());
        }
        try {
            InjectionProcessor<?> processor = ClientInjections.clientInjector(object);
            Injector.cdiInjections(null, object);
            return (T)processor.createInstance();
        }
        catch (OpenEJBException e) {
            throw new NoInjectionMetaDataException("Injection failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void cdiInjections(BeanContext context, T object) {
        if (context != null) {
            ThreadContext callContext = new ThreadContext(context, null, Operation.INJECTION);
            ThreadContext oldContext = ThreadContext.enter(callContext);
            try {
                OWBInjector.inject((BeanManager)context.getWebBeansContext().getBeanManagerImpl(), object, null);
            }
            catch (Throwable t) {
                Injector.logger().warning("An error occurred injecting the class '" + object.getClass().getName() + "': " + t.getMessage());
            }
            finally {
                ThreadContext.exit(oldContext);
            }
        } else {
            Injector.logger().warning("Provided BeanContext is null");
        }
    }

    private static boolean isAnnotatedLocalClient(Class<?> clazz) {
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            if (current.getAnnotation(LocalClient.class) == null) continue;
            return true;
        }
        return false;
    }

    private static BeanContext resolve(Class<?> clazz) {
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        while (clazz != null && clazz != Object.class) {
            BeanContext context = containerSystem.getBeanContext(clazz.getName());
            if (context != null) {
                return context;
            }
            for (BeanContext context2 : containerSystem.deployments()) {
                if (clazz != context2.getBeanClass()) continue;
                return context2;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static Logger logger() {
        if (logger == null) {
            logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, OpenEjbContainer.class);
        }
        return logger;
    }

    public static class InjectionException
    extends IllegalStateException {
        public InjectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class NoInjectionMetaDataException
    extends IllegalStateException {
        public NoInjectionMetaDataException(String s) {
            this(s, null);
        }

        public NoInjectionMetaDataException(String s, Exception e) {
            super(String.format("%s : Annotate the class with @%s so it can be discovered in the application scanning process", s, ManagedBean.class.getName()), e);
        }
    }
}

