/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.Transaction;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ContainerType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.InvalidateReferenceException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.SystemException;
import org.apache.openejb.cdi.CurrentCreationalContext;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.InstanceContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.stateful.Cache;
import org.apache.openejb.core.stateful.DefaultLockFactory;
import org.apache.openejb.core.stateful.Instance;
import org.apache.openejb.core.stateful.LockFactory;
import org.apache.openejb.core.stateful.StatefulContext;
import org.apache.openejb.core.stateful.StatefulUserTransaction;
import org.apache.openejb.core.transaction.BeanTransactionPolicy;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.EjbUserTransaction;
import org.apache.openejb.core.transaction.JtaTransactionPolicy;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ManagedMBean;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.monitoring.StatsInterceptor;
import org.apache.openejb.persistence.EntityManagerAlreadyRegisteredException;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.Index;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class StatefulContainer
implements RpcContainer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final Object containerID;
    private final SecurityService securityService;
    private final Duration accessTimeout;
    protected final JtaEntityManagerRegistry entityManagerRegistry = (JtaEntityManagerRegistry)SystemInstance.get().getComponent(JtaEntityManagerRegistry.class);
    protected final Map<Object, BeanContext> deploymentsById = new HashMap<Object, BeanContext>();
    protected final Cache<Object, Instance> cache;
    protected final LockFactory lockFactory;
    private final ConcurrentMap<Object, Instance> checkedOutInstances = new ConcurrentHashMap<Object, Instance>();
    private final SessionContext sessionContext;
    private final boolean preventExtendedEntityManagerSerialization;

    public StatefulContainer(Object id, SecurityService securityService, Cache<Object, Instance> cache) {
        this(id, securityService, cache, new Duration(-1L, TimeUnit.MILLISECONDS), true, new DefaultLockFactory());
    }

    public StatefulContainer(Object id, SecurityService securityService, Cache<Object, Instance> cache, Duration accessTimeout, boolean preventExtendedEntityManagerSerialization, LockFactory lockFactory) {
        this.containerID = id;
        this.securityService = securityService;
        this.cache = cache;
        cache.setListener(new StatefulCacheListener());
        this.accessTimeout = accessTimeout;
        this.sessionContext = new StatefulContext(this.securityService, new StatefulUserTransaction(new EjbUserTransaction(), this.entityManagerRegistry));
        this.preventExtendedEntityManagerSerialization = preventExtendedEntityManagerSerialization;
        this.lockFactory = lockFactory;
        this.lockFactory.setContainer(this);
    }

    private Map<Method, MethodType> getLifecycleMethodsOfInterface(BeanContext beanContext) {
        Class localHomeInterface;
        Class homeInterface;
        Class businessRemoteHomeInterface;
        Class businessLocalBeanHomeInterface;
        Class businessLocalHomeInterface;
        Class legacyLocal;
        HashMap<Method, MethodType> methods = new HashMap<Method, MethodType>();
        try {
            methods.put(BeanContext.Removable.class.getDeclaredMethod("$$remove", new Class[0]), MethodType.REMOVE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Internal code change: BeanContext.Removable.$$remove() method was deleted", e);
        }
        List<Method> removeMethods = beanContext.getRemoveMethods();
        for (Method removeMethod : removeMethods) {
            Method method;
            methods.put(removeMethod, MethodType.REMOVE);
            for (Class businessLocal : beanContext.getBusinessLocalInterfaces()) {
                try {
                    method = businessLocal.getMethod(removeMethod.getName(), removeMethod.getParameterTypes());
                    methods.put(method, MethodType.REMOVE);
                }
                catch (NoSuchMethodException ignore) {}
            }
            for (Class businessRemote : beanContext.getBusinessRemoteInterfaces()) {
                try {
                    method = businessRemote.getMethod(removeMethod.getName(), removeMethod.getParameterTypes());
                    methods.put(method, MethodType.REMOVE);
                }
                catch (NoSuchMethodException ignore) {}
            }
        }
        Class legacyRemote = beanContext.getRemoteInterface();
        if (legacyRemote != null) {
            try {
                Method method = legacyRemote.getMethod("remove", new Class[0]);
                methods.put(method, MethodType.REMOVE);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
        }
        if ((legacyLocal = beanContext.getLocalInterface()) != null) {
            try {
                Method method = legacyLocal.getMethod("remove", new Class[0]);
                methods.put(method, MethodType.REMOVE);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
        }
        if ((businessLocalHomeInterface = beanContext.getBusinessLocalInterface()) != null) {
            for (Method method : BeanContext.BusinessLocalHome.class.getMethods()) {
                if (method.getName().startsWith("create")) {
                    methods.put(method, MethodType.CREATE);
                    continue;
                }
                if (!method.getName().equals("remove")) continue;
                methods.put(method, MethodType.REMOVE);
            }
        }
        if ((businessLocalBeanHomeInterface = beanContext.getBusinessLocalBeanInterface()) != null) {
            for (Method method : BeanContext.BusinessLocalBeanHome.class.getMethods()) {
                if (method.getName().startsWith("create")) {
                    methods.put(method, MethodType.CREATE);
                    continue;
                }
                if (!method.getName().equals("remove")) continue;
                methods.put(method, MethodType.REMOVE);
            }
        }
        if ((businessRemoteHomeInterface = beanContext.getBusinessRemoteInterface()) != null) {
            for (Method method : BeanContext.BusinessRemoteHome.class.getMethods()) {
                if (method.getName().startsWith("create")) {
                    methods.put(method, MethodType.CREATE);
                    continue;
                }
                if (!method.getName().equals("remove")) continue;
                methods.put(method, MethodType.REMOVE);
            }
        }
        if ((homeInterface = beanContext.getHomeInterface()) != null) {
            for (Method method : homeInterface.getMethods()) {
                if (method.getName().startsWith("create")) {
                    methods.put(method, MethodType.CREATE);
                    continue;
                }
                if (!method.getName().equals("remove")) continue;
                methods.put(method, MethodType.REMOVE);
            }
        }
        if ((localHomeInterface = beanContext.getLocalHomeInterface()) != null) {
            for (Method method : localHomeInterface.getMethods()) {
                if (method.getName().startsWith("create")) {
                    methods.put(method, MethodType.CREATE);
                    continue;
                }
                if (!method.getName().equals("remove")) continue;
                methods.put(method, MethodType.REMOVE);
            }
        }
        return methods;
    }

    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    public Cache<Object, Instance> getCache() {
        return this.cache;
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.STATEFUL;
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    @Override
    public synchronized BeanContext[] getBeanContexts() {
        return this.deploymentsById.values().toArray(new BeanContext[this.deploymentsById.size()]);
    }

    @Override
    public synchronized BeanContext getBeanContext(Object deploymentID) {
        return this.deploymentsById.get(deploymentID);
    }

    @Override
    public void start(BeanContext beanContext) throws OpenEJBException {
    }

    @Override
    public void stop(BeanContext beanContext) throws OpenEJBException {
        beanContext.stop();
    }

    @Override
    public synchronized void undeploy(BeanContext beanContext) throws OpenEJBException {
        Data data = (Data)beanContext.getContainerData();
        MBeanServer server = LocalMBeanServer.get();
        for (ObjectName objectName : data.jmxNames) {
            try {
                server.unregisterMBean(objectName);
            }
            catch (Exception e) {
                logger.error("Unable to unregister MBean " + objectName);
            }
        }
        this.deploymentsById.remove(beanContext.getDeploymentID());
        beanContext.setContainer(null);
        beanContext.setContainerData(null);
        if (!this.containsExtendedPersistenceContext(beanContext)) {
            this.cache.removeAll(new BeanContextFilter(beanContext.getId()));
        }
    }

    @Override
    public synchronized void deploy(BeanContext beanContext) throws OpenEJBException {
        Map<Method, MethodType> methods = this.getLifecycleMethodsOfInterface(beanContext);
        this.deploymentsById.put(beanContext.getDeploymentID(), beanContext);
        beanContext.setContainer(this);
        Data data = new Data(new Index<Method, MethodType>(methods));
        beanContext.setContainerData(data);
        if (StatsInterceptor.isStatsActivated()) {
            StatsInterceptor stats = new StatsInterceptor(beanContext.getBeanClass());
            beanContext.addFirstSystemInterceptor(stats);
            MBeanServer server = LocalMBeanServer.get();
            ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
            jmxName.set("J2EEServer", "openejb");
            jmxName.set("J2EEApplication", null);
            jmxName.set("EJBModule", beanContext.getModuleID());
            jmxName.set("StatefulSessionBean", beanContext.getEjbName());
            jmxName.set("j2eeType", "");
            jmxName.set("name", beanContext.getEjbName());
            try {
                ObjectName objectName = jmxName.set("j2eeType", "Invocations").build();
                if (server.isRegistered(objectName)) {
                    server.unregisterMBean(objectName);
                }
                server.registerMBean(new ManagedMBean(stats), objectName);
                data.jmxNames.add(objectName);
            }
            catch (Exception e) {
                logger.error("Unable to register MBean ", e);
            }
        }
        try {
            Context context = beanContext.getJndiEnc();
            context.bind("comp/EJBContext", (Object)this.sessionContext);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Failed to bind EJBContext", e);
        }
        beanContext.set(EJBContext.class, this.sessionContext);
    }

    @Override
    public Object invoke(Object deployID, InterfaceType type, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        Data data;
        MethodType methodType;
        BeanContext beanContext = this.getBeanContext(deployID);
        if (beanContext == null) {
            throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
        }
        if (type == null) {
            type = beanContext.getInterfaceType(callInterface);
        }
        methodType = (methodType = (data = (Data)beanContext.getContainerData()).getMethodIndex().get(callMethod)) != null ? methodType : MethodType.BUSINESS;
        switch (methodType) {
            case CREATE: {
                return this.createEJBObject(beanContext, callMethod, args, type);
            }
            case REMOVE: {
                return this.removeEJBObject(beanContext, primKey, callInterface, callMethod, args, type);
            }
        }
        return this.businessMethod(beanContext, primKey, callInterface, callMethod, args, type);
    }

    private boolean containsExtendedPersistenceContext(BeanContext beanContext) {
        if (this.preventExtendedEntityManagerSerialization) {
            return false;
        }
        Index<EntityManagerFactory, Map> factories = beanContext.getExtendedEntityManagerFactories();
        return factories != null && factories.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProxyInfo createEJBObject(BeanContext beanContext, Method callMethod, Object[] args, InterfaceType interfaceType) throws OpenEJBException {
        Object primaryKey = this.newPrimaryKey();
        ThreadContext createContext = new ThreadContext(beanContext, primaryKey);
        ThreadContext oldCallContext = ThreadContext.enter(createContext);
        try {
            this.checkAuthorization(callMethod, interfaceType);
            Index<EntityManagerFactory, JtaEntityManagerRegistry.EntityManagerTracker> entityManagers = this.createEntityManagers(beanContext);
            if (entityManagers != null) {
                try {
                    this.entityManagerRegistry.addEntityManagers((String)beanContext.getDeploymentID(), primaryKey, entityManagers);
                }
                catch (EntityManagerAlreadyRegisteredException e) {
                    throw new EJBException((Exception)e);
                }
            }
            createContext.setCurrentOperation(Operation.CREATE);
            createContext.setCurrentAllowedStates(null);
            TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(createContext.getBeanContext().getTransactionType(callMethod, interfaceType), createContext);
            Instance instance = null;
            try {
                try {
                    InstanceContext context = beanContext.newInstance();
                    instance = new Instance(beanContext, primaryKey, this.containerID, context.getBean(), context.getCreationalContext(), context.getInterceptors(), entityManagers, this.lockFactory.newLock(primaryKey.toString()));
                }
                catch (Throwable throwable) {
                    ThreadContext callContext = ThreadContext.getThreadContext();
                    EjbTransactionUtil.handleSystemException(callContext.getTransactionPolicy(), throwable, callContext);
                    throw new IllegalStateException(throwable);
                }
                if (!this.containsExtendedPersistenceContext(beanContext)) {
                    this.cache.add(primaryKey, instance);
                }
                this.checkedOutInstances.put(primaryKey, instance);
                this.registerSessionSynchronization(instance, createContext);
                if (!(callMethod.getDeclaringClass().equals(BeanContext.BusinessLocalHome.class) || callMethod.getDeclaringClass().equals(BeanContext.BusinessRemoteHome.class) || callMethod.getDeclaringClass().equals(BeanContext.BusinessLocalBeanHome.class))) {
                    Method createOrInit = beanContext.getMatchingBeanMethod(callMethod);
                    createContext.set(Method.class, createOrInit);
                    InterceptorStack interceptorStack = new InterceptorStack(instance.bean, createOrInit, Operation.CREATE, new ArrayList<InterceptorData>(), new HashMap<String, Object>());
                    if (args == null) {
                        interceptorStack.invoke(new Object[0]);
                    } else {
                        interceptorStack.invoke(args);
                    }
                }
                this.unregisterEntityManagers(instance, createContext);
            }
            catch (Throwable e) {
                try {
                    this.handleException(createContext, txPolicy, e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.unregisterEntityManagers(instance, createContext);
                    this.afterInvoke(createContext, txPolicy, instance);
                }
            }
            this.afterInvoke(createContext, txPolicy, instance);
            ProxyInfo proxyInfo = new ProxyInfo(beanContext, primaryKey);
            return proxyInfo;
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    protected Object newPrimaryKey() {
        return new VMID();
    }

    /*
     * Exception decompiling
     */
    protected Object removeEJBObject(BeanContext beanContext, Object primKey, Class callInterface, Method callMethod, Object[] args, InterfaceType interfaceType) throws OpenEJBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object businessMethod(BeanContext beanContext, Object primKey, Class callInterface, Method callMethod, Object[] args, InterfaceType interfaceType) throws OpenEJBException {
        ThreadContext callContext = new ThreadContext(beanContext, primKey);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        CurrentCreationalContext currentCreationalContext = beanContext.get(CurrentCreationalContext.class);
        try {
            this.checkAuthorization(callMethod, interfaceType);
            TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(callContext.getBeanContext().getTransactionType(callMethod, interfaceType), callContext);
            Object returnValue = null;
            Instance instance = null;
            try {
                BeanTransactionPolicy.SuspendedTransaction suspendedTransaction;
                instance = this.obtainInstance(primKey, callContext, callMethod, true);
                if (txPolicy instanceof BeanTransactionPolicy && (suspendedTransaction = instance.getBeanTransaction()) != null) {
                    instance.setBeanTransaction(null);
                    BeanTransactionPolicy beanTxEnv = (BeanTransactionPolicy)txPolicy;
                    beanTxEnv.resumeUserTransaction(suspendedTransaction);
                }
                this.registerEntityManagers(instance, callContext);
                this.registerSessionSynchronization(instance, callContext);
                callContext.setCurrentOperation(Operation.BUSINESS);
                callContext.setCurrentAllowedStates(null);
                callContext.setInvokedInterface(callInterface);
                Method runMethod = beanContext.getMatchingBeanMethod(callMethod);
                callContext.set(Method.class, runMethod);
                if (currentCreationalContext != null) {
                    currentCreationalContext.set(instance.creationalContext);
                }
                List<InterceptorData> interceptors = beanContext.getMethodInterceptors(runMethod);
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.BUSINESS, interceptors, instance.interceptors);
                returnValue = interceptorStack.invoke(args);
                this.unregisterEntityManagers(instance, callContext);
            }
            catch (Throwable e) {
                try {
                    this.handleException(callContext, txPolicy, e);
                    this.unregisterEntityManagers(instance, callContext);
                }
                catch (Throwable throwable) {
                    this.unregisterEntityManagers(instance, callContext);
                    this.afterInvoke(callContext, txPolicy, instance);
                    throw throwable;
                }
                this.afterInvoke(callContext, txPolicy, instance);
            }
            this.afterInvoke(callContext, txPolicy, instance);
            Object object = returnValue;
            return object;
        }
        finally {
            ThreadContext.exit(oldCallContext);
            if (currentCreationalContext != null) {
                currentCreationalContext.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instance obtainInstance(Object primaryKey, ThreadContext callContext, Method callMethod, boolean checkOutIfNecessary) throws OpenEJBException {
        boolean lockAcquired;
        Instance instance;
        if (primaryKey == null) {
            throw new SystemException(new NullPointerException("Cannot obtain an instance of the stateful session bean with a null session id"));
        }
        Transaction currentTransaction = this.getTransaction(callContext);
        StatefulContainer statefulContainer = this;
        synchronized (statefulContainer) {
            instance = (Instance)this.checkedOutInstances.get(primaryKey);
            if (instance == null) {
                try {
                    instance = this.cache.checkOut(primaryKey, checkOutIfNecessary);
                }
                catch (OpenEJBException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SystemException("Unexpected load exception", e);
                }
                if (instance == null) {
                    throw new InvalidateReferenceException(new NoSuchObjectException("Not Found"));
                }
                this.checkedOutInstances.put(primaryKey, instance);
            }
        }
        Duration accessTimeout = this.getAccessTimeout(instance.beanContext, callMethod);
        LockFactory.StatefulLock currLock = instance.getLock();
        if (accessTimeout == null || accessTimeout.getTime() < 0L) {
            currLock.lock();
            lockAcquired = true;
        } else if (accessTimeout.getTime() == 0L) {
            lockAcquired = currLock.tryLock();
        } else {
            try {
                lockAcquired = currLock.tryLock(accessTimeout.getTime(), accessTimeout.getUnit());
            }
            catch (InterruptedException e) {
                throw new ApplicationException("Unable to get lock.", e);
            }
        }
        if (!lockAcquired) {
            throw new ApplicationException((Exception)new ConcurrentAccessTimeoutException("Unable to get lock."));
        }
        if (instance.getTransaction() != null) {
            if (!instance.getTransaction().equals(currentTransaction) && !instance.getLock().tryLock()) {
                throw new ApplicationException(new RemoteException("Instance is in a transaction and cannot be invoked outside that transaction.  See EJB 3.0 Section 4.4.4"));
            }
        } else {
            instance.setTransaction(currentTransaction);
        }
        instance.setInUse(true);
        return instance;
    }

    private Duration getAccessTimeout(BeanContext beanContext, Method callMethod) {
        Duration accessTimeout = beanContext.getAccessTimeout(callMethod = beanContext.getMatchingBeanMethod(callMethod));
        if (accessTimeout == null && (accessTimeout = beanContext.getAccessTimeout()) == null) {
            accessTimeout = this.accessTimeout;
        }
        return accessTimeout;
    }

    private Transaction getTransaction(ThreadContext callContext) {
        TransactionPolicy policy = callContext.getTransactionPolicy();
        Transaction currentTransaction = null;
        if (policy instanceof JtaTransactionPolicy) {
            JtaTransactionPolicy jtaPolicy = (JtaTransactionPolicy)policy;
            currentTransaction = jtaPolicy.getCurrentTransaction();
        }
        return currentTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInstance(Instance instance) {
        if (instance.beanContext.isDestroyed()) {
            return;
        }
        instance.setInUse(false);
        if (instance.getTransaction() == null && !this.containsExtendedPersistenceContext(instance.beanContext) && null == instance.getBeanTransaction()) {
            Object object = instance.primaryKey;
            synchronized (object) {
                this.cache.checkIn(instance.primaryKey);
                this.checkedOutInstances.remove(instance.primaryKey);
            }
        }
    }

    private void discardInstance(Object primaryKey, Instance instance) {
        Instance i;
        if (primaryKey == null) {
            return;
        }
        if (instance == null) {
            i = (Instance)this.checkedOutInstances.remove(primaryKey);
        } else {
            this.checkedOutInstances.remove(primaryKey);
            i = instance;
        }
        if (i != null) {
            if (!this.containsExtendedPersistenceContext(i.beanContext)) {
                this.cache.remove(primaryKey);
            }
            if (null != i.creationalContext) {
                i.creationalContext.release();
            }
        }
    }

    private void checkAuthorization(Method callMethod, InterfaceType interfaceType) throws ApplicationException {
        boolean authorized = this.securityService.isCallerAuthorized(callMethod, interfaceType);
        if (!authorized) {
            throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
        }
    }

    private void handleException(ThreadContext callContext, TransactionPolicy txPolicy, Throwable e) throws ApplicationException {
        if (e instanceof ApplicationException) {
            throw (ApplicationException)e;
        }
        ExceptionType type = callContext.getBeanContext().getExceptionType(e);
        if (type == ExceptionType.SYSTEM) {
            this.discardInstance(callContext.getPrimaryKey(), null);
            EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
        } else {
            EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterInvoke(ThreadContext callContext, TransactionPolicy txPolicy, Instance instance) throws OpenEJBException {
        block9: {
            try {
                if (instance == null || !(txPolicy instanceof BeanTransactionPolicy)) break block9;
                BeanTransactionPolicy.SuspendedTransaction suspendedTransaction = null;
                try {
                    BeanTransactionPolicy beanTxEnv = (BeanTransactionPolicy)txPolicy;
                    suspendedTransaction = beanTxEnv.suspendUserTransaction();
                    instance.setBeanTransaction(suspendedTransaction);
                }
                catch (SystemException e) {
                    try {
                        EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
                        instance.setBeanTransaction(suspendedTransaction);
                    }
                    catch (Throwable throwable) {
                        instance.setBeanTransaction(suspendedTransaction);
                        throw throwable;
                    }
                }
            }
            finally {
                if (instance != null) {
                    instance.setInUse(false);
                }
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                if (instance != null) {
                    instance.releaseLock();
                }
            }
        }
    }

    private Index<EntityManagerFactory, JtaEntityManagerRegistry.EntityManagerTracker> createEntityManagers(BeanContext beanContext) {
        Index<EntityManagerFactory, Map> factories = beanContext.getExtendedEntityManagerFactories();
        Index<EntityManagerFactory, JtaEntityManagerRegistry.EntityManagerTracker> entityManagers = null;
        if (factories != null && factories.size() > 0) {
            entityManagers = new Index<EntityManagerFactory, JtaEntityManagerRegistry.EntityManagerTracker>(new ArrayList(factories.keySet()));
            for (Map.Entry<EntityManagerFactory, Map> entry : factories.entrySet()) {
                EntityManagerFactory entityManagerFactory = entry.getKey();
                Map properties = entry.getValue();
                JtaEntityManagerRegistry.EntityManagerTracker entityManagerTracker = this.entityManagerRegistry.getInheritedEntityManager(entityManagerFactory);
                if (entityManagerTracker == null) {
                    EntityManager entityManager = properties != null ? entityManagerFactory.createEntityManager(properties) : entityManagerFactory.createEntityManager();
                    entityManagerTracker = new JtaEntityManagerRegistry.EntityManagerTracker(entityManager);
                } else {
                    entityManagerTracker.incCounter();
                }
                entityManagers.put(entityManagerFactory, entityManagerTracker);
            }
        }
        return entityManagers;
    }

    private void registerEntityManagers(Instance instance, ThreadContext callContext) throws OpenEJBException {
        if (this.entityManagerRegistry == null) {
            return;
        }
        BeanContext beanContext = callContext.getBeanContext();
        Index<EntityManagerFactory, Map> factories = beanContext.getExtendedEntityManagerFactories();
        if (factories == null) {
            return;
        }
        Map<EntityManagerFactory, JtaEntityManagerRegistry.EntityManagerTracker> entityManagers = instance.getEntityManagers(factories);
        if (entityManagers == null) {
            return;
        }
        try {
            this.entityManagerRegistry.addEntityManagers((String)beanContext.getDeploymentID(), instance.primaryKey, entityManagers);
        }
        catch (EntityManagerAlreadyRegisteredException e) {
            throw new EJBException((Exception)e);
        }
    }

    private Map<EntityManagerFactory, JtaEntityManagerRegistry.EntityManagerTracker> unregisterEntityManagers(Instance instance, ThreadContext callContext) {
        if (this.entityManagerRegistry == null) {
            return null;
        }
        if (instance == null) {
            return null;
        }
        BeanContext beanContext = callContext.getBeanContext();
        return this.entityManagerRegistry.removeEntityManagers((String)beanContext.getDeploymentID(), instance.primaryKey);
    }

    private void closeEntityManagers(Map<EntityManagerFactory, JtaEntityManagerRegistry.EntityManagerTracker> unregisteredEntityManagers) {
        if (unregisteredEntityManagers == null) {
            return;
        }
        for (JtaEntityManagerRegistry.EntityManagerTracker entityManagerTracker : unregisteredEntityManagers.values()) {
            if (entityManagerTracker.decCounter() != 0) continue;
            entityManagerTracker.getEntityManager().close();
        }
    }

    private void registerSessionSynchronization(Instance instance, ThreadContext callContext) {
        TransactionPolicy txPolicy = callContext.getTransactionPolicy();
        if (txPolicy == null) {
            throw new IllegalStateException("ThreadContext does not contain a TransactionEnvironment");
        }
        SessionSynchronizationCoordinator coordinator = (SessionSynchronizationCoordinator)txPolicy.getResource(SessionSynchronizationCoordinator.class);
        if (coordinator == null) {
            coordinator = new SessionSynchronizationCoordinator(txPolicy);
            txPolicy.registerSynchronization(coordinator);
            txPolicy.putResource(SessionSynchronizationCoordinator.class, coordinator);
        }
        boolean synchronize = callContext.getCurrentOperation() != Operation.CREATE && callContext.getBeanContext().isSessionSynchronized() && txPolicy.isTransactionActive();
        coordinator.registerSessionSynchronization(instance, callContext.getBeanContext(), callContext.getPrimaryKey(), synchronize);
    }

    public static class BeanContextFilter
    implements Cache.CacheFilter<Instance>,
    Serializable {
        private final String id;

        public BeanContextFilter(String id) {
            this.id = id;
        }

        @Override
        public boolean matches(Instance instance) {
            return instance.beanContext.getId().equals(this.id);
        }
    }

    private static final class Data {
        private final Index<Method, MethodType> methodIndex;
        private final List<ObjectName> jmxNames = new ArrayList<ObjectName>();

        private Data(Index<Method, MethodType> methodIndex) {
            this.methodIndex = methodIndex;
        }

        public Index<Method, MethodType> getMethodIndex() {
            return this.methodIndex;
        }
    }

    public class StatefulCacheListener
    implements Cache.CacheListener<Instance> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterLoad(Instance instance) throws SystemException, ApplicationException {
            BeanContext beanContext = instance.beanContext;
            ThreadContext threadContext = new ThreadContext(instance.beanContext, instance.primaryKey, Operation.ACTIVATE);
            ThreadContext oldContext = ThreadContext.enter(threadContext);
            try {
                Method remove = instance.bean instanceof SessionBean ? SessionBean.class.getMethod("ejbActivate", new Class[0]) : null;
                List<InterceptorData> callbackInterceptors = beanContext.getCallbackInterceptors();
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, remove, Operation.ACTIVATE, callbackInterceptors, instance.interceptors);
                interceptorStack.invoke(new Object[0]);
            }
            catch (Throwable callbackException) {
                StatefulContainer.this.discardInstance(threadContext.getPrimaryKey(), instance);
                EjbTransactionUtil.handleSystemException(threadContext.getTransactionPolicy(), callbackException, threadContext);
            }
            finally {
                ThreadContext.exit(oldContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beforeStore(Instance instance) {
            BeanContext beanContext = instance.beanContext;
            ThreadContext threadContext = new ThreadContext(beanContext, instance.primaryKey, Operation.PASSIVATE);
            ThreadContext oldContext = ThreadContext.enter(threadContext);
            try {
                Method passivate = instance.bean instanceof SessionBean ? SessionBean.class.getMethod("ejbPassivate", new Class[0]) : null;
                List<InterceptorData> callbackInterceptors = beanContext.getCallbackInterceptors();
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, passivate, Operation.PASSIVATE, callbackInterceptors, instance.interceptors);
                interceptorStack.invoke(new Object[0]);
            }
            catch (Throwable e) {
                logger.error("An unexpected exception occured while invoking the ejbPassivate method on the Stateful SessionBean instance", e);
            }
            finally {
                ThreadContext.exit(oldContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timedOut(Instance instance) {
            BeanContext beanContext = instance.beanContext;
            ThreadContext threadContext = new ThreadContext(beanContext, instance.primaryKey, Operation.PRE_DESTROY);
            threadContext.setCurrentAllowedStates(null);
            ThreadContext oldContext = ThreadContext.enter(threadContext);
            try {
                Method remove = instance.bean instanceof SessionBean ? SessionBean.class.getMethod("ejbRemove", new Class[0]) : null;
                List<InterceptorData> callbackInterceptors = beanContext.getCallbackInterceptors();
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, remove, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
                interceptorStack.invoke(new Object[0]);
            }
            catch (Throwable e) {
                try {
                    logger.error("An unexpected exception occured while invoking the ejbRemove method on the timed-out stateful bean instance", e);
                }
                catch (Throwable throwable) {
                    logger.info("Removing the timed-out stateful bean instance " + instance.primaryKey + " : " + (null != instance.bean ? instance.bean.getClass().getName() : "unknown"));
                    ThreadContext.exit(oldContext);
                    throw throwable;
                }
                logger.info("Removing the timed-out stateful bean instance " + instance.primaryKey + " : " + (null != instance.bean ? instance.bean.getClass().getName() : "unknown"));
                ThreadContext.exit(oldContext);
            }
            logger.info("Removing the timed-out stateful bean instance " + instance.primaryKey + " : " + (null != instance.bean ? instance.bean.getClass().getName() : "unknown"));
            ThreadContext.exit(oldContext);
        }
    }

    private final class SessionSynchronizationCoordinator
    implements TransactionPolicy.TransactionSynchronization {
        private final Map<Object, Synchronization> registry = new HashMap<Object, Synchronization>();
        private final TransactionPolicy txPolicy;

        private SessionSynchronizationCoordinator(TransactionPolicy txPolicy) {
            this.txPolicy = txPolicy;
        }

        private void registerSessionSynchronization(Instance instance, BeanContext beanContext, Object primaryKey, boolean synchronize) {
            boolean wasSynchronized;
            Synchronization synchronization = this.registry.get(primaryKey);
            if (synchronization == null) {
                synchronization = new Synchronization(instance);
                this.registry.put(primaryKey, synchronization);
            }
            if ((wasSynchronized = synchronization.setCallSessionSynchronization(synchronize)) || !synchronize) {
                return;
            }
            ThreadContext callContext = new ThreadContext(instance.beanContext, instance.primaryKey, Operation.AFTER_BEGIN);
            callContext.setCurrentAllowedStates(null);
            ThreadContext oldCallContext = ThreadContext.enter(callContext);
            try {
                List<InterceptorData> interceptors = beanContext.getCallbackInterceptors();
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, null, Operation.AFTER_BEGIN, interceptors, instance.interceptors);
                interceptorStack.invoke(new Object[0]);
            }
            catch (Exception e) {
                String message = "An unexpected system exception occured while invoking the afterBegin method on the SessionSynchronization object";
                logger.error("An unexpected system exception occured while invoking the afterBegin method on the SessionSynchronization object", e);
                throw new OpenEJBRuntimeException("An unexpected system exception occured while invoking the afterBegin method on the SessionSynchronization object", e);
            }
            finally {
                ThreadContext.exit(oldCallContext);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void beforeCompletion() {
            Iterator<Synchronization> i$ = this.registry.values().iterator();
            while (i$.hasNext()) {
                Synchronization synchronization = i$.next();
                Instance instance = synchronization.instance;
                if (this.txPolicy.isRollbackOnly()) {
                    return;
                }
                if (!synchronization.isCallSessionSynchronization()) continue;
                ThreadContext callContext = new ThreadContext(instance.beanContext, instance.primaryKey, Operation.BEFORE_COMPLETION);
                callContext.setCurrentAllowedStates(null);
                ThreadContext oldCallContext = ThreadContext.enter(callContext);
                try {
                    instance.setInUse(true);
                    BeanContext beanContext = instance.beanContext;
                    List<InterceptorData> interceptors = beanContext.getCallbackInterceptors();
                    InterceptorStack interceptorStack = new InterceptorStack(instance.bean, null, Operation.BEFORE_COMPLETION, interceptors, instance.interceptors);
                    interceptorStack.invoke(new Object[0]);
                    instance.setInUse(false);
                    continue;
                }
                catch (InvalidateReferenceException e) {
                    continue;
                }
                catch (Exception e) {
                    String message = "An unexpected system exception occurred while invoking the beforeCompletion method on the SessionSynchronization object";
                    logger.error("An unexpected system exception occurred while invoking the beforeCompletion method on the SessionSynchronization object", e);
                    this.txPolicy.setRollbackOnly(e);
                    StatefulContainer.this.discardInstance(callContext.getPrimaryKey(), instance);
                    throw new OpenEJBRuntimeException("An unexpected system exception occurred while invoking the beforeCompletion method on the SessionSynchronization object", e);
                }
                finally {
                    ThreadContext.exit(oldCallContext);
                    continue;
                }
                break;
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void afterCompletion(TransactionPolicy.TransactionSynchronization.Status status) {
            Throwable firstException = null;
            for (Synchronization synchronization : this.registry.values()) {
                Instance instance = synchronization.instance;
                ThreadContext callContext = new ThreadContext(instance.beanContext, instance.primaryKey, Operation.AFTER_COMPLETION);
                callContext.setCurrentAllowedStates(null);
                ThreadContext oldCallContext = ThreadContext.enter(callContext);
                try {
                    instance.setInUse(true);
                    if (synchronization.isCallSessionSynchronization()) {
                        BeanContext beanContext = instance.beanContext;
                        List<InterceptorData> interceptors = beanContext.getCallbackInterceptors();
                        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, null, Operation.AFTER_COMPLETION, interceptors, instance.interceptors);
                        interceptorStack.invoke(status == TransactionPolicy.TransactionSynchronization.Status.COMMITTED);
                    }
                    instance.setTransaction(null);
                    StatefulContainer.this.releaseInstance(instance);
                }
                catch (InvalidateReferenceException inv) {
                }
                catch (Throwable e) {
                    String message = "An unexpected system exception occured while invoking the afterCompletion method on the SessionSynchronization object";
                    logger.error("An unexpected system exception occured while invoking the afterCompletion method on the SessionSynchronization object", e);
                    StatefulContainer.this.discardInstance(callContext.getPrimaryKey(), instance);
                    if (firstException != null) continue;
                    firstException = e;
                }
                finally {
                    ThreadContext.exit(oldCallContext);
                }
            }
            if (firstException != null) {
                throw new OpenEJBRuntimeException("An unexpected system exception occured while invoking the afterCompletion method on the SessionSynchronization object", firstException);
            }
        }

        public class Synchronization {
            private final Instance instance;
            private boolean callSessionSynchronization;

            public Synchronization(Instance instance) {
                this.instance = instance;
            }

            public synchronized boolean isCallSessionSynchronization() {
                return this.callSessionSynchronization;
            }

            public synchronized boolean setCallSessionSynchronization(boolean synchronize) {
                boolean oldValue = this.callSessionSynchronization;
                this.callSessionSynchronization = synchronize;
                return oldValue;
            }
        }
    }

    public static enum MethodType {
        CREATE,
        REMOVE,
        BUSINESS;

    }
}

