/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.TransactionManagerWrapper;
import org.apache.openejb.resource.XAResourceWrapper;
import org.apache.openejb.resource.jdbc.managed.local.ManagedDataSource;
import org.apache.openejb.resource.jdbc.managed.xa.ManagedXADataSource;
import org.apache.openejb.resource.jdbc.pool.DataSourceCreator;
import org.apache.openejb.util.PassthroughFactory;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public abstract class PoolDataSourceCreator
implements DataSourceCreator {
    protected final Map<Object, ObjectRecipe> recipes = new HashMap<Object, ObjectRecipe>();

    protected void cleanProperty(Object ds, String name) {
        Map unsetProperties = this.recipes.get(ds).getUnsetProperties();
        Iterator iterator = unsetProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((String)entry.getKey()).equalsIgnoreCase(name)) continue;
            iterator.remove();
        }
    }

    @Override
    public DataSource managed(String name, CommonDataSource ds) {
        TransactionManager transactionManager = OpenEJB.getTransactionManager();
        if (ds instanceof XADataSource) {
            return new ManagedXADataSource(ds, transactionManager, (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class));
        }
        return new ManagedDataSource((DataSource)DataSource.class.cast(ds), transactionManager, (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class));
    }

    @Override
    public DataSource poolManagedWithRecovery(String name, XAResourceWrapper xaResourceWrapper, String driver, Properties properties) {
        TransactionManagerWrapper transactionManager = new TransactionManagerWrapper(OpenEJB.getTransactionManager(), name, xaResourceWrapper);
        CommonDataSource ds = this.pool(name, driver, properties);
        if (ds instanceof XADataSource) {
            return new ManagedXADataSource(ds, (TransactionManager)transactionManager, (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class));
        }
        return new ManagedDataSource((DataSource)DataSource.class.cast(ds), transactionManager, (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class));
    }

    @Override
    public DataSource poolManaged(String name, DataSource ds, Properties properties) {
        return this.managed(name, this.pool(name, ds, properties));
    }

    @Override
    public DataSource poolManaged(String name, String driver, Properties properties) {
        return this.managed(name, this.pool(name, driver, properties));
    }

    @Override
    public void destroy(Object object) throws Throwable {
        if (object instanceof ManagedDataSource) {
            this.doDestroy(((ManagedDataSource)object).getDelegate());
        } else {
            this.doDestroy((DataSource)object);
        }
    }

    protected abstract void doDestroy(CommonDataSource var1) throws Throwable;

    protected <T> T build(Class<T> clazz, Properties properties) {
        ObjectRecipe serviceRecipe = new ObjectRecipe(clazz);
        this.recipeOptions(serviceRecipe);
        serviceRecipe.setAllProperties((Map)properties);
        Object value = serviceRecipe.create();
        if (value instanceof DataSource) {
            this.recipes.put(value, serviceRecipe);
        }
        return (T)value;
    }

    protected <T> T build(Class<T> clazz, Object instance, Properties properties) {
        ObjectRecipe recipe = PassthroughFactory.recipe(instance);
        this.recipeOptions(recipe);
        recipe.setAllProperties((Map)properties);
        Object value = recipe.create();
        this.recipes.put(value, recipe);
        return (T)value;
    }

    private void recipeOptions(ObjectRecipe recipe) {
        recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
    }

    @Override
    public ObjectRecipe clearRecipe(Object object) {
        if (object instanceof ManagedDataSource) {
            return this.recipes.remove(((ManagedDataSource)object).getDelegate());
        }
        return this.recipes.remove(object);
    }
}

