/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.testing;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.cdi.OptimizedLoaderService;
import org.apache.openejb.cdi.ScopeHelper;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.JSonConfigReader;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.core.LocalInitialContextFactory;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.core.ivm.naming.InitContextFactory;
import org.apache.openejb.injection.FallbackPropertyInjector;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.jee.oejb3.PojoDeployment;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.rest.RESTResourceFinder;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.testing.AppResource;
import org.apache.openejb.testing.ApplicationConfiguration;
import org.apache.openejb.testing.CdiExtensions;
import org.apache.openejb.testing.Classes;
import org.apache.openejb.testing.Component;
import org.apache.openejb.testing.Configuration;
import org.apache.openejb.testing.Descriptor;
import org.apache.openejb.testing.Descriptors;
import org.apache.openejb.testing.EnableServices;
import org.apache.openejb.testing.Jars;
import org.apache.openejb.testing.JaxrsProviders;
import org.apache.openejb.testing.MockInjector;
import org.apache.openejb.testing.Module;
import org.apache.openejb.testing.RandomPort;
import org.apache.openejb.testing.SimpleLog;
import org.apache.openejb.testing.TestInstance;
import org.apache.openejb.testing.rest.ContextProvider;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.NetworkUtil;
import org.apache.openejb.util.ServiceManagerProxy;
import org.apache.openejb.util.URLs;
import org.apache.openejb.web.LightweightWebAppBuilder;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.web.lifecycle.test.MockHttpSession;
import org.apache.webbeans.web.lifecycle.test.MockServletContext;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.xml.sax.InputSource;

public final class ApplicationComposers {
    public static final String OPENEJB_APPLICATION_COMPOSER_CONTEXT = "openejb.application.composer.context";
    private static final Class[] MODULE_TYPES = new Class[]{IAnnotationFinder.class, ClassesArchive.class, AppModule.class, WebModule.class, EjbModule.class, Application.class, WebApp.class, EjbJar.class, EnterpriseBean.class, Persistence.class, PersistenceUnit.class, Connector.class, Beans.class, Class[].class, Class.class};
    private final Map<Object, ClassFinder> testClassFinders;
    private final Class<?> testClass;
    private ServiceManagerProxy serviceManager;
    private AppInfo appInfo;
    private Assembler assembler;
    private AppContext appContext;
    private ThreadContext previous;
    private MockHttpSession session;
    private MockServletContext servletContext;
    private final Collection<String> globalJndiEntries = new ArrayList<String>();

    public ApplicationComposers(Object ... modules) {
        this(modules[0].getClass(), modules);
    }

    public ApplicationComposers(Class<?> klass, Object ... additionalModules) {
        this.testClass = klass;
        this.testClassFinders = new HashMap<Object, ClassFinder>();
        this.testClassFinders.put(this, new ClassFinder(org.apache.openejb.util.Classes.ancestors(klass)));
        if (additionalModules != null) {
            for (Object o : additionalModules) {
                this.testClassFinders.put(o, new ClassFinder(org.apache.openejb.util.Classes.ancestors(o.getClass())));
            }
        }
        this.validate();
    }

    /*
     * WARNING - void declaration
     */
    private void validate() {
        String gripe;
        void var8_22;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        Map<Object, List<Method>> annotatedConfigurationMethods = this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Configuration.class);
        int nbProp = 0;
        int nbOpenejb = 0;
        for (List<Method> list : annotatedConfigurationMethods.values()) {
            for (Method method : list) {
                Class<?> type = method.getReturnType();
                if (Openejb.class.isAssignableFrom(type) || String.class.equals(type)) {
                    ++nbOpenejb;
                    continue;
                }
                if (!Properties.class.isAssignableFrom(type)) continue;
                ++nbProp;
            }
        }
        if (nbProp > 1 || nbOpenejb > 1) {
            String gripe2 = "Test class should have no more than one @Configuration method by type (Openejb/String or Properties)";
            errors.add(new Exception("Test class should have no more than one @Configuration method by type (Openejb/String or Properties)"));
        }
        int injectorSize = 0;
        for (List<Method> m : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.MockInjector.class).values()) {
            injectorSize += m.size();
        }
        for (List<Method> m : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), MockInjector.class).values()) {
            injectorSize += m.size();
        }
        if (injectorSize > 1) {
            errors.add(new Exception("Test class should have no more than one @MockInjector method"));
        }
        ArrayList<Method> components = new ArrayList<Method>();
        for (List<Method> l : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Component.class).values()) {
            components.addAll(l);
        }
        for (List<Method> l : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.Component.class).values()) {
            components.addAll(l);
        }
        for (Method method : components) {
            if (method.getParameterTypes().length <= 0) continue;
            errors.add(new Exception("@Component methods shouldn't take any parameters"));
        }
        ArrayList<Method> descriptors = new ArrayList<Method>();
        for (List<Method> l : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Descriptors.class).values()) {
            descriptors.addAll(l);
        }
        for (List<Method> l : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.Descriptors.class).values()) {
            descriptors.addAll(l);
        }
        for (Method method : descriptors) {
            Class<?> clazz = method.getReturnType();
            if (clazz.equals(WebModule.class) || clazz.equals(EjbModule.class) || clazz.equals(WebApp.class) || clazz.equals(EjbJar.class) || clazz.equals(AppModule.class)) continue;
            errors.add(new Exception("@Descriptors can't be used on " + clazz.getName()));
        }
        ArrayList classes = new ArrayList();
        for (List list : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Classes.class).values()) {
            classes.addAll(list);
        }
        for (List list : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.Classes.class).values()) {
            classes.addAll(list);
        }
        for (Method method : classes) {
            Class<?> returnType = method.getReturnType();
            if (returnType.equals(WebModule.class) || returnType.equals(EjbModule.class) || returnType.equals(WebApp.class) || returnType.equals(EjbJar.class) || EnterpriseBean.class.isAssignableFrom(returnType)) continue;
            errors.add(new Exception("@Classes can't be used on a method returning " + returnType));
        }
        for (List list : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Jars.class).values()) {
            for (Method method : list) {
                Class<?> returnType = method.getReturnType();
                if (returnType.equals(WebModule.class) || returnType.equals(EjbModule.class) || returnType.equals(WebApp.class) || returnType.equals(EjbJar.class) || EnterpriseBean.class.isAssignableFrom(returnType)) continue;
                errors.add(new Exception("@Classes can't be used on a method returning " + returnType));
            }
        }
        int appModules = 0;
        boolean bl = false;
        ArrayList<Method> moduleMethods = new ArrayList<Method>();
        for (List<Method> l : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Module.class).values()) {
            moduleMethods.addAll(l);
        }
        for (List<Method> l : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.Module.class).values()) {
            moduleMethods.addAll(l);
        }
        for (Method method : moduleMethods) {
            ++var8_22;
            Class<?> type = method.getReturnType();
            if (Application.class.isAssignableFrom(type)) {
                ++appModules;
                continue;
            }
            if (this.isValidModuleType(type, MODULE_TYPES)) continue;
            String gripe3 = "@Module method must return " + Join.join(" or ", MODULE_TYPES).replaceAll("(class|interface) ", "");
            errors.add(new Exception(gripe3));
        }
        for (ClassFinder finder : this.testClassFinders.values()) {
            for (Field field : finder.findAnnotatedFields(RandomPort.class)) {
                Class<?> type = field.getType();
                if (Integer.TYPE == type || URL.class == type) continue;
                throw new IllegalArgumentException("@RandomPort is only supported for int fields");
            }
        }
        if (appModules > 1) {
            gripe = "Test class should have no more than one @Module method that returns " + Application.class.getName();
            errors.add(new Exception(gripe));
        }
        if (var8_22 < true) {
            gripe = "Test class should have at least one @Module method";
            errors.add(new Exception("Test class should have at least one @Module method"));
        }
        if (!errors.isEmpty()) {
            throw new OpenEJBRuntimeException(((Object)errors).toString());
        }
    }

    private Map<Object, List<Method>> findAnnotatedMethods(Map<Object, List<Method>> map, Class<? extends Annotation> annotation) {
        for (Map.Entry<Object, ClassFinder> finder : this.testClassFinders.entrySet()) {
            Object key = finder.getKey();
            List newAnnotatedMethods = finder.getValue().findAnnotatedMethods(annotation);
            List annotatedMethods = map.get(key);
            if (annotatedMethods == null) {
                annotatedMethods = newAnnotatedMethods;
                map.put(key, annotatedMethods);
                continue;
            }
            annotatedMethods.addAll(newAnnotatedMethods);
        }
        return map;
    }

    private boolean isValidModuleType(Class<?> type, Class<?>[] moduleTypes) {
        for (Class<?> moduleType : moduleTypes) {
            if (!moduleType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void before(Object inputTestInstance) throws Exception {
        void var18_45;
        CdiExtensions cdiExtensions;
        org.apache.openejb.junit.EnableServices annotationOld;
        this.testClassFinders.put(inputTestInstance, this.testClassFinders.remove(this));
        ClassLoader loader = this.testClass.getClassLoader();
        AppModule appModule = new AppModule(loader, this.testClass.getSimpleName());
        EjbJar ejbJar = new EjbJar();
        OpenejbJar openejbJar = new OpenejbJar();
        ManagedBean testBean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(this.testClass.getSimpleName(), this.testClass.getName(), true));
        testBean.localBean();
        testBean.setTransactionType(TransactionType.BEAN);
        EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)testBean);
        ejbDeployment.setDeploymentId(this.testClass.getName());
        EjbModule ejbModule = new EjbModule(ejbJar, openejbJar);
        ejbModule.getProperties().setProperty("openejb.cdi.activated", "false");
        FinderFactory.OpenEJBAnnotationFinder finder = new FinderFactory.OpenEJBAnnotationFinder((Archive)new ClassesArchive(org.apache.openejb.util.Classes.ancestors(this.testClass)));
        ejbModule.setFinder((IAnnotationFinder)finder);
        if (finder.findMetaAnnotatedFields(Inject.class).size() + finder.findMetaAnnotatedMethods(Inject.class).size() > 0) {
            ejbModule.setBeans(new Beans());
        }
        appModule.getEjbModules().add(ejbModule);
        Properties configuration = new Properties();
        configuration.put("openejb.deployments.classpath", "false");
        EnableServices annotation = this.testClass.getAnnotation(EnableServices.class);
        if (annotation != null && annotation.httpDebug()) {
            configuration.setProperty("httpejbd.print", "true");
            configuration.setProperty("httpejbd.indent.xml", "true");
            configuration.setProperty("logging.level.OpenEJB.server.http", "FINE");
        }
        if ((annotationOld = this.testClass.getAnnotation(org.apache.openejb.junit.EnableServices.class)) != null && annotationOld.httpDebug()) {
            configuration.setProperty("httpejbd.print", "true");
            configuration.setProperty("httpejbd.indent.xml", "true");
            configuration.setProperty("logging.level.OpenEJB.server.http", "FINE");
        }
        Openejb openejb = null;
        HashMap<Object, List<Method>> configs = new HashMap<Object, List<Method>>();
        this.findAnnotatedMethods(configs, Configuration.class);
        this.findAnnotatedMethods(configs, org.apache.openejb.junit.Configuration.class);
        for (Map.Entry entry : configs.entrySet()) {
            for (Method method : (List)entry.getValue()) {
                Object o = method.invoke(entry.getKey(), new Object[0]);
                if (o instanceof Properties) {
                    Properties properties = (Properties)o;
                    configuration.putAll((Map<?, ?>)properties);
                    continue;
                }
                if (Openejb.class.isInstance(o)) {
                    openejb = (Openejb)Openejb.class.cast(o);
                    continue;
                }
                if (!String.class.isInstance(o)) continue;
                String path = (String)String.class.cast(o);
                URL url = Thread.currentThread().getContextClassLoader().getResource(path);
                if (url == null) {
                    throw new IllegalArgumentException(o.toString() + " not found");
                }
                InputStream in = url.openStream();
                try {
                    if (path.endsWith(".json")) {
                        openejb = JSonConfigReader.read(Openejb.class, in);
                        continue;
                    }
                    openejb = JaxbOpenejb.readConfig(new InputSource(in));
                }
                finally {
                    IO.close((Closeable)in);
                }
            }
        }
        if (SystemInstance.isInitialized()) {
            SystemInstance.reset();
        }
        SystemInstance.init((Properties)configuration);
        for (Map.Entry<Object, Object> entry : this.testClassFinders.entrySet()) {
            for (Field field : ((ClassFinder)entry.getValue()).findAnnotatedFields(RandomPort.class)) {
                int random;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                String service = field.getAnnotation(RandomPort.class).value();
                String key = ("http".equals(service) ? "httpejbd" : service) + ".port";
                String existing = SystemInstance.get().getProperty(key);
                if (existing == null) {
                    random = NetworkUtil.getNextAvailablePort();
                    SystemInstance.get().setProperty(key, Integer.toString(random));
                } else {
                    random = Integer.parseInt(existing);
                }
                if (Integer.TYPE == field.getType()) {
                    field.set(entry.getKey(), random);
                    continue;
                }
                if (URL.class != field.getType()) continue;
                field.set(entry.getKey(), new URL("http://localhost:" + random + "/"));
            }
        }
        for (Map.Entry<Object, Object> entry : this.testClassFinders.entrySet()) {
            if (((ClassFinder)entry.getValue()).findAnnotatedClasses(SimpleLog.class).isEmpty()) continue;
            SystemInstance.get().setProperty("openejb.jul.forceReload", "true");
            break;
        }
        if ((cdiExtensions = this.testClass.getAnnotation(CdiExtensions.class)) != null) {
            SystemInstance.get().setComponent(LoaderService.class, (Object)new ExtensionAwareOptimizedLoaderService(cdiExtensions.value()));
        }
        SystemInstance.get().setComponent(TestInstance.class, (Object)new TestInstance(this.testClass, inputTestInstance));
        HashMap<Object, List<Method>> hashMap = new HashMap<Object, List<Method>>();
        this.findAnnotatedMethods(hashMap, MockInjector.class);
        this.findAnnotatedMethods(hashMap, org.apache.openejb.junit.MockInjector.class);
        if (!hashMap.isEmpty() && !((List)hashMap.values().iterator().next()).isEmpty()) {
            void var13_23;
            Map.Entry methods = hashMap.entrySet().iterator().next();
            Object object = ((Method)((List)methods.getValue()).iterator().next()).invoke(methods.getKey(), new Object[0]);
            if (object instanceof Class) {
                Object t = ((Class)object).newInstance();
            }
            if (var13_23 instanceof FallbackPropertyInjector) {
                SystemInstance.get().setComponent(FallbackPropertyInjector.class, (Object)((FallbackPropertyInjector)var13_23));
            }
        }
        for (Map.Entry entry : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Component.class).entrySet()) {
            for (Method m : (List)entry.getValue()) {
                this.setComponent(entry.getKey(), m);
            }
        }
        for (Map.Entry entry : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.Component.class).entrySet()) {
            for (Method m : (List)entry.getValue()) {
                this.setComponent(entry.getKey(), m);
            }
        }
        Map<String, URL> additionalDescriptors = ApplicationComposers.descriptorsToMap(this.testClass.getAnnotation(org.apache.openejb.junit.Descriptors.class));
        Map<String, URL> map = ApplicationComposers.descriptorsToMap(this.testClass.getAnnotation(Descriptors.class));
        additionalDescriptors.putAll(map);
        Application application = null;
        int webModulesNb = 0;
        HashMap<Object, List<Method>> moduleMethods = new HashMap<Object, List<Method>>();
        this.findAnnotatedMethods(moduleMethods, Module.class);
        this.findAnnotatedMethods(moduleMethods, org.apache.openejb.junit.Module.class);
        for (Map.Entry entry : moduleMethods.entrySet()) {
            for (Method method : (List)entry.getValue()) {
                EjbModule ejbModule2;
                Class[] beans;
                Object bean;
                EjbModule ejbModule3;
                Object obj = method.invoke(entry.getKey(), new Object[0]);
                Jars jarsAnnotation = method.getAnnotation(Jars.class);
                Classes classesAnnotation = method.getAnnotation(Classes.class);
                org.apache.openejb.junit.Classes classesAnnotationOld = method.getAnnotation(org.apache.openejb.junit.Classes.class);
                Class<?>[] classes = null;
                Class<?>[] cdiInterceptors = null;
                Class<?>[] cdiAlternatives = null;
                Class<?>[] cdiDecorators = null;
                boolean cdi = false;
                boolean innerClassesAsBean = false;
                if (classesAnnotation != null) {
                    classes = classesAnnotation.value();
                    innerClassesAsBean = classesAnnotation.innerClassesAsBean();
                    cdiInterceptors = classesAnnotation.cdiInterceptors();
                    cdiDecorators = classesAnnotation.cdiDecorators();
                    cdiAlternatives = classesAnnotation.cdiAlternatives();
                    cdi = classesAnnotation.cdi() || cdiAlternatives.length > 0 || cdiDecorators.length > 0 || cdiInterceptors.length > 0;
                } else if (classesAnnotationOld != null) {
                    classes = classesAnnotationOld.value();
                }
                if (obj instanceof WebApp) {
                    JaxrsProviders providers;
                    Object[] providersClasses;
                    ++webModulesNb;
                    WebApp webapp = (WebApp)obj;
                    String root = webapp.getContextRoot();
                    if (root == null) {
                        root = "/openejb";
                    }
                    testBean.getEnvEntry().addAll(webapp.getEnvEntry());
                    WebModule webModule = new WebModule(webapp, root, Thread.currentThread().getContextClassLoader(), "", root);
                    webModule.getAltDDs().putAll(additionalDescriptors);
                    webModule.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(method.getAnnotation(Descriptors.class)));
                    EjbModule ejbModule4 = DeploymentLoader.addWebModule(webModule, appModule);
                    ejbModule4.getProperties().put("openejb.cdi.filter.classloader", "false");
                    if (cdi) {
                        ejbModule4.setBeans(this.beans(new Beans(), cdiDecorators, cdiInterceptors, cdiAlternatives));
                    }
                    Object[] objectArray = providersClasses = (providers = method.getAnnotation(JaxrsProviders.class)) == null ? null : providers.value();
                    if (providers != null) {
                        if (classes == null) {
                            classes = providersClasses;
                        } else {
                            ArrayList newClasses = new ArrayList(Arrays.asList(classes));
                            newClasses.addAll(Arrays.asList(providersClasses));
                            classes = newClasses.toArray(new Class[newClasses.size()]);
                        }
                    }
                    if (innerClassesAsBean) {
                        LinkedList inners = new LinkedList();
                        for (Class<?> clazz : this.testClass.getClasses()) {
                            int modifiers = clazz.getModifiers();
                            try {
                                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || clazz.getConstructor(new Class[0]) == null) continue;
                                inners.add(clazz);
                            }
                            catch (NoSuchMethodException nsme) {
                                // empty catch block
                            }
                        }
                        if (!inners.isEmpty()) {
                            ArrayList newClasses = new ArrayList(Arrays.asList(classes));
                            newClasses.addAll(inners);
                            classes = newClasses.toArray(new Class[newClasses.size()]);
                        }
                    }
                    IAnnotationFinder finder3 = ApplicationComposers.finderFromClasses(webModule, classes, this.findFiles(jarsAnnotation));
                    webModule.setFinder(finder3);
                    ejbModule4.setFinder(webModule.getFinder());
                    if (providersClasses == null) continue;
                    OpenejbJar openejbJar2 = ejbModule4.getOpenejbJar();
                    if (openejbJar2 == null) {
                        openejbJar2 = new OpenejbJar();
                        ejbModule4.setOpenejbJar(openejbJar2);
                    }
                    PojoDeployment pojoDeployment = new PojoDeployment();
                    pojoDeployment.setClassName(providers.applicationName());
                    pojoDeployment.getProperties().setProperty("cxf.jaxrs.providers", Join.join(",", providersClasses).replace("class ", ""));
                    openejbJar2.getPojoDeployment().add(pojoDeployment);
                    continue;
                }
                if (obj instanceof WebModule) {
                    ++webModulesNb;
                    WebModule webModule = (WebModule)obj;
                    webModule.getAltDDs().putAll(additionalDescriptors);
                    webModule.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(method.getAnnotation(Descriptors.class)));
                    EjbModule ejbModule32 = DeploymentLoader.addWebModule(webModule, appModule);
                    if (cdi) {
                        ejbModule32.setBeans(this.beans(new Beans(), cdiDecorators, cdiInterceptors, cdiAlternatives));
                    }
                    webModule.setFinder(ApplicationComposers.finderFromClasses(webModule, classes, this.findFiles(jarsAnnotation)));
                    ejbModule32.setFinder(webModule.getFinder());
                    continue;
                }
                if (obj instanceof EjbModule) {
                    EjbModule ejbModule22 = (EjbModule)obj;
                    ejbModule22.getAltDDs().putAll(additionalDescriptors);
                    ejbModule22.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(method.getAnnotation(Descriptors.class)));
                    ejbModule22.initAppModule(appModule);
                    appModule.getEjbModules().add(ejbModule22);
                    if (cdi) {
                        ejbModule22.setBeans(this.beans(new Beans(), cdiDecorators, cdiInterceptors, cdiAlternatives));
                    }
                    ejbModule22.setFinder(ApplicationComposers.finderFromClasses(ejbModule22, classes, this.findFiles(jarsAnnotation)));
                    continue;
                }
                if (obj instanceof EjbJar) {
                    EjbJar ejbJar2 = (EjbJar)obj;
                    this.setId(ejbJar2, method);
                    ejbModule3 = new EjbModule(ejbJar2);
                    ejbModule3.getAltDDs().putAll(additionalDescriptors);
                    ejbModule3.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(method.getAnnotation(Descriptors.class)));
                    appModule.getEjbModules().add(ejbModule3);
                    if (cdi) {
                        ejbModule3.setBeans(this.beans(new Beans(), cdiDecorators, cdiInterceptors, cdiAlternatives));
                    }
                    ejbModule3.setFinder(ApplicationComposers.finderFromClasses(ejbModule3, classes, this.findFiles(jarsAnnotation)));
                    continue;
                }
                if (obj instanceof EnterpriseBean) {
                    bean = (EnterpriseBean)obj;
                    EjbJar ejbJar3 = new EjbJar(method.getName());
                    ejbJar3.addEnterpriseBean(bean);
                    EjbModule ejbModule5 = new EjbModule(ejbJar3);
                    Beans beans2 = new Beans();
                    beans2.addManagedClass(bean.getEjbClass());
                    ejbModule5.setBeans(beans2);
                    appModule.getEjbModules().add(ejbModule5);
                    if (cdi) {
                        ejbModule5.setBeans(this.beans(new Beans(), cdiDecorators, cdiInterceptors, cdiAlternatives));
                    }
                    ejbModule5.setFinder(ApplicationComposers.finderFromClasses(ejbModule5, classes, this.findFiles(jarsAnnotation)));
                    continue;
                }
                if (obj instanceof Application) {
                    application = (Application)obj;
                    this.setId(application, method);
                    continue;
                }
                if (obj instanceof Connector) {
                    Connector connector = (Connector)obj;
                    this.setId(connector, method);
                    appModule.getConnectorModules().add(new ConnectorModule(connector));
                    continue;
                }
                if (obj instanceof Persistence) {
                    Persistence persistence = (Persistence)obj;
                    appModule.addPersistenceModule(new PersistenceModule(appModule, ApplicationComposers.implicitRootUrl(), persistence));
                    continue;
                }
                if (obj instanceof PersistenceUnit) {
                    PersistenceUnit unit = (PersistenceUnit)obj;
                    appModule.addPersistenceModule(new PersistenceModule(appModule, ApplicationComposers.implicitRootUrl(), new Persistence(new PersistenceUnit[]{unit})));
                    continue;
                }
                if (obj instanceof Beans) {
                    beans = (Class[])obj;
                    ejbModule3 = new EjbModule(new EjbJar(method.getName()));
                    ejbModule3.setBeans((Beans)beans);
                    appModule.getEjbModules().add(ejbModule3);
                    if (cdi) {
                        ejbModule3.setBeans(this.beans((Beans)beans, cdiDecorators, cdiInterceptors, cdiAlternatives));
                    }
                    ejbModule3.setFinder(ApplicationComposers.finderFromClasses(ejbModule3, classes, this.findFiles(jarsAnnotation)));
                    continue;
                }
                if (obj instanceof Class[]) {
                    beans = (Class[])obj;
                    ejbModule3 = new EjbModule(new EjbJar(method.getName()));
                    ejbModule3.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(beans)).link());
                    ejbModule3.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule3);
                    continue;
                }
                if (obj instanceof Class) {
                    bean = (Class)obj;
                    ejbModule3 = new EjbModule(new EjbJar(method.getName()));
                    ejbModule3.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(new Class[]{bean})).link());
                    ejbModule3.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule3);
                    continue;
                }
                if (obj instanceof IAnnotationFinder) {
                    ejbModule2 = new EjbModule(new EjbJar(method.getName()));
                    ejbModule2.setFinder((IAnnotationFinder)obj);
                    ejbModule2.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule2);
                    continue;
                }
                if (obj instanceof ClassesArchive) {
                    ejbModule2 = new EjbModule(new EjbJar(method.getName()));
                    ejbModule2.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)obj).link());
                    ejbModule2.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule2);
                    continue;
                }
                if (!(obj instanceof AppModule)) continue;
                AppModule module = (AppModule)obj;
                module.getAltDDs().putAll(additionalDescriptors);
                module.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(method.getAnnotation(Descriptors.class)));
                if (module.getWebModules().size() > 0) {
                    ++webModulesNb;
                }
                appModule.getEjbModules().addAll(module.getEjbModules());
                appModule.getPersistenceModules().addAll(module.getPersistenceModules());
                appModule.getAdditionalLibMbeans().addAll(module.getAdditionalLibMbeans());
                appModule.getWebModules().addAll(module.getWebModules());
                appModule.getConnectorModules().addAll(module.getConnectorModules());
                appModule.getResources().addAll(module.getResources());
                appModule.getServices().addAll(module.getServices());
                appModule.getPojoConfigurations().putAll(module.getPojoConfigurations());
                appModule.getAdditionalLibraries().addAll(module.getAdditionalLibraries());
                appModule.getAltDDs().putAll(module.getAltDDs());
                appModule.getProperties().putAll((Map<?, ?>)module.getProperties());
            }
        }
        if (application != null) {
            AppModule newModule = new AppModule(appModule.getClassLoader(), appModule.getModuleId(), application, false);
            newModule.getClientModules().addAll(appModule.getClientModules());
            newModule.addPersistenceModules(appModule.getPersistenceModules());
            newModule.getEjbModules().addAll(appModule.getEjbModules());
            newModule.getConnectorModules().addAll(appModule.getConnectorModules());
            appModule = newModule;
        }
        for (Map.Entry<Object, Object> entry : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), ApplicationConfiguration.class).entrySet()) {
            for (Method m : (List)entry.getValue()) {
                Object o = m.invoke(entry.getKey(), new Object[0]);
                if (!Properties.class.isInstance(o)) continue;
                appModule.getProperties().putAll((Map<?, ?>)((Map)Properties.class.cast(o)));
            }
        }
        for (EjbModule ejbModule4 : appModule.getEjbModules()) {
            EnterpriseBean[] enterpriseBeans = ejbModule4.getEjbJar().getEnterpriseBeans();
            Beans beans = ejbModule4.getBeans();
            if (beans == null || ejbModule4.getEjbJar() == null) continue;
            for (EnterpriseBean bean : enterpriseBeans) {
                if (beans.getManagedClasses().contains(bean.getEjbClass())) continue;
                beans.addManagedClass(bean.getEjbClass());
            }
        }
        if (webModulesNb > 0 && SystemInstance.get().getComponent(WebAppBuilder.class) == null) {
            SystemInstance.get().setComponent(WebAppBuilder.class, (Object)new LightweightWebAppBuilder());
        }
        if (moduleMethods.size() == 1 && webModulesNb == 1) {
            appModule.setStandloneWebModule();
        }
        ConfigurationFactory config = new ConfigurationFactory();
        config.init(SystemInstance.get().getProperties());
        this.assembler = new Assembler();
        SystemInstance.get().setComponent(Assembler.class, (Object)this.assembler);
        if (openejb != null) {
            OpenEjbConfiguration openEjbConfiguration = config.getOpenEjbConfiguration(openejb);
        } else {
            OpenEjbConfiguration openEjbConfiguration = config.getOpenEjbConfiguration();
        }
        this.assembler.buildContainerSystem((OpenEjbConfiguration)var18_45);
        if ("true".equals(configuration.getProperty("openejb.embedded.remotable", "false")) || annotation != null || annotationOld != null) {
            try {
                if (annotation != null) {
                    this.initFilteredServiceManager(annotation.value());
                }
                if (annotationOld != null) {
                    this.initFilteredServiceManager(annotationOld.value());
                }
                this.serviceManager = new ServiceManagerProxy(false);
                this.serviceManager.start();
            }
            catch (ServiceManagerProxy.AlreadyStartedException e) {
                throw new OpenEJBRuntimeException(e);
            }
        }
        this.servletContext = new MockServletContext();
        this.session = new MockHttpSession();
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        Context jndiContext = containerSystem.getJNDIContext();
        for (EnvEntry entry : testBean.getEnvEntry()) {
            String name = entry.getName();
            String jndi = name.startsWith("java:") || name.startsWith("comp/env") ? name : "java:comp/env/" + name;
            jndiContext.bind(jndi, (Object)entry.getEnvEntryValue());
        }
        this.appInfo = config.configureApplication(appModule);
        this.appContext = this.assembler.createApplication(this.appInfo);
        ScopeHelper.startContexts(this.appContext.getWebBeansContext().getContextsService(), (ServletContext)this.servletContext, (HttpSession)this.session);
        BeanContext context = containerSystem.getBeanContext(this.testClass.getName());
        this.enrich(inputTestInstance, context);
        System.setProperty("java.naming.factory.initial", InitContextFactory.class.getName());
        System.getProperties().put(OPENEJB_APPLICATION_COMPOSER_CONTEXT, this.appContext.getGlobalJndiContext());
        ClassFinder testClassFinder = this.testClassFinders.remove(inputTestInstance);
        ArrayList fields = new ArrayList(testClassFinder.findAnnotatedFields(AppResource.class));
        fields.addAll(testClassFinder.findAnnotatedFields(org.apache.openejb.junit.AppResource.class));
        for (Field field : fields) {
            Class<?> type = field.getType();
            if (AppModule.class.isAssignableFrom(type)) {
                field.setAccessible(true);
                field.set(inputTestInstance, appModule);
                continue;
            }
            if (Context.class.isAssignableFrom(type)) {
                field.setAccessible(true);
                field.set(inputTestInstance, new InitialContext(new Properties(){
                    {
                        this.setProperty("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
                    }
                }));
                continue;
            }
            if (ContextProvider.class.isAssignableFrom(type)) {
                RESTResourceFinder finder4 = (RESTResourceFinder)SystemInstance.get().getComponent(RESTResourceFinder.class);
                if (finder4 == null || !ContextProvider.class.isInstance(finder4)) {
                    finder4 = new ContextProvider(finder4);
                    SystemInstance.get().setComponent(RESTResourceFinder.class, (Object)finder4);
                }
                field.setAccessible(true);
                field.set(inputTestInstance, finder4);
                continue;
            }
            throw new IllegalArgumentException("can't find value for type " + type.getName());
        }
        this.previous = ThreadContext.enter(new ThreadContext(context, null, Operation.BUSINESS));
        this.testClassFinders.put(this, testClassFinder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enrich(Object inputTestInstance, BeanContext context) throws OpenEJBException {
        ThreadContext callContext = new ThreadContext(context, null, Operation.INJECTION);
        ThreadContext oldContext = ThreadContext.enter(callContext);
        try {
            InjectionProcessor<Object> processor = new InjectionProcessor<Object>(inputTestInstance, context.getInjections(), context.getJndiContext());
            processor.createInstance();
            Throwable error = null;
            try {
                OWBInjector.inject((BeanManager)this.appContext.getBeanManager(), (Object)inputTestInstance, null);
            }
            catch (Throwable t) {
                error = t;
            }
            for (WebContext web : this.appContext.getWebContexts()) {
                try {
                    OWBInjector.inject((BeanManager)web.getWebBeansContext().getBeanManagerImpl(), (Object)inputTestInstance, null);
                    error = null;
                    break;
                }
                catch (Throwable t) {
                    if (error != null) continue;
                    error = t;
                }
            }
            if (error != null) {
                error.printStackTrace();
            }
        }
        finally {
            ThreadContext.exit(oldContext);
        }
    }

    private Collection<File> findFiles(Jars jarsAnnotation) {
        if (jarsAnnotation == null) {
            return null;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<URL> classpathAppsUrls = new ArrayList<URL>(8);
        if (jarsAnnotation.excludeDefaults()) {
            DeploymentsResolver.loadFromClasspath(null, classpathAppsUrls, classLoader);
        } else {
            UrlSet urlSet;
            try {
                urlSet = new UrlSet(classLoader);
                urlSet = URLs.cullSystemJars(urlSet);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            classpathAppsUrls.addAll(urlSet.getUrls());
        }
        String[] value = jarsAnnotation.value();
        ArrayList<File> files = new ArrayList<File>(value.length);
        for (String v : value) {
            int size = files.size();
            for (URL path : classpathAppsUrls) {
                File file = URLs.toFile(path);
                if (!file.getName().startsWith(v) || !file.getName().endsWith(".jar")) continue;
                files.add(file);
            }
            if (size != files.size()) continue;
            throw new IllegalArgumentException(v + " not found in classpath");
        }
        return files;
    }

    private Beans beans(Beans beans, Class<?>[] cdiDecorators, Class<?>[] cdiInterceptors, Class<?>[] cdiAlternatives) {
        if (cdiDecorators != null) {
            for (Class<?> clazz : cdiDecorators) {
                beans.addDecorator(clazz);
            }
        }
        if (cdiInterceptors != null) {
            for (Class<?> clazz : cdiInterceptors) {
                beans.addInterceptor(clazz);
            }
        }
        if (cdiAlternatives != null) {
            for (Class<?> clazz : cdiAlternatives) {
                beans.addAlternativeClass(clazz);
            }
        }
        return beans;
    }

    private void setComponent(Object testInstance, Method method) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> key;
        Object value = method.invoke(testInstance, new Object[0]);
        if (value instanceof Class) {
            value = ((Class)value).newInstance();
        }
        if (!(key = method.getReturnType()).isInstance(value)) {
            throw new OpenEJBRuntimeException(value + " is not an instance of " + key.getName());
        }
        SystemInstance.get().setComponent(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(Object testInstance, Callable<Void> next) throws Exception {
        this.before(testInstance);
        try {
            next.call();
        }
        finally {
            ThreadContext.exit(this.previous);
            this.after();
        }
    }

    public void after() throws Exception {
        if (this.assembler != null) {
            ContextsService contextsService = this.appContext.getWebBeansContext().getContextsService();
            contextsService.endContext(SessionScoped.class, (Object)this.session);
            contextsService.endContext(RequestScoped.class, null);
            contextsService.endContext(ConversationScoped.class, null);
            try {
                this.assembler.destroyApplication(this.appInfo.path);
            }
            catch (Exception e) {
                // empty catch block
            }
            ContainerSystem component = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            if (null != component) {
                Context context = component.getJNDIContext();
                for (String entry : this.globalJndiEntries) {
                    context.unbind(entry);
                }
            }
            this.globalJndiEntries.clear();
            try {
                ScopeHelper.stopContexts(contextsService, (ServletContext)this.servletContext, (HttpSession)this.session);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.serviceManager != null) {
            try {
                this.serviceManager.stop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        OpenEJB.destroy();
    }

    private <M extends NamedModule> M setId(M module, Method method) {
        return this.setId(module, method.getName());
    }

    private <M extends NamedModule> M setId(M module, String name) {
        if (module.getModuleName() != null) {
            return module;
        }
        if (module.getId() != null) {
            return module;
        }
        module.setId(name);
        return module;
    }

    private static String implicitRootUrl() {
        ResourceFinder finder = new ResourceFinder("", Thread.currentThread().getContextClassLoader());
        try {
            URL url = DeploymentLoader.altDDSources(DeploymentLoader.mapDescriptors(finder), false).get("persistence.xml");
            if (url == null) {
                return "";
            }
            File file = URLs.toFile(url);
            if (file.getName().endsWith("persistence.xml")) {
                String parent = file.getParentFile().getName();
                if (parent.equalsIgnoreCase("META-INF")) {
                    return file.getParentFile().getParentFile().getAbsolutePath();
                }
                return file.getParentFile().getAbsolutePath();
            }
            return url.toExternalForm();
        }
        catch (IOException e) {
            return "";
        }
    }

    private static Map<String, URL> descriptorsToMap(Object descriptors) {
        if (descriptors != null) {
            HashMap<String, URL> dds = new HashMap<String, URL>();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (descriptors instanceof Descriptors) {
                for (Descriptor descriptor : ((Descriptors)descriptors).value()) {
                    URL resource = loader.getResource(descriptor.path());
                    try {
                        dds.put(descriptor.name(), resource == null ? new File(descriptor.path()).toURI().toURL() : resource);
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            } else if (descriptors instanceof org.apache.openejb.junit.Descriptors) {
                for (org.apache.openejb.junit.Descriptor descriptor : ((org.apache.openejb.junit.Descriptors)descriptors).value()) {
                    URL resource = loader.getResource(descriptor.path());
                    try {
                        dds.put(descriptor.name(), resource == null ? new File(descriptor.path()).toURI().toURL() : resource);
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
            return dds;
        }
        return new HashMap<String, URL>();
    }

    private static IAnnotationFinder finderFromClasses(DeploymentModule module, Class<?>[] value, Collection<File> others) {
        ArrayList<Object> archives = new ArrayList<Object>(1 + (others == null ? 0 : others.size()));
        ArrayList classes = new ArrayList(Arrays.asList(FinderFactory.ensureMinimalClasses(module)));
        if (value != null) {
            classes.addAll(Arrays.asList(value));
        }
        archives.add(new ClassesArchive(classes));
        if (others != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (File f : others) {
                try {
                    archives.add(new JarArchive(classLoader, f.toURI().toURL()));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return new FinderFactory.OpenEJBAnnotationFinder((Archive)new CompositeArchive(archives)).link();
    }

    private void initFilteredServiceManager(String[] services) {
        Class<?> serviceManagerClass;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            serviceManagerClass = classLoader.loadClass("org.apache.openejb.server.FilteredServiceManager");
        }
        catch (ClassNotFoundException e) {
            String msg = "Services filtering requires class 'org.apache.openejb.server.FilteredServiceManager' to be available.  Make sure you have the openejb-server-*.jar in your classpath.";
            throw new IllegalStateException("Services filtering requires class 'org.apache.openejb.server.FilteredServiceManager' to be available.  Make sure you have the openejb-server-*.jar in your classpath.", e);
        }
        try {
            Method initServiceManager = serviceManagerClass.getMethod("initServiceManager", String[].class);
            initServiceManager.invoke(null, new Object[]{services});
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed initializing FilteredServiceManager with services " + Arrays.toString(services), e);
        }
    }

    private static void linkageErrorProtection() {
        ClassLoader loader = ApplicationComposers.class.getClassLoader();
        try {
            Class.forName("sun.security.pkcs11.SunPKCS11", true, loader);
            Class.forName("sun.security.pkcs11.SunPKCS11$Descriptor", true, loader);
            Class.forName("sun.security.pkcs11.wrapper.PKCS11Exception", true, loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        ApplicationComposers.linkageErrorProtection();
    }

    protected static class ExtensionAwareOptimizedLoaderService
    extends OptimizedLoaderService {
        private final Class<? extends Extension>[] extensions;

        protected ExtensionAwareOptimizedLoaderService(Class<? extends Extension>[] extensions) {
            this.extensions = extensions;
        }

        @Override
        protected List<? extends Extension> loadExtensions(ClassLoader classLoader) {
            ArrayList<Extension> list = new ArrayList<Extension>();
            for (Class<? extends Extension> e : this.extensions) {
                try {
                    list.add(e.newInstance());
                }
                catch (Exception e1) {
                    throw new OpenEJBRuntimeException(e1);
                }
            }
            return list;
        }
    }
}

