/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.Bean;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Injection;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.cdi.CdiPlugin;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PassthroughFactory;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class CdiResourceInjectionService
implements ResourceInjectionService {
    private final Logger logger = Logger.getInstance(LogCategory.OPENEJB.createChild("cdi"), CdiResourceInjectionService.class);
    private final CdiPlugin ejbPlugin;
    private final List<BeanContext> compContexts = new ArrayList<BeanContext>();

    public CdiResourceInjectionService(WebBeansContext context) {
        this.ejbPlugin = (CdiPlugin)((Object)CdiPlugin.class.cast(context.getPluginLoader().getEjbPlugin()));
    }

    public void setAppContext(AppContext appModule) {
        for (BeanContext beanContext : appModule.getBeanContexts()) {
            if (!beanContext.getBeanClass().equals(BeanContext.Comp.class)) continue;
            this.compContexts.add(beanContext);
        }
    }

    public <X, T extends Annotation> X getResourceReference(ResourceReference<X, T> resourceReference) {
        Class type = resourceReference.getResourceType();
        String name = resourceReference.getJndiName();
        try {
            return (X)type.cast(new InitialContext().lookup(name));
        }
        catch (NamingException e) {
            for (BeanContext beanContext : this.compContexts) {
                try {
                    String relativeName = name.replace("java:", "");
                    return (X)type.cast(beanContext.getJndiContext().lookup(relativeName));
                }
                catch (NamingException e1) {
                }
            }
            return null;
        }
    }

    public void injectJavaEEResources(Object managedBeanInstance) {
        if (managedBeanInstance == null) {
            return;
        }
        Class<?> managedBeanInstanceClass = managedBeanInstance.getClass();
        if (this.ejbPlugin.isSessionBean(managedBeanInstanceClass)) {
            return;
        }
        ObjectRecipe receipe = PassthroughFactory.recipe(managedBeanInstance);
        receipe.allow(Option.FIELD_INJECTION);
        receipe.allow(Option.PRIVATE_PROPERTIES);
        receipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        receipe.allow(Option.NAMED_PARAMETERS);
        this.fillInjectionProperties(receipe, managedBeanInstance);
        receipe.create();
    }

    private void fillInjectionProperties(ObjectRecipe objectRecipe, Object managedBeanInstance) {
        boolean usePrefix = true;
        Class<?> clazz = managedBeanInstance.getClass();
        for (BeanContext beanContext : this.compContexts) {
            for (Injection injection : beanContext.getInjections()) {
                if (injection.getTarget() == null || !injection.getTarget().isAssignableFrom(clazz)) continue;
                try {
                    Object value = this.lookup(beanContext, injection);
                    String prefix = injection.getTarget().getName() + "/";
                    objectRecipe.setProperty(prefix + injection.getName(), value);
                }
                catch (NamingException e) {
                    this.logger.warning("Injection data not found in JNDI context: jndiName='" + injection.getJndiName() + "', target=" + injection.getTarget().getName() + "/" + injection.getName());
                }
            }
        }
    }

    private Object lookup(BeanContext beanContext, Injection injection) throws NamingException {
        String jndiName = injection.getJndiName();
        try {
            return beanContext.getJndiContext().lookup(jndiName);
        }
        catch (NamingException e) {
            Object value;
            if (!jndiName.startsWith("java:")) {
                jndiName = "java:" + jndiName;
            }
            try {
                value = InjectionProcessor.unwrap(beanContext.getJndiContext()).lookup(jndiName);
            }
            catch (NamingException e1) {
                try {
                    value = new InitialContext().lookup(jndiName);
                }
                catch (NamingException e2) {
                    throw e;
                }
            }
            return value;
        }
    }

    public void clear() {
        this.compContexts.clear();
    }

    public <T> void writeExternal(Bean<T> bean, T actualResource, ObjectOutput out) throws IOException {
    }

    public <T> T readExternal(Bean<T> bean, ObjectInput out) throws IOException, ClassNotFoundException {
        return (T)((ResourceBean)bean).getActualInstance();
    }
}

