/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.openejb.resource.activemq.ConnectionFactoryWrapper;
import org.apache.openejb.resource.activemq.SessionWrapper;

public class ConnectionWrapper
implements Connection,
TopicConnection,
QueueConnection {
    private final ReentrantLock lock = new ReentrantLock();
    private final ArrayList<SessionWrapper> sessions = new ArrayList();
    private final String name;
    private final Connection con;

    public ConnectionWrapper(String name, Connection con) {
        this.name = name;
        this.con = con;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.getSession(this.con.createSession(transacted, acknowledgeMode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession(Session session) {
        this.lock.lock();
        try {
            SessionWrapper wrapper = new SessionWrapper(this, session);
            this.sessions.add(wrapper);
            SessionWrapper sessionWrapper = wrapper;
            return sessionWrapper;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(SessionWrapper wrapper) {
        this.lock.lock();
        try {
            this.sessions.remove(wrapper);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getClientID() throws JMSException {
        return this.con.getClientID();
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (TopicSession)TopicSession.class.cast(this.getSession((Session)((TopicConnection)TopicConnection.class.cast(this.con)).createTopicSession(transacted, acknowledgeMode)));
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return ((TopicConnection)TopicConnection.class.cast(this.con)).createConnectionConsumer(topic, messageSelector, sessionPool, maxMessages);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (QueueSession)QueueSession.class.cast(this.getSession((Session)((QueueConnection)QueueConnection.class.cast(this.con)).createQueueSession(transacted, acknowledgeMode)));
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return ((QueueConnection)QueueConnection.class.cast(this.con)).createConnectionConsumer(queue, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.con.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.con.getExceptionListener();
    }

    public void setClientID(String clientID) throws JMSException {
        this.con.setClientID(clientID);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.con.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.con.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        this.lock.lock();
        try {
            Iterator<SessionWrapper> iterator = this.sessions.iterator();
            while (iterator.hasNext()) {
                SessionWrapper next = iterator.next();
                iterator.remove();
                try {
                    next.close();
                }
                catch (Exception exception) {}
                continue;
                finally {
                    Logger.getLogger(ConnectionFactoryWrapper.class.getName()).log(Level.SEVERE, "Closed a JMS session. You have an application that fails to close a session created by this injection path: " + this.name);
                }
            }
            try {
                this.con.close();
            }
            finally {
                ConnectionFactoryWrapper.remove(this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() throws JMSException {
        this.con.stop();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.con.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.con.start();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionWrapper that = (ConnectionWrapper)o;
        return this.con.equals(that.con);
    }

    public int hashCode() {
        return this.con.hashCode();
    }

    public String getName() {
        return this.name;
    }
}

