/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.openejb.resource.activemq.ConnectionWrapper;

public class SessionWrapper
implements Session,
TopicSession,
QueueSession {
    private final ConnectionWrapper connectionWrapper;
    private final Session session;

    public SessionWrapper(ConnectionWrapper connectionWrapper, Session session) {
        this.connectionWrapper = connectionWrapper;
        this.session = session;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.session.createBytesMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.session.createTextMessage();
    }

    public Message createMessage() throws JMSException {
        return this.session.createMessage();
    }

    public boolean getTransacted() throws JMSException {
        return this.session.getTransacted();
    }

    public void rollback() throws JMSException {
        this.session.rollback();
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return this.session.createConsumer(destination, messageSelector, noLocal);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.session.createBrowser(queue);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.session.createTemporaryQueue();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.session.createMapMessage();
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.session.createConsumer(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            this.session.close();
        }
        finally {
            this.connectionWrapper.remove(this);
        }
    }

    public void unsubscribe(String name) throws JMSException {
        this.session.unsubscribe(name);
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.session.createObjectMessage(object);
    }

    public void run() {
        this.session.run();
    }

    public void recover() throws JMSException {
        this.session.recover();
    }

    public void commit() throws JMSException {
        this.session.commit();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.session.getAcknowledgeMode();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.session.createTextMessage(text);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.session.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return ((TopicSession)TopicSession.class.cast(this.session)).createPublisher(topic);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.session.createObjectMessage();
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.session.createTopic(topicName);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return ((TopicSession)TopicSession.class.cast(this.session)).createSubscriber(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return ((TopicSession)TopicSession.class.cast(this.session)).createSubscriber(topic, messageSelector, noLocal);
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.session.setMessageListener(listener);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.session.createBrowser(queue, messageSelector);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.session.createProducer(destination);
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.session.createQueue(queueName);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return ((QueueSession)QueueSession.class.cast(this.session)).createReceiver(queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return ((QueueSession)QueueSession.class.cast(this.session)).createReceiver(queue, messageSelector);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return ((QueueSession)QueueSession.class.cast(this.session)).createSender(queue);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.session.createDurableSubscriber(topic, name);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.session.createConsumer(destination, messageSelector);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.session.createStreamMessage();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.session.getMessageListener();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.session.createTemporaryTopic();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionWrapper that = (SessionWrapper)o;
        return this.connectionWrapper.equals(that.connectionWrapper) && this.session.equals(that.session);
    }

    public int hashCode() {
        int result = this.connectionWrapper.hashCode();
        result = 31 * result + this.session.hashCode();
        return result;
    }
}

