/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.loader.SystemInstance;

public class URLClassLoaderFirst
extends URLClassLoader {
    private static final boolean SKIP_LOG4J = "true".equals(SystemInstance.get().getProperty("openejb.skip.log4j", "true")) && URLClassLoaderFirst.skipLib("org.apache.log4j.Logger");
    private static final boolean SKIP_MYFACES = "true".equals(SystemInstance.get().getProperty("openejb.skip.myfaces", "true")) && URLClassLoaderFirst.skipLib("org.apache.myfaces.spi.FactoryFinderProvider");
    private static final boolean SKIP_HSQLDB = URLClassLoaderFirst.skipLib("org.hsqldb.lib.HsqlTimer");
    private static final boolean SKIP_COMMONS_NET = URLClassLoaderFirst.skipLib("org.apache.commons.net.pop3.POP3Client");
    private static final boolean SKIP_JAXWS = URLClassLoaderFirst.skipLib("org.apache.cxf.jaxws.support.JaxWsImplementorInfo");
    private static final boolean SKIP_JMS = URLClassLoaderFirst.skipLib("org.apache.activemq.broker.BrokerFactory");
    public static final Collection<String> FORCED_SKIP = new ArrayList<String>();
    public static final Collection<String> FORCED_LOAD = new ArrayList<String>();
    public static final String SLF4J_BINDER_CLASS = "org/slf4j/impl/StaticLoggerBinder.class";
    private static final URL SLF4J_CONTAINER;
    private static final String CLASS_EXT = ".class";
    public static final ClassLoader SYSTEM_CLASS_LOADER;
    private final ClassLoader system = ClassLoader.getSystemClassLoader();

    public static void reloadConfig() {
        URLClassLoaderFirst.list(FORCED_SKIP, "openejb.classloader.forced-skip");
        URLClassLoaderFirst.list(FORCED_LOAD, "openejb.classloader.forced-load");
    }

    private static void list(Collection<String> list, String key) {
        list.clear();
        String s = SystemInstance.get().getOptions().get(key, (String)null);
        if (s != null && !s.trim().isEmpty()) {
            list.addAll(Arrays.asList(s.trim().split(",")));
        }
    }

    private static boolean skipLib(String includedClass) {
        try {
            URLClassLoaderFirst.class.getClassLoader().loadClass(includedClass);
            return "true".equalsIgnoreCase(System.getProperty(includedClass + ".skip", "true"));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public URLClassLoaderFirst(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean ok;
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (URLClassLoaderFirst.canBeLoadedFromSystem(name)) {
            try {
                clazz = this.system.loadClass(name);
                if (clazz != null) {
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        boolean bl = ok = !URLClassLoaderFirst.shouldSkip(name) && !URLClassLoaderFirst.shouldDelegateToTheContainer(this, name);
        if (ok && (clazz = this.loadInternal(name, resolve)) != null) {
            return clazz;
        }
        clazz = this.loadFromParent(name, resolve);
        if (clazz != null) {
            return clazz;
        }
        if (!ok && (clazz = this.loadInternal(name, resolve)) != null) {
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    public static boolean shouldDelegateToTheContainer(ClassLoader loader, String name) {
        return URLClassLoaderFirst.shouldSkipJsf(loader, name) || URLClassLoaderFirst.shouldSkipSlf4j(loader, name);
    }

    private Class<?> loadFromParent(String name, boolean resolve) {
        ClassLoader parent = this.getParent();
        if (parent == null) {
            parent = this.system;
        }
        try {
            Class<?> clazz = Class.forName(name, false, parent);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        return null;
    }

    public Class<?> findAlreadyLoadedClass(String name) {
        return super.findLoadedClass(name);
    }

    public Class<?> loadInternal(String name, boolean resolve) {
        try {
            Class<?> clazz = this.findClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static boolean canBeLoadedFromSystem(String name) {
        return !name.startsWith("org.apache.openejb.") || !URLClassLoaderFirst.isWebAppEnrichment(name.substring("org.apache.openejb.".length()));
    }

    public static boolean shouldSkip(String name) {
        if (name == null) {
            return false;
        }
        for (String prefix : FORCED_SKIP) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        for (String prefix : FORCED_LOAD) {
            if (!name.startsWith(prefix)) continue;
            return false;
        }
        if (name.startsWith("java.")) {
            return true;
        }
        if (name.startsWith("javax.faces.")) {
            return false;
        }
        if (name.startsWith("javax.mail.")) {
            return false;
        }
        if (name.startsWith("javax.")) {
            return URLClassLoaderFirst.isInServer(name);
        }
        if (name.startsWith("sun.")) {
            return URLClassLoaderFirst.isInJvm(name);
        }
        if (name.startsWith("javax.servlet.jsp.jstl")) {
            return false;
        }
        if (name.startsWith("org.")) {
            String org = name.substring("org.".length());
            if (org.startsWith("apache.")) {
                String apache = org.substring("apache.".length());
                if (apache.startsWith("webbeans.jsf")) {
                    return false;
                }
                if (apache.startsWith("tomee.mojarra.")) {
                    return false;
                }
                if (apache.startsWith("bval.")) {
                    return true;
                }
                if (apache.startsWith("openjpa.")) {
                    return true;
                }
                if (apache.startsWith("xbean.")) {
                    return !apache.substring("xbean.".length()).startsWith("spring");
                }
                if (apache.startsWith("geronimo.")) {
                    return true;
                }
                if (apache.startsWith("coyote.")) {
                    return true;
                }
                if (apache.startsWith("webbeans.")) {
                    return true;
                }
                if (apache.startsWith("log4j.") && SKIP_LOG4J) {
                    return true;
                }
                if (apache.startsWith("catalina.")) {
                    return true;
                }
                if (apache.startsWith("jasper.")) {
                    return true;
                }
                if (apache.startsWith("tomcat.")) {
                    return true;
                }
                if (apache.startsWith("el.")) {
                    return true;
                }
                if (apache.startsWith("naming.")) {
                    return true;
                }
                if (apache.startsWith("taglibs.standard.")) {
                    return true;
                }
                if (apache.startsWith("openejb.")) {
                    return !URLClassLoaderFirst.isWebAppEnrichment(apache.substring("openejb.".length()));
                }
                if (apache.startsWith("commons.")) {
                    String commons = apache.substring("commons.".length());
                    if (commons.startsWith("beanutils.")) {
                        return URLClassLoaderFirst.isInServer(name);
                    }
                    if (commons.startsWith("cli.")) {
                        return true;
                    }
                    if (commons.startsWith("codec.")) {
                        return true;
                    }
                    if (commons.startsWith("collections.")) {
                        return true;
                    }
                    if (commons.startsWith("dbcp.")) {
                        return true;
                    }
                    if (commons.startsWith("digester.")) {
                        return true;
                    }
                    if (commons.startsWith("jocl.")) {
                        return true;
                    }
                    if (commons.startsWith("lang.")) {
                        return true;
                    }
                    if (commons.startsWith("lang3.")) {
                        return true;
                    }
                    if (commons.startsWith("logging.")) {
                        return false;
                    }
                    if (commons.startsWith("pool.")) {
                        return true;
                    }
                    return commons.startsWith("net.") && SKIP_COMMONS_NET;
                }
                if (SKIP_MYFACES && apache.startsWith("myfaces.")) {
                    String myfaces = name.substring("myfaces.".length());
                    if (myfaces.startsWith("shared.")) {
                        return true;
                    }
                    if (myfaces.startsWith("ee6.")) {
                        return true;
                    }
                    if (myfaces.startsWith("lifecycle.")) {
                        return true;
                    }
                    if (myfaces.startsWith("context.")) {
                        return true;
                    }
                    if (myfaces.startsWith("logging.")) {
                        return true;
                    }
                    if (myfaces.startsWith("component.visit.") || myfaces.equals("component.ComponentResourceContainer")) {
                        return true;
                    }
                    if (myfaces.startsWith("application.")) {
                        return true;
                    }
                    if (myfaces.startsWith("config.")) {
                        return true;
                    }
                    if (myfaces.startsWith("event.")) {
                        return true;
                    }
                    if (myfaces.startsWith("resource.")) {
                        return true;
                    }
                    if (myfaces.startsWith("el.")) {
                        return true;
                    }
                    if (myfaces.startsWith("spi.")) {
                        return true;
                    }
                    if (myfaces.startsWith("convert.")) {
                        return true;
                    }
                    if (myfaces.startsWith("debug.")) {
                        return true;
                    }
                    if (myfaces.startsWith("util.")) {
                        return true;
                    }
                    if (myfaces.startsWith("view.")) {
                        return true;
                    }
                    if (myfaces.equals("convert.ConverterUtils")) {
                        return true;
                    }
                    if (myfaces.startsWith("renderkit.")) {
                        String renderkit = myfaces.substring("renderkit.".length());
                        if (renderkit.startsWith("html.Html")) {
                            return true;
                        }
                        char firstNextletter = renderkit.charAt(0);
                        return Character.isUpperCase(firstNextletter);
                    }
                    if (myfaces.startsWith("taglib.")) {
                        String taglib = myfaces.substring("taglib.".length());
                        if (taglib.startsWith("html.Html")) {
                            return true;
                        }
                        return taglib.startsWith("core.");
                    }
                    if (myfaces.startsWith("webapp.")) {
                        String webapp = myfaces.substring("webapp.".length());
                        if (webapp.startsWith("Faces")) {
                            return true;
                        }
                        if (webapp.startsWith("Jsp")) {
                            return true;
                        }
                        if (webapp.startsWith("Startup")) {
                            return true;
                        }
                        if (webapp.equals("AbstractFacesInitializer")) {
                            return true;
                        }
                        if (webapp.equals("MyFacesServlet")) {
                            return true;
                        }
                        if (webapp.equals("ManagedBeanDestroyerListener")) {
                            return true;
                        }
                        return webapp.equals("WebConfigParamsLogger");
                    }
                    return false;
                }
                if (apache.startsWith("activemq.")) {
                    return SKIP_JMS && URLClassLoaderFirst.isInServer(name);
                }
                return false;
            }
            if (org.startsWith("hsqldb.") && SKIP_HSQLDB) {
                return true;
            }
            if (org.startsWith("codehaus.swizzle.")) {
                String swizzle = org.substring("codehaus.swizzle.".length());
                if (swizzle.startsWith("stream.")) {
                    return true;
                }
                if (swizzle.startsWith("rss.")) {
                    return true;
                }
                return swizzle.startsWith("Grep.class") || swizzle.startsWith("Lexer.class");
            }
            if (org.startsWith("w3c.dom.") || org.startsWith("xml.sax.")) {
                return URLClassLoaderFirst.isInJvm(name);
            }
            return org.startsWith("eclipse.jdt.");
        }
        if (name.startsWith("com.sun.")) {
            return URLClassLoaderFirst.isInJvm(name);
        }
        return name.startsWith("serp.bytecode.");
    }

    private static boolean isInJvm(String name) {
        return SYSTEM_CLASS_LOADER.getResource(name.replace('.', '/') + CLASS_EXT) != null;
    }

    private static boolean isInServer(String name) {
        if (name.startsWith("javax.")) {
            String sub = name.substring("javax.".length());
            if (sub.startsWith("jws.")) {
                return SKIP_JAXWS;
            }
            if (sub.startsWith("jms.")) {
                return SKIP_JMS;
            }
        }
        return ParentClassLoaderFinder.Helper.get().getResource(name.replace('.', '/') + CLASS_EXT) != null;
    }

    public static boolean shouldSkipJsf(ClassLoader loader, String name) {
        if (!name.startsWith("javax.faces.")) {
            return false;
        }
        String testClass = "javax.faces.bean.RequestScoped".equals(name) ? "javax.faces.bean.SessionScoped" : "javax.faces.bean.RequestScoped";
        String classname = testClass.replace('.', '/') + CLASS_EXT;
        try {
            Enumeration<URL> resources = loader.getResources(classname);
            ArrayList<URL> thisJSf = Collections.list(resources);
            return thisJSf.isEmpty() || thisJSf.size() <= 1;
        }
        catch (IOException e) {
            return true;
        }
    }

    private static boolean isWebAppEnrichment(String openejb) {
        return openejb.startsWith("hibernate.") || openejb.startsWith("jpa.integration.") || openejb.startsWith("toplink.") || openejb.startsWith("eclipselink.") || openejb.startsWith("arquillian.");
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return URLClassLoaderFirst.filterResources(name, super.getResources(name));
    }

    public static boolean isFilterableResource(String name) {
        return name != null && ("META-INF/services/javax.validation.spi.ValidationProvider".equals(name) || name.startsWith("META-INF/services/org.apache.myfaces.spi") || SLF4J_BINDER_CLASS.equals(name));
    }

    public static boolean shouldSkipSlf4j(ClassLoader loader, String name) {
        if (name == null || !name.startsWith("org.slf4j.")) {
            return false;
        }
        try {
            Enumeration<URL> resources = loader.getResources(SLF4J_BINDER_CLASS);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (resource.equals(SLF4J_CONTAINER)) continue;
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static Enumeration<URL> filterResources(String name, Enumeration<URL> result) {
        if (URLClassLoaderFirst.isFilterableResource(name)) {
            URL url;
            ArrayList<URL> values = Collections.list(result);
            if (values.size() > 1 && (url = URLClassLoaderFirst.class.getResource("/" + name)) != null) {
                values.remove(url);
            }
            return Collections.enumeration(values);
        }
        return result;
    }

    static {
        URLClassLoaderFirst.reloadConfig();
        SLF4J_CONTAINER = URLClassLoaderFirst.class.getClassLoader().getResource(SLF4J_BINDER_CLASS);
        SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
    }
}

