/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.util.List;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.cdi.OWBContextThreadListener;
import org.apache.openejb.cdi.RequestScopedThreadContextListener;
import org.apache.openejb.cdi.StartupObject;
import org.apache.openejb.cdi.ThreadSingletonService;
import org.apache.openejb.cdi.ThreadSingletonServiceImpl;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.spi.SingletonService;

public class CdiBuilder {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_CDI, CdiBuilder.class);
    private static final ThreadSingletonService SINGLETON_SERVICE = new ThreadSingletonServiceImpl();

    public void build(AppInfo appInfo, AppContext appContext, List<BeanContext> allDeployments) {
        this.initSingleton().initialize(new StartupObject(appContext, appInfo, allDeployments));
    }

    private ThreadSingletonService initSingleton() {
        ThreadContext.addThreadContextListener(new RequestScopedThreadContextListener());
        ThreadSingletonService singletonService = (ThreadSingletonService)SystemInstance.get().getComponent(ThreadSingletonService.class);
        logger.info("Existing thread singleton service in SystemInstance() " + singletonService);
        if (singletonService == null) {
            singletonService = CdiBuilder.initializeOWB(this.getClass().getClassLoader());
        }
        return singletonService;
    }

    public void build(AppInfo appInfo, AppContext appContext, List<BeanContext> allDeployments, WebContext webContext) {
        ThreadSingletonService singletonService = this.initSingleton();
        singletonService.initialize(new StartupObject(appContext, appInfo, allDeployments, webContext));
    }

    private boolean hasBeans(AppInfo appInfo) {
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            if (ejbJar.beans == null) continue;
            return true;
        }
        return false;
    }

    public static ThreadSingletonService initializeOWB(ClassLoader classLoader) {
        logger.info("Created new singletonService " + SINGLETON_SERVICE);
        SystemInstance.get().setComponent(ThreadSingletonService.class, (Object)SINGLETON_SERVICE);
        try {
            WebBeansFinder.setSingletonService((SingletonService)SINGLETON_SERVICE);
            logger.info("Succeeded in installing singleton service");
        }
        catch (Exception e) {
            logger.debug("Could not install our singleton service");
        }
        ThreadContext.addThreadContextListener(new OWBContextThreadListener());
        return SINGLETON_SERVICE;
    }
}

