/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.NoSuchObjectException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.ejb.NoSuchEJBException;
import javax.ejb.Remove;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.SessionBeanType;
import javax.persistence.EntityManager;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.ProxyInterfaceResolver;
import org.apache.openejb.cdi.CurrentCreationalContext;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class CdiEjbBean<T>
extends BaseEjbBean<T> {
    private final Map<Integer, Object> dependentSFSBToBeRemoved = new ConcurrentHashMap<Integer, Object>();
    private final BeanContext beanContext;

    public CdiEjbBean(BeanContext beanContext, WebBeansContext webBeansContext) {
        this(beanContext, webBeansContext, beanContext.getManagedClass());
    }

    public CdiEjbBean(BeanContext beanContext, WebBeansContext webBeansContext, Class beanClass) {
        super(beanClass, CdiEjbBean.toSessionType(beanContext.getComponentType()), webBeansContext);
        this.beanContext = beanContext;
        beanContext.set(Bean.class, this);
    }

    public void validatePassivationDependencies() {
        if (this.isPassivationCapable()) {
            Set beanInjectionPoints = this.getInjectionPoints();
            for (InjectionPoint injectionPoint : beanInjectionPoints) {
                if (injectionPoint.isTransient() || this.getWebBeansContext().getWebBeansUtil().isPassivationCapableDependency(injectionPoint) || injectionPoint.getAnnotated().isAnnotationPresent(Disposes.class) || EntityManager.class.equals((Object)injectionPoint.getAnnotated().getBaseType())) continue;
                throw new WebBeansConfigurationException("Passivation capable beans must satisfy passivation capable dependencies. Bean : " + this.toString() + " does not satisfy. Details about the Injection-point: " + injectionPoint.toString());
            }
        }
        for (Decorator dec : this.decorators) {
            WebBeansDecorator decorator = (WebBeansDecorator)dec;
            if (!decorator.isPassivationCapable()) {
                throw new WebBeansConfigurationException(MessageFormat.format(WebBeansLoggerFacade.getTokenString((String)"EXCEPT_0015"), this.toString()));
            }
            decorator.validatePassivationDependencies();
        }
        for (InterceptorData interceptorData : this.interceptorStack) {
            if (interceptorData.isDefinedWithWebBeansInterceptor()) {
                WebBeansInterceptor interceptor = (WebBeansInterceptor)interceptorData.getWebBeansInterceptor();
                if (!interceptor.isPassivationCapable()) {
                    throw new WebBeansConfigurationException(MessageFormat.format(WebBeansLoggerFacade.getTokenString((String)"EXCEPT_0016"), this.toString()));
                }
                interceptor.validatePassivationDependencies();
                continue;
            }
            if (!interceptorData.isDefinedInInterceptorClass()) continue;
            Class interceptorClass = interceptorData.getInterceptorClass();
            if (!Serializable.class.isAssignableFrom(interceptorClass)) {
                throw new WebBeansConfigurationException(MessageFormat.format(WebBeansLoggerFacade.getTokenString((String)"EXCEPT_0016"), this.toString()));
            }
            if (this.getWebBeansContext().getAnnotationManager().checkInjectionPointForInterceptorPassivation(interceptorClass)) continue;
            throw new WebBeansConfigurationException(MessageFormat.format(WebBeansLoggerFacade.getTokenString((String)"EXCEPT_0017"), this.toString(), interceptorClass));
        }
    }

    public void addApiType(Class<?> apiType) {
        if (apiType == null) {
            return;
        }
        super.addApiType(apiType);
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    private static SessionBeanType toSessionType(BeanType beanType) {
        switch (beanType) {
            case SINGLETON: {
                return SessionBeanType.SINGLETON;
            }
            case MESSAGE_DRIVEN: 
            case STATELESS: {
                return SessionBeanType.STATELESS;
            }
            case STATEFUL: 
            case MANAGED: {
                return SessionBeanType.STATEFUL;
            }
        }
        throw new IllegalStateException("Unknown Session BeanType " + (Object)((Object)beanType));
    }

    public String getId() {
        return this.beanContext.getDeploymentID() + this.getReturnType().getName();
    }

    protected void afterConstructor(T instance, CreationalContext<T> tCreationalContext) {
    }

    public String getEjbName() {
        return this.beanContext.getEjbName();
    }

    public boolean needsBeanLocalViewAddedToTypes() {
        return this.beanContext.isLocalbean() && this.beanContext.getBeanClass().getAnnotation(Typed.class) == null;
    }

    public List<Class<?>> getBusinessLocalInterfaces() {
        List<Class> cl;
        ArrayList clazzes = new ArrayList();
        if (this.beanContext.isLocalbean()) {
            CdiEjbBean.addApiTypes(clazzes, this.beanContext.getBeanClass());
        }
        if (this.beanContext.getProxyClass() != null) {
            CdiEjbBean.addApiTypes(clazzes, this.beanContext.getProxyClass());
        }
        if ((cl = this.beanContext.getBusinessLocalInterfaces()) != null && !cl.isEmpty()) {
            for (Class c : cl) {
                clazzes.add(c);
            }
        }
        return clazzes;
    }

    private static void addApiTypes(List<Class<?>> clazzes, Class<?> beanClass) {
        Typed typed = beanClass.getAnnotation(Typed.class);
        if (typed == null || typed.value().length == 0) {
            clazzes.add(beanClass);
        } else {
            for (Class clazz : typed.value()) {
                clazzes.add(clazz);
            }
        }
    }

    protected T getInstance(CreationalContext<T> creationalContext) {
        Object instance;
        if (this.scopeClass == null || Dependent.class == this.scopeClass) {
            instance = this.createEjb(creationalContext);
        } else {
            InstanceBean<T> bean = new InstanceBean<T>(this);
            if (this.webBeansContext.getBeanManagerImpl().isScopeTypeNormal(this.scopeClass)) {
                instance = this.webBeansContext.getProxyFactory().createNormalScopedBeanProxy(bean, creationalContext);
            } else {
                Context context = this.webBeansContext.getBeanManagerImpl().getContext(this.scopeClass);
                instance = context.get(bean, creationalContext);
            }
            bean.setOWBProxy(instance);
        }
        return instance;
    }

    protected void destroyComponentInstance(T instance, CreationalContext<T> creational) {
        if (this.scopeClass == null || Dependent.class == this.scopeClass) {
            this.destroyStatefulSessionBeanInstance(instance, creational);
        } else {
            this.destroyScopedStateful(instance, creational);
        }
    }

    protected void destroyStatefulSessionBeanInstance(T proxyInstance, Object ejbInstance) {
        block7: {
            if (proxyInstance instanceof BeanContext.Removable) {
                try {
                    ((BeanContext.Removable)proxyInstance).$$remove();
                }
                catch (NoSuchEJBException nsee) {
                }
                catch (UndeclaredThrowableException nsoe) {
                    if (!(nsoe.getCause() instanceof NoSuchObjectException)) {
                        throw nsoe;
                    }
                }
                catch (Exception e) {
                    if (e instanceof NoSuchObjectException) break block7;
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new OpenEJBRuntimeException(e);
                }
            }
        }
    }

    public List<Method> getRemoveMethods() {
        if (this.beanContext.isLocalbean()) {
            return this.findRemove(this.beanContext.getBeanClass(), this.beanContext.getBeanClass());
        }
        return this.findRemove(this.beanContext.getBeanClass(), this.beanContext.getBusinessLocalInterface());
    }

    public List<InjectionPoint> getInjectionPoint(Member member) {
        if (member instanceof Method) {
            Method method = (Method)member;
            member = this.beanContext.getMatchingBeanMethod(method);
        }
        ArrayList<InjectionPoint> points = new ArrayList<InjectionPoint>();
        for (InjectionPoint ip : this.injectionPoints) {
            if (!ip.getMember().equals(member)) continue;
            points.add(ip);
        }
        return points;
    }

    protected void specialize(CdiEjbBean<?> superBean) {
        CdiEjbBean bean = this;
        bean.setName(superBean.getName());
        bean.setSerializable(superBean.isSerializable());
        this.scopeClass = superBean.scopeClass;
        this.implQualifiers.addAll(superBean.getQualifiers());
        this.stereoTypeClasses.addAll(superBean.stereoTypeClasses);
        this.stereoTypes.addAll(superBean.stereoTypes);
    }

    public boolean isPassivationCapable() {
        return this.getWebBeansContext().getBeanManagerImpl().isPassivatingScope(this.getScope());
    }

    private List<Method> findRemove(Class beanClass, Class beanInterface) {
        Method[] methods;
        ArrayList<Method> toReturn = new ArrayList<Method>();
        for (Method method : methods = beanClass.getMethods()) {
            Remove annotation = method.getAnnotation(Remove.class);
            if (annotation == null) continue;
            try {
                Method interfaceMethod = beanInterface.getMethod(method.getName(), method.getParameterTypes());
                toReturn.add(interfaceMethod);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T createEjb(CreationalContext<T> creationalContext) {
        List<Class> classes = this.beanContext.getBusinessLocalInterfaces();
        CurrentCreationalContext currentCreationalContext = this.beanContext.get(CurrentCreationalContext.class);
        CreationalContext existing = currentCreationalContext.get();
        currentCreationalContext.set(creationalContext);
        try {
            if (classes.size() == 0 && this.beanContext.isLocalbean()) {
                BeanContext.BusinessLocalBeanHome home = this.beanContext.getBusinessLocalBeanHome();
                Object object = home.create();
                return (T)object;
            }
            Class mainInterface = classes.get(0);
            List<Class> interfaces = ProxyInterfaceResolver.getInterfaces(this.beanContext.getBeanClass(), mainInterface, classes);
            BeanContext.BusinessLocalHome home = this.beanContext.getBusinessLocalHome(interfaces, mainInterface);
            Object object = home.create();
            return (T)object;
        }
        finally {
            currentCreationalContext.set(existing);
        }
    }

    private void destroyScopedStateful(T instance, CreationalContext<T> cc) {
        try {
            instance.hashCode();
        }
        catch (NoSuchEJBException e) {
            this.logger.log(Level.FINE, "The stateful instance " + instance + " can't be removed since it was invalidated", e);
            return;
        }
        Object ejbInstance = this.dependentSFSBToBeRemoved.remove(System.identityHashCode(instance));
        if (ejbInstance != null) {
            this.destroyStatefulSessionBeanInstance(ejbInstance, cc);
        } else {
            this.destroyStatefulSessionBeanInstance(instance, cc);
        }
    }

    private static class InstanceBean<T>
    implements OwbBean<T> {
        private final CdiEjbBean<T> bean;
        private T OWBProxy;

        public InstanceBean(CdiEjbBean<T> tCdiEjbBean) {
            this.bean = tCdiEjbBean;
        }

        public T createNewInstance(CreationalContext<T> creationalContext) {
            return this.create(creationalContext);
        }

        public void destroyCreatedInstance(T instance, CreationalContext<T> creationalContext) {
            this.bean.destroyComponentInstance(instance, creationalContext);
        }

        public Set<Type> getTypes() {
            return this.bean.getTypes();
        }

        public Set<Annotation> getQualifiers() {
            return this.bean.getQualifiers();
        }

        public Class<? extends Annotation> getScope() {
            return this.bean.getScope();
        }

        public String getName() {
            return this.bean.getName();
        }

        public boolean isNullable() {
            return this.bean.isNullable();
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public Class<?> getBeanClass() {
            return this.bean.getBeanClass();
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.bean.getStereotypes();
        }

        public boolean isAlternative() {
            return this.bean.isAlternative();
        }

        public T create(CreationalContext<T> creationalContext) {
            Object instance = ((CdiEjbBean)this.bean).createEjb(creationalContext);
            if (this.OWBProxy != null && SessionBeanType.STATEFUL.equals((Object)this.bean.getEjbType())) {
                ((CdiEjbBean)this.bean).dependentSFSBToBeRemoved.put(System.identityHashCode(this.OWBProxy), instance);
            }
            return (T)instance;
        }

        public void destroy(T instance, CreationalContext<T> cc) {
            if (!SessionBeanType.STATEFUL.equals((Object)this.bean.getEjbType())) {
                return;
            }
            this.bean.destroy(instance, cc);
        }

        public void setImplScopeType(Annotation scopeType) {
        }

        public WebBeansType getWebBeansType() {
            return this.bean.getWebBeansType();
        }

        public void addQualifier(Annotation qualifier) {
        }

        public boolean isSerializable() {
            return this.bean.isSerializable();
        }

        public void addStereoType(Annotation stereoType) {
        }

        public void addApiType(Class<?> apiType) {
        }

        public void addInjectionPoint(InjectionPoint injectionPoint) {
        }

        public Set<Annotation> getOwbStereotypes() {
            return this.bean.getOwbStereotypes();
        }

        public void setName(String name) {
        }

        public List<InjectionPoint> getInjectionPoint(Member member) {
            return Collections.emptyList();
        }

        public Class<T> getReturnType() {
            return this.bean.getReturnType();
        }

        public void setSerializable(boolean serializable) {
        }

        public void setNullable(boolean nullable) {
        }

        public void setSpecializedBean(boolean specialized) {
        }

        public boolean isSpecializedBean() {
            return this.bean.isSpecializedBean();
        }

        public void setEnabled(boolean enabled) {
        }

        public boolean isEnabled() {
            return this.bean.isEnabled();
        }

        public String getId() {
            return this.bean.getId();
        }

        public boolean isPassivationCapable() {
            return this.bean.isPassivationCapable();
        }

        public boolean isDependent() {
            return this.bean.isDependent();
        }

        public void validatePassivationDependencies() {
            this.bean.validatePassivationDependencies();
        }

        public WebBeansContext getWebBeansContext() {
            return this.bean.getWebBeansContext();
        }

        public void setOWBProxy(T OWBProxy) {
            this.OWBProxy = OWBProxy;
        }
    }
}

