/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.openejb.config.sys.AbstractService;
import org.apache.openejb.config.sys.PropertiesAdapter;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.Service;
import org.apache.openejb.util.Join;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StackHandler
extends DefaultHandler {
    private static final boolean DEBUG = Boolean.getBoolean("openejb.sax.debug");
    private final List<DefaultHandler> handlers = new LinkedList<DefaultHandler>();

    protected DefaultHandler get() {
        return this.handlers.get(0);
    }

    protected DefaultHandler pop() {
        return this.handlers.remove(0);
    }

    protected void checkAttributes(Attributes attributes, String ... allowed) throws SAXException {
        this.checkAttributes(attributes, new ArrayList<String>(Arrays.asList(allowed)));
    }

    protected void checkAttributes(Attributes attributes, List<String> allowed) throws SAXException {
        ArrayList<String> invalid = new ArrayList<String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (allowed.contains(attributes.getLocalName(i))) continue;
            invalid.add(attributes.getLocalName(i));
        }
        if (invalid.size() > 0) {
            throw new SAXException("Unsupported Attribute(s): " + Join.join(", ", invalid) + ".  Supported Attributes are: " + Join.join(", ", allowed) + ".  If the setting is a configuration property it must be placed inside the element body.");
        }
    }

    protected void push(DefaultHandler handler) {
        if (DEBUG) {
            for (int i = 0; i < this.handlers.size(); ++i) {
                System.out.print("  ");
            }
            System.out.println("+ " + handler);
        }
        this.handlers.add(0, handler);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (DEBUG) {
            for (int i = 0; i < this.handlers.size(); ++i) {
                System.out.print("  ");
            }
            System.out.println("> " + this.get());
        }
        this.get().startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.get().endElement(uri, localName, qName);
        if (!DEBUG) {
            this.pop();
        } else {
            for (int i = 0; i < this.handlers.size(); ++i) {
                System.out.print("  ");
            }
            System.out.println(" - " + this.pop());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.get().characters(ch, start, length);
    }

    public class DeclaredServiceElement
    extends ServiceElement<Service> {
        private final Collection<Service> services;

        public DeclaredServiceElement(Collection<Service> services) {
            super(StackHandler.this, (AbstractService)new Service());
            this.services = services;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            ((Service)this.service).setClazz(attributes.getValue("class"));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.services.add((Service)this.service);
            super.endElement(uri, localName, qName);
        }

        @Override
        protected List<String> getAttributes() {
            List<String> attributes = super.getAttributes();
            attributes.add("class");
            return attributes;
        }
    }

    public class ResourceElement
    extends ServiceElement<Resource> {
        private final Collection<Resource> resources;

        public ResourceElement(Collection<Resource> resources) {
            super(StackHandler.this, (AbstractService)new Resource());
            this.resources = resources;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            ((Resource)this.service).setJndi(attributes.getValue("jndi"));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.resources.add((Resource)this.service);
            super.endElement(uri, localName, qName);
        }

        @Override
        protected List<String> getAttributes() {
            List<String> attributes = super.getAttributes();
            attributes.add("jndi");
            return attributes;
        }
    }

    public static abstract class ServiceElement<S extends AbstractService>
    extends Content {
        final S service;
        final /* synthetic */ StackHandler this$0;

        protected ServiceElement(S service) {
            this.this$0 = var1_1;
            this.service = service;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (attributes.getValue("type") != null) {
                ((AbstractService)this.service).setType(attributes.getValue("type"));
            }
            if (attributes.getValue("jar") != null) {
                ((AbstractService)this.service).setJar(attributes.getValue("jar"));
            }
            if (attributes.getValue("provider") != null) {
                ((AbstractService)this.service).setProvider(attributes.getValue("provider"));
            }
            if (attributes.getValue("id") != null) {
                ((AbstractService)this.service).setId(attributes.getValue("id"));
            }
            if (attributes.getValue("class-name") != null) {
                ((AbstractService)this.service).setClassName(attributes.getValue("class-name"));
            }
            if (attributes.getValue("constructor") != null) {
                ((AbstractService)this.service).setConstructor(attributes.getValue("constructor"));
            }
            if (attributes.getValue("factory-name") != null) {
                ((AbstractService)this.service).setFactoryName(attributes.getValue("factory-name"));
            }
            this.this$0.checkAttributes(attributes, this.getAttributes());
        }

        protected List<String> getAttributes() {
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("type");
            attributes.add("jar");
            attributes.add("provider");
            attributes.add("id");
            attributes.add("class-name");
            attributes.add("constructor");
            attributes.add("factory-name");
            return attributes;
        }

        @Override
        public void setValue(String text) {
            try {
                ((AbstractService)this.service).getProperties().putAll((Map<?, ?>)new PropertiesAdapter().unmarshal(text));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class Content
    extends DefaultHandler {
        private StringBuilder characters = new StringBuilder();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.characters = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.characters.append(new String(ch, start, length));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.setValue(this.characters.toString());
        }

        public void setValue(String text) {
        }
    }
}

