/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.AppContext;
import org.apache.openejb.Injection;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.cdi.ConstructorInjectionBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.inject.AbstractInjectable;

public class WebContext {
    private String id;
    private ClassLoader classLoader;
    private final Collection<Injection> injections = new ArrayList<Injection>();
    private Context jndiEnc;
    private final AppContext appContext;
    private Map<String, Object> bindings;
    private Map<Object, CreationalContext<?>> creatonalContexts = new ConcurrentHashMap();
    private WebBeansContext webbeansContext;
    private String contextRoot;
    private Context initialContext;

    public Context getInitialContext() {
        if (this.initialContext != null) {
            return this.initialContext;
        }
        try {
            this.initialContext = (Context)new InitialContext().lookup("java:");
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
        return this.initialContext;
    }

    public void setInitialContext(Context initialContext) {
        this.initialContext = initialContext;
    }

    public WebContext(AppContext appContext) {
        this.appContext = appContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Collection<Injection> getInjections() {
        return this.injections;
    }

    public Context getJndiEnc() {
        return this.jndiEnc;
    }

    public void setJndiEnc(Context jndiEnc) {
        this.jndiEnc = jndiEnc;
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newInstance(Class beanClass) throws OpenEJBException {
        WebBeansContext webBeansContext = this.getWebBeansContext();
        ConstructorInjectionBean beanDefinition = new ConstructorInjectionBean(webBeansContext, beanClass).complete();
        CreationalContext creationalContext = webBeansContext.getBeanManagerImpl().createCreationalContext(beanDefinition);
        Object o = beanDefinition.create(creationalContext);
        Context unwrap = InjectionProcessor.unwrap(this.getInitialContext());
        InjectionProcessor<Object> injectionProcessor = new InjectionProcessor<Object>(o, this.injections, unwrap);
        Object beanInstance = injectionProcessor.createInstance();
        Object oldInstanceUnderInjection = AbstractInjectable.instanceUnderInjection.get();
        try {
            AbstractInjectable.instanceUnderInjection.set(null);
            InjectionTargetBean bean = (InjectionTargetBean)InjectionTargetBean.class.cast((Object)beanDefinition);
            bean.injectResources(beanInstance, creationalContext);
            bean.injectSuperFields(beanInstance, creationalContext);
            bean.injectSuperMethods(beanInstance, creationalContext);
            bean.injectFields(beanInstance, creationalContext);
            bean.injectMethods(beanInstance, creationalContext);
        }
        finally {
            if (oldInstanceUnderInjection != null) {
                AbstractInjectable.instanceUnderInjection.set(oldInstanceUnderInjection);
            } else {
                AbstractInjectable.instanceUnderInjection.remove();
            }
        }
        this.creatonalContexts.put(beanInstance, creationalContext);
        return beanInstance;
    }

    private WebBeansContext getWebBeansContext() {
        if (this.webbeansContext == null) {
            return this.getAppContext().getWebBeansContext();
        }
        return this.webbeansContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object inject(Object o) throws OpenEJBException {
        try {
            WebBeansContext webBeansContext = this.getWebBeansContext();
            ConstructorInjectionBean<?> beanDefinition = new ConstructorInjectionBean(webBeansContext, o.getClass()).complete();
            CreationalContext creationalContext = webBeansContext.getBeanManagerImpl().createCreationalContext(beanDefinition);
            Context initialContext = (Context)new InitialContext().lookup("java:");
            Context unwrap = InjectionProcessor.unwrap(initialContext);
            InjectionProcessor<Object> injectionProcessor = new InjectionProcessor<Object>(o, this.injections, unwrap);
            Object beanInstance = injectionProcessor.createInstance();
            Object oldInstanceUnderInjection = AbstractInjectable.instanceUnderInjection.get();
            try {
                AbstractInjectable.instanceUnderInjection.set(null);
                InjectionTargetBean bean = (InjectionTargetBean)InjectionTargetBean.class.cast(beanDefinition);
                bean.injectResources(beanInstance, creationalContext);
                bean.injectSuperFields(beanInstance, creationalContext);
                bean.injectSuperMethods(beanInstance, creationalContext);
                bean.injectFields(beanInstance, creationalContext);
                bean.injectMethods(beanInstance, creationalContext);
            }
            finally {
                if (oldInstanceUnderInjection != null) {
                    AbstractInjectable.instanceUnderInjection.set(oldInstanceUnderInjection);
                } else {
                    AbstractInjectable.instanceUnderInjection.remove();
                }
            }
            return beanInstance;
        }
        catch (NamingException e) {
            throw new OpenEJBException(e);
        }
    }

    public void setBindings(Map<String, Object> bindings) {
        this.bindings = bindings;
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    public void setWebbeansContext(WebBeansContext webbeansContext) {
        this.webbeansContext = webbeansContext;
    }

    public WebBeansContext getWebbeansContext() {
        return this.webbeansContext;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void destroy(Object o) {
        CreationalContext<?> ctx = this.creatonalContexts.remove(o);
        if (ctx != null) {
            ctx.release();
        }
    }
}

