/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.osgi.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.core.osgi.impl.Deployer;
import org.apache.openejb.core.osgi.impl.OpenEJBBundleContextHolder;
import org.apache.openejb.loader.OpenEJBInstance;
import org.apache.openejb.loader.SystemInstance;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private static final String SERVICE_MANAGER_NAME = "org.apache.openejb.server.ServiceManager";
    private static final long TRACKER_TIMEOUT = SystemInstance.get().getOptions().get("openejb.osgi.tracker.timeout", 30);
    public static final String OPENEJB_OSGI_NATIVE_TRANSACTION_MANAGER = "openejb.osgi.native-transaction-manager";
    private OpenEJBInstance openejb;
    private Object serviceManager;

    public void start(BundleContext context) throws Exception {
        LOGGER.info("Starting OpenEJB for bundle #{}", (Object)context.getBundle().getBundleId());
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.openejb = new OpenEJBInstance();
        OpenEJBBundleContextHolder.set(context);
        Properties env = new Properties();
        env.setProperty("openejb.loader", "context");
        env.setProperty("openejb.deployments.classpath", "false");
        env.setProperty("openejb.nobanner", "true");
        env.setProperty("openejb.classloader.forced-skip", "org.slf4j");
        env.setProperty("openejb.modulename.useHash", "true");
        env.setProperty("openejb.cdi.filter.classloader", "false");
        SystemInstance.init((Properties)env);
        if (!SystemInstance.get().getOptions().get(OPENEJB_OSGI_NATIVE_TRANSACTION_MANAGER, false)) {
            ServiceReference sr = context.getServiceReference(TransactionManager.class.getName());
            if (sr != null) {
                TransactionManager txMgr = (TransactionManager)context.getService(sr);
                if (txMgr != null) {
                    SystemInstance.get().setComponent(TransactionManager.class, (Object)txMgr);
                } else {
                    LOGGER.info("Using standard OpenEJB Transaction Manager (but found a service reference on an OSGi one)");
                }
            } else {
                LOGGER.info("Using standard OpenEJB Transaction Manager");
            }
        }
        try {
            this.openejb.init(env);
        }
        catch (Exception e) {
            LOGGER.error("can't start the bundle", (Throwable)e);
            throw e;
        }
        this.checkServiceManager(context);
        context.addBundleListener((BundleListener)new Deployer(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkServiceManager(BundleContext context) {
        if (this.serviceManager != null) {
            return;
        }
        ServiceTracker serviceManagerTracker = null;
        try {
            serviceManagerTracker = Activator.getServiceManager(context);
            this.serviceManager = serviceManagerTracker.getService();
            if (this.serviceManager == null) {
                LOGGER.warn("can't find service manager");
                return;
            }
            Activator.invoke(this.serviceManager, "init");
            Activator.invoke(this.serviceManager, "start");
        }
        catch (InterruptedException ie) {
            LOGGER.warn("can't find service manager");
        }
        catch (Exception e) {
            LOGGER.error("can't start OpenEJB services");
        }
        finally {
            if (serviceManagerTracker != null) {
                serviceManagerTracker.close();
            }
        }
    }

    private static ServiceTracker getServiceManager(BundleContext context) throws InterruptedException {
        ServiceTracker serviceManagerTracker = new ServiceTracker(context, SERVICE_MANAGER_NAME, null);
        serviceManagerTracker.open();
        serviceManagerTracker.waitForService(TRACKER_TIMEOUT);
        return serviceManagerTracker;
    }

    public void stop(BundleContext context) throws Exception {
        LOGGER.info("Stopping OpenEJB");
        try {
            Activator.invoke(this.serviceManager, "stop");
        }
        catch (Exception e) {
            LOGGER.error("can't stop OpenEJB services");
        }
        this.openejb = null;
        SystemInstance.reset();
        OpenEJB.destroy();
    }

    private static void invoke(Object serviceManager, String name) throws OpenEJBException, InvocationTargetException, IllegalAccessException {
        if (serviceManager == null) {
            LOGGER.warn("can't invoke method {} since the service manager is null", (Object)name);
            return;
        }
        Class<?> current = serviceManager.getClass();
        Method mtd = null;
        while (mtd == null || !current.equals(Object.class)) {
            try {
                mtd = current.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            current = current.getSuperclass();
        }
        if (mtd == null) {
            throw new OpenEJBException("can't find method " + name + " on service " + serviceManager);
        }
        mtd.invoke(serviceManager, new Object[0]);
    }
}

