/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.osgi.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.BeansInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.cdi.CdiScanner;
import org.apache.openejb.cdi.OptimizedLoaderService;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.UnknownModuleTypeException;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.core.osgi.impl.Activator;
import org.apache.openejb.core.osgi.impl.OpenEJBBundleContextHolder;
import org.apache.openejb.core.osgi.impl.RegisterOSGIServicesExtension;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.ArrayEnumeration;
import org.apache.openejb.util.proxy.ProxyEJB;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployer
implements BundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Deployer.class);
    private static Deployer INSTANCE = null;
    private static final Filter BUNDLE_FILTER = new OSGiPrefixFilter(NewLoaderLogic.getExclusions());
    private final Map<Bundle, List<ServiceRegistration>> registrations = new ConcurrentHashMap<Bundle, List<ServiceRegistration>>();
    private final Map<Bundle, String> paths = new ConcurrentHashMap<Bundle, String>();
    private final Activator openejbActivator;
    private final Map<Bundle, Collection<String>> cdiClasses = new ConcurrentHashMap<Bundle, Collection<String>>();
    private final Map<Bundle, Collection<String>> cdiExtensions = new ConcurrentHashMap<Bundle, Collection<String>>();

    public Deployer(Activator activator) {
        this.openejbActivator = activator;
        INSTANCE = this;
    }

    public static Deployer instance() {
        return INSTANCE;
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                BundleContext context = event.getBundle().getBundleContext();
                if (context == null) break;
                this.deploy(event.getBundle());
                break;
            }
            case 4: 
            case 16: {
                this.undeploy(event.getBundle());
                break;
            }
            case 8: {
                try {
                    this.undeploy(event.getBundle());
                }
                catch (NullPointerException npe) {
                    LOGGER.warn("can't undeploy bundle #{}", (Object)event.getBundle().getBundleId());
                }
                this.deploy(event.getBundle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy(Bundle bundle) {
        File bundleDump;
        OSGIClassLoader osgiCl;
        ClassLoader oldCl;
        block14: {
            if (bundle.getBundleContext() == null || bundle.getLocation() != null && !BUNDLE_FILTER.accept(bundle.getLocation())) {
                return;
            }
            LinkedHashSet wiredBundles = BundleUtils.getWiredBundles((Bundle)bundle);
            for (Bundle b : wiredBundles) {
                Collection<String> extensions;
                String location = b.getLocation();
                if (location == null || !BUNDLE_FILTER.accept(location)) continue;
                Collection<String> classes = this.cdiClasses.get(b);
                if (classes != null) {
                    Collection<String> list = CdiScanner.ADDITIONAL_CLASSES.get();
                    if (list == null) {
                        list = new ArrayList<String>();
                        CdiScanner.ADDITIONAL_CLASSES.set(list);
                    }
                    list.addAll(classes);
                }
                if ((extensions = this.cdiExtensions.get(b)) == null) continue;
                Collection<String> list = OptimizedLoaderService.ADDITIONAL_EXTENSIONS.get();
                if (list == null) {
                    list = new ArrayList<String>();
                    OptimizedLoaderService.ADDITIONAL_EXTENSIONS.set(list);
                }
                list.addAll(extensions);
            }
            oldCl = Thread.currentThread().getContextClassLoader();
            osgiCl = new OSGIClassLoader(bundle, OpenEJBBundleContextHolder.get().getBundle());
            Thread.currentThread().setContextClassLoader(osgiCl);
            this.openejbActivator.checkServiceManager(OpenEJBBundleContextHolder.get());
            bundleDump = Deployer.findBundleFile(bundle);
            if (bundleDump != null && bundleDump.exists()) break block14;
            LOGGER.warn("can't find bundle {}", (Object)bundle.getBundleId());
            RegisterOSGIServicesExtension.current = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            return;
        }
        try {
            try {
                try {
                    LOGGER.info("looking bundle {} in {}", (Object)bundle.getBundleId(), (Object)bundleDump);
                    AppModule appModule = new DeploymentLoader().load(bundleDump);
                    LOGGER.info("deploying bundle #" + bundle.getBundleId() + " as an EJBModule");
                    ConfigurationFactory configurationFactory = new ConfigurationFactory();
                    AppInfo appInfo = configurationFactory.configureApplication(appModule);
                    appInfo.appId = "bundle_" + bundle.getBundleId();
                    RegisterOSGIServicesExtension.current = bundle;
                    Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
                    AppContext appContext = assembler.createApplication(appInfo, (ClassLoader)osgiCl);
                    LOGGER.info("Application deployed: " + appInfo.path);
                    this.paths.put(bundle, appInfo.path);
                    this.registrations.put(bundle, new ArrayList());
                    this.registerService(bundle, appContext);
                    this.saveCDIClasses(bundle, appInfo);
                    this.saveCDIExtension(bundle, appContext);
                }
                catch (UnknownModuleTypeException unknowException) {
                    LOGGER.info("bundle #" + bundle.getBundleId() + " is not an EJBModule");
                }
                catch (Exception ex) {
                    LOGGER.error("can't deploy bundle #" + bundle.getBundleId(), (Throwable)ex);
                }
            }
            catch (Exception ex1) {
                LOGGER.error("can't deploy bundle #" + bundle.getBundleId(), (Throwable)ex1);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            RegisterOSGIServicesExtension.current = null;
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    private void saveCDIExtension(Bundle bundle, AppContext appContext) {
        WebBeansContext context = appContext.getWebBeansContext();
        ExtensionLoader extensionLoader = context.getExtensionLoader();
        Set extensions = (Set)Reflections.get(extensionLoader, "extensionClasses");
        HashSet<String> names = new HashSet<String>();
        for (Class extension : extensions) {
            names.add(extension.getName());
        }
        names.remove(RegisterOSGIServicesExtension.class.getName());
        this.cdiExtensions.put(bundle, names);
    }

    private void saveCDIClasses(Bundle bundle, AppInfo app) {
        for (EjbJarInfo module : app.ejbJars) {
            BeansInfo beans = module.beans;
            if (beans == null) continue;
            this.storeCDIClasses(bundle, beans.managedClasses);
        }
    }

    private void storeCDIClasses(Bundle bundle, Collection<String> names) {
        Collection<String> list = this.cdiClasses.get(bundle);
        if (list == null) {
            list = new ArrayList<String>();
            this.cdiClasses.put(bundle, list);
        }
        list.addAll(names);
    }

    private static File findBundleFile(Bundle bundle) {
        File bundleDump = bundle.getBundleContext().getDataFile(bundle.getSymbolicName() + "/" + bundle.getVersion() + "/");
        if (!bundleDump.exists() && bundle.getBundleContext().getDataFile("") != null) {
            bundleDump = Deployer.findFelixJar(bundle.getBundleContext());
        }
        if (bundleDump == null || !bundleDump.exists()) {
            bundleDump = Deployer.findEquinoxJar(bundle.getBundleContext());
        }
        return bundleDump;
    }

    private static File findEquinoxJar(BundleContext bundleContext) {
        File out;
        File root = bundleContext.getDataFile("").getParentFile();
        int idx = 0;
        File f = null;
        do {
            out = f;
        } while ((f = new File(root, ++idx + "/bundlefile")).exists());
        return out;
    }

    private static File findFelixJar(BundleContext bundleContext) {
        File out;
        File root = bundleContext.getDataFile("").getParentFile();
        int min = 0;
        int max = 0;
        File f = null;
        File[] files = root.listFiles();
        if (files == null) {
            return null;
        }
        for (File current : files) {
            String v;
            if (!current.getName().startsWith("version") || !(v = current.getName().substring("version".length())).contains(".")) continue;
            int idx = v.indexOf(46);
            int cMin = Integer.parseInt(v.substring(0, idx));
            int cMax = Integer.parseInt(v.substring(idx + 1, v.length()));
            if (cMax <= max && (cMax != max || cMin <= min)) continue;
            f = current;
            min = cMin;
            max = cMax;
        }
        while (true) {
            out = f;
            f = new File(root, "version" + max + "." + min + "/bundle.jar");
            ++min;
            if (f.exists()) continue;
            min = 0;
            f = new File(root, "version" + ++max + "." + min + "/bundle.jar");
            if (!f.exists()) break;
        }
        return out;
    }

    private void undeploy(Bundle bundle) {
        Deployer.clean(bundle, this.cdiClasses);
        Deployer.clean(bundle, this.cdiExtensions);
        if (this.registrations.containsKey(bundle)) {
            for (ServiceRegistration registration : this.registrations.get(bundle)) {
                try {
                    registration.unregister();
                }
                catch (IllegalStateException ise) {}
            }
            this.registrations.remove(bundle);
        }
        if (this.paths.containsKey(bundle)) {
            try {
                Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
                if (assembler != null) {
                    assembler.destroyApplication(this.paths.remove(bundle));
                }
            }
            catch (IllegalStateException ise) {
                LOGGER.error("Can't undeploy bundle #{}", (Object)bundle.getBundleId());
            }
            catch (UndeployException e) {
                LOGGER.error("Can't undeploy bundle #{}", (Object)bundle.getBundleId(), (Object)e);
            }
            catch (NoSuchApplicationException e) {
                LOGGER.error("Can't undeploy non existing bundle #{}", (Object)bundle.getBundleId(), (Object)e);
            }
        }
        LOGGER.info("[Deployer] Bundle {} has been stopped", (Object)bundle.getSymbolicName());
    }

    private static void clean(Bundle bundle, Map<Bundle, Collection<String>> lists) {
        Collection<String> list = lists.remove(bundle);
        if (list != null) {
            list.clear();
        }
    }

    private void registerService(Bundle bundle, AppContext appContext) {
        LOGGER.info("Registering remote EJBs as OSGi services");
        BundleContext context = bundle.getBundleContext();
        for (BeanContext beanContext : appContext.getBeanContexts()) {
            if (beanContext.getBeanClass().equals(BeanContext.Comp.class) || BeanType.STATEFUL.equals((Object)beanContext.getComponentType())) continue;
            try {
                if (beanContext.getBusinessRemoteInterface() != null) {
                    LOGGER.info("registering remote bean: {}", (Object)beanContext.getEjbName());
                    this.registerService(beanContext, context, beanContext.getBusinessRemoteInterfaces());
                }
                if (beanContext.getBusinessLocalInterface() != null) {
                    LOGGER.info("registering local bean: {}", (Object)beanContext.getEjbName());
                    this.registerService(beanContext, context, beanContext.getBusinessLocalInterfaces());
                }
                if (!beanContext.isLocalbean()) continue;
                LOGGER.info("registering local view bean: {}", (Object)beanContext.getEjbName());
                this.registerService(beanContext, context, Arrays.asList(beanContext.getBusinessLocalBeanInterface()));
            }
            catch (Exception e) {
                LOGGER.error("[Deployer] can't register: {}", (Object)beanContext.getEjbName());
            }
        }
    }

    private void registerService(BeanContext beanContext, BundleContext context, List<Class> rawItf) {
        if (!rawItf.isEmpty()) {
            ArrayList<Class> interfaces = new ArrayList<Class>(rawItf);
            if (interfaces.contains(IntraVmProxy.class)) {
                interfaces.remove(IntraVmProxy.class);
            }
            Class[] itfs = interfaces.toArray(new Class[interfaces.size()]);
            try {
                Object service = ProxyEJB.simpleProxy(beanContext, itfs);
                this.registrations.get(context.getBundle()).add(context.registerService(Deployer.str(itfs), service, (Dictionary)new Properties()));
                LOGGER.info("EJB registered: {} for interfaces {}", (Object)beanContext.getEjbName(), interfaces);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.error("can't register: {} for interfaces {}", (Object)beanContext.getEjbName(), interfaces);
            }
        }
    }

    public Set<Bundle> deployedBundles() {
        return this.paths.keySet();
    }

    private static String[] str(Class<?>[] itfs) {
        String[] itfsStr = new String[itfs.length];
        for (int i = 0; i < itfs.length; ++i) {
            itfsStr[i] = itfs[i].getName();
        }
        return itfsStr;
    }

    private static class OSGiPrefixFilter
    implements Filter {
        private final String[] exclusions;

        public OSGiPrefixFilter(String[] exclusions) {
            this.exclusions = new String[exclusions.length];
            for (int i = 0; i < exclusions.length; ++i) {
                this.exclusions[i] = exclusions[i].endsWith("-") ? exclusions[i].substring(0, exclusions[i].length() - 1) : exclusions[i];
            }
        }

        public boolean accept(String s) {
            for (String e : this.exclusions) {
                if (!s.contains(e)) continue;
                return false;
            }
            return !s.contains("org.apache.geronimo.specs") && !s.contains("org.apache.felix.framework") && !s.equals("System Bundle") && !s.startsWith("mvn:javax.") && !s.contains("org.apache.bval") && !s.contains("org.apache.aries") && !s.contains("org.apache.karaf");
        }
    }

    public class OSGiDeploymentLoader
    extends DeploymentLoader {
        private final Bundle bundle;

        public OSGiDeploymentLoader(Bundle bdl) {
            this.bundle = bdl;
        }

        @Override
        protected ClassLoader getOpenEJBClassLoader() {
            return new OSGIClassLoader(this.bundle, OpenEJBBundleContextHolder.get().getBundle());
        }
    }

    private static class OSGIClassLoader
    extends ClassLoader {
        private final Bundle backingBundle;
        private final Bundle fallbackBundle;

        public OSGIClassLoader(Bundle bundle, Bundle openejbClassloader) {
            super(null);
            this.backingBundle = bundle;
            this.fallbackBundle = openejbClassloader;
        }

        public boolean equals(Object other) {
            return this == other || this.backingBundle.equals(other);
        }

        @Override
        protected URL findResource(String name) {
            URL url = this.fallbackBundle.getResource(name);
            if (url != null) {
                return url;
            }
            url = this.backingBundle.getResource(name);
            if (url != null) {
                return url;
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.findResources(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            Enumeration burls;
            HashSet urls = new HashSet();
            try {
                Enumeration furls = this.fallbackBundle.getResources(name);
                if (furls != null) {
                    while (furls.hasMoreElements()) {
                        urls.add(furls.nextElement());
                    }
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if ((burls = this.backingBundle.getResources(name)) != null) {
                while (burls.hasMoreElements()) {
                    urls.add(burls.nextElement());
                }
            }
            return new ArrayEnumeration(urls);
        }

        @Override
        public URL getResource(String name) {
            return this.findResource(name);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return this.fallbackBundle.loadClass(name);
            }
            catch (Exception ignored) {
                try {
                    return this.backingBundle.loadClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ClassNotFoundException(name + " not found from bundle [" + this.backingBundle.getSymbolicName() + "]", cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    NoClassDefFoundError e = new NoClassDefFoundError(name + " not found from bundle [" + this.backingBundle + "]");
                    e.initCause(ncdfe);
                    throw e;
                }
            }
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.findClass(name);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return this.findClass(name);
        }

        public String toString() {
            return "OSGIClassLoader for [" + this.backingBundle + "]";
        }
    }
}

