/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.osgi.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterOSGIServicesExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterOSGIServicesExtension.class);
    protected static Bundle current = null;

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd) {
        if (current != null) {
            for (Bundle b : current.getBundleContext().getBundles()) {
                ServiceReference[] services = b.getRegisteredServices();
                if (services == null) continue;
                block4: for (ServiceReference service : services) {
                    String[] clazz = (String[])service.getProperty("objectClass");
                    if (clazz == null) continue;
                    for (String name : clazz) {
                        try {
                            current.loadClass(name);
                            abd.addBean(new OSGiServiceBean(service));
                            LOGGER.debug("added service {} as a CDI Application scoped bean", (Object)name);
                            continue block4;
                        }
                        catch (NoClassDefFoundError ignored) {
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private static Class<?> serviceClass(ServiceReference service) {
        Object instance;
        Bundle bundle = service.getBundle();
        if (bundle == null) {
            return null;
        }
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            return null;
        }
        try {
            instance = bundleContext.getService(service);
        }
        catch (RuntimeException re) {
            return null;
        }
        if (instance == null) {
            return null;
        }
        return instance.getClass();
    }

    public static class OSGiServiceBean<T>
    implements Bean<T> {
        private static final Set<Annotation> QUALIFIERS;
        private final ServiceReference service;
        private final Class<?> clazz;
        private final Set<Type> types = new HashSet<Type>();

        public OSGiServiceBean(ServiceReference srv) {
            this.service = srv;
            this.clazz = RegisterOSGIServicesExtension.serviceClass(this.service);
            for (String clazz : (String[])this.service.getProperty("objectClass")) {
                try {
                    this.types.add(this.service.getBundle().loadClass(clazz));
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
        }

        public T create(CreationalContext<T> ctx) {
            return (T)this.service.getBundle().getBundleContext().getService(this.service);
        }

        public void destroy(T instance, CreationalContext<T> ctx) {
        }

        public Set<Type> getTypes() {
            return this.types;
        }

        public Set<Annotation> getQualifiers() {
            return QUALIFIERS;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public String getName() {
            return "OSGiService_" + this.service.getProperty("service.id");
        }

        public boolean isNullable() {
            return false;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public Class<?> getBeanClass() {
            return this.clazz;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return true;
        }

        static {
            HashSet<Object> qualifiers = new HashSet<Object>();
            qualifiers.add(new DefaultLiteral());
            qualifiers.add(new AnyLiteral());
            QUALIFIERS = Collections.unmodifiableSet(qualifiers);
        }
    }
}

