/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.openjpa;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.openejb.util.JuliLogStream;
import org.apache.openjpa.lib.log.Log;

public class JULOpenJPALog
implements Log {
    private final Logger logger;

    public JULOpenJPALog(String channel) {
        this.logger = Logger.getLogger(channel);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void trace(Object o) {
        this.logger.log(this.record(o, Level.FINEST));
    }

    public void trace(Object o, Throwable t) {
        this.logger.log(this.record(o, t, Level.FINEST));
    }

    public void info(Object o) {
        this.logger.log(this.record(o, Level.INFO));
    }

    public void info(Object o, Throwable t) {
        this.logger.log(this.record(o, t, Level.INFO));
    }

    public void warn(Object o) {
        this.logger.log(this.record(o, Level.WARNING));
    }

    public void warn(Object o, Throwable t) {
        this.logger.log(this.record(o, t, Level.WARNING));
    }

    public void error(Object o) {
        this.logger.log(this.record(o.toString(), Level.SEVERE));
    }

    public void error(Object o, Throwable t) {
        this.logger.log(this.record(o, t, Level.SEVERE));
    }

    public void fatal(Object o) {
        this.logger.log(this.record(o, Level.SEVERE));
    }

    public void fatal(Object o, Throwable t) {
        this.logger.log(this.record(o, t, Level.SEVERE));
    }

    private LogRecord record(Object o, Throwable t, Level level) {
        LogRecord record = this.record(o, level);
        record.setThrown(t);
        return record;
    }

    private LogRecord record(Object o, Level level) {
        JuliLogStream.OpenEJBLogRecord record = new JuliLogStream.OpenEJBLogRecord(level, o.toString());
        ((LogRecord)record).setSourceMethodName(this.logger.getName());
        return record;
    }
}

