/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerFactoryHandler;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.ra.ActiveMQResourceAdapter;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ActiveMQ5Factory
implements BrokerFactoryHandler {
    private static Properties properties;
    private static final Map<URI, BrokerService> brokers;
    private static Throwable throwable;
    private static final AtomicBoolean started;

    public static void setThreadProperties(Properties p) {
        properties = p;
    }

    public synchronized BrokerService createBroker(URI brokerURI) throws Exception {
        Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("ActiveMQ5Factory creating broker");
        BrokerService broker = brokers.get(brokerURI);
        if (null == broker || !broker.isStarted()) {
            Properties properties = this.getLowerCaseProperties();
            URI uri = new URI(brokerURI.getRawSchemeSpecificPart());
            broker = BrokerFactory.createBroker((URI)uri);
            brokers.put(brokerURI, broker);
            if (!uri.getScheme().toLowerCase().startsWith("xbean")) {
                Object value = properties.get("datasource");
                if (value instanceof String && value.toString().length() == 0) {
                    value = null;
                }
                if (value != null) {
                    DataSource dataSource;
                    if (value instanceof DataSource) {
                        dataSource = (DataSource)value;
                    } else {
                        String resouceId = (String)value;
                        try {
                            ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
                            Context context = containerSystem.getJNDIContext();
                            Object obj = context.lookup("openejb/Resource/" + resouceId);
                            if (!(obj instanceof DataSource)) {
                                throw new IllegalArgumentException("Resource with id " + resouceId + " is not a DataSource, but is " + obj.getClass().getName());
                            }
                            dataSource = (DataSource)obj;
                        }
                        catch (NamingException e) {
                            throw new IllegalArgumentException("Unknown datasource " + resouceId);
                        }
                    }
                    JDBCPersistenceAdapter persistenceAdapter = new JDBCPersistenceAdapter();
                    if (properties.containsKey("usedatabaselock")) {
                        persistenceAdapter.setUseDatabaseLock(Boolean.parseBoolean(properties.getProperty("usedatabaselock", "true")));
                    }
                    persistenceAdapter.setDataSource(dataSource);
                    broker.setPersistent(true);
                    broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
                } else {
                    MemoryPersistenceAdapter persistenceAdapter = new MemoryPersistenceAdapter();
                    broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
                }
                ActiveMQ5Factory.disableScheduler(broker);
                broker.setUseLoggingForShutdownErrors(Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).isErrorEnabled());
            }
            broker.setUseShutdownHook(false);
            broker.setSystemExitOnShutdown(false);
            broker.setStartAsync(false);
            final BrokerService bs = broker;
            Thread start = new Thread("ActiveMQFactory start and checkpoint"){

                @Override
                public void run() {
                    Thread.currentThread().setContextClassLoader(ActiveMQResourceAdapter.class.getClassLoader());
                    try {
                        if (!bs.isStarted()) {
                            Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("Starting ActiveMQ BrokerService");
                            bs.start();
                        }
                        bs.waitUntilStarted();
                        Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("Starting ActiveMQ checkpoint");
                        bs.getPersistenceAdapter().checkpoint(true);
                        started.set(true);
                    }
                    catch (Throwable t) {
                        throwable = t;
                    }
                }
            };
            int timeout = 30000;
            try {
                timeout = Integer.parseInt(properties.getProperty("startuptimeout", "30000"));
                Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("Using ActiveMQ startup timeout of " + timeout + "ms");
            }
            catch (Throwable e) {
                // empty catch block
            }
            start.setDaemon(true);
            start.start();
            try {
                start.join(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (null != throwable) {
                Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").error("ActiveMQ failed to start broker", throwable);
            } else if (started.get()) {
                Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("ActiveMQ broker started");
            } else {
                Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").warning("ActiveMQ failed to start broker within " + timeout + " seconds - It may be unusable");
            }
        }
        return broker;
    }

    private static void disableScheduler(BrokerService broker) {
        try {
            Class<?> clazz = Class.forName("org.apache.activemq.broker.BrokerService");
            Method method = clazz.getMethod("setSchedulerSupport", Boolean.class);
            method.invoke((Object)broker, Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Properties getLowerCaseProperties() {
        Properties newProperties = new Properties();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    key = ((String)key).toLowerCase();
                }
                newProperties.put(key, entry.getValue());
            }
        }
        return newProperties;
    }

    public Collection<BrokerService> getBrokers() {
        return brokers.values();
    }

    static {
        brokers = new HashMap<URI, BrokerService>();
        throwable = null;
        started = new AtomicBoolean(false);
    }
}

