/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.managed.local;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.resource.jdbc.managed.local.LocalXAResource;

public class ManagedConnection
implements InvocationHandler {
    private static final Map<Transaction, Connection> CONNECTION_BY_TX = new ConcurrentHashMap<Transaction, Connection>();
    private final TransactionManager transactionManager;
    private final LocalXAResource xaResource;
    protected Connection delegate;
    private Transaction currentTransaction;
    private boolean closed;

    public ManagedConnection(Connection connection, TransactionManager txMgr) {
        this.delegate = connection;
        this.transactionManager = txMgr;
        this.closed = false;
        this.xaResource = new LocalXAResource(this.delegate);
    }

    public XAResource getXAResource() throws SQLException {
        return this.xaResource;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mtdName = method.getName();
        if ("toString".equals(mtdName)) {
            return "ManagedConnection{" + this.delegate + "}";
        }
        if ("hashCode".equals(mtdName)) {
            return this.delegate.hashCode();
        }
        if ("equals".equals(mtdName)) {
            return this.delegate.equals(args[0]);
        }
        try {
            int status;
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                return ManagedConnection.invoke(method, this.delegate, args);
            }
            if (this.currentTransaction != null) {
                if (ManagedConnection.isUnderTransaction(this.currentTransaction.getStatus())) {
                    if (this.currentTransaction != transaction) {
                        throw new SQLException("Connection can not be used while enlisted in another transaction");
                    }
                    return this.invokeUnderTransaction(this.delegate, method, args);
                }
                ManagedConnection.close(this.delegate);
            }
            if (ManagedConnection.isUnderTransaction(status = transaction.getStatus())) {
                Connection connection = CONNECTION_BY_TX.get(transaction);
                if (connection != this.delegate) {
                    if (connection != null) {
                        this.delegate.close();
                        this.delegate = connection;
                    } else {
                        CONNECTION_BY_TX.put(transaction, this.delegate);
                        this.currentTransaction = transaction;
                        try {
                            transaction.enlistResource(this.getXAResource());
                        }
                        catch (RollbackException ignored) {
                        }
                        catch (SystemException e) {
                            throw new SQLException("Unable to enlist connection the transaction", e);
                        }
                        transaction.registerSynchronization((Synchronization)new ClosingSynchronization(this.delegate));
                        this.delegate.setAutoCommit(false);
                    }
                }
                return this.invokeUnderTransaction(this.delegate, method, args);
            }
            return ManagedConnection.invoke(method, this.delegate, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private static Object invoke(Method method, Connection delegate, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)delegate, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    private Object invokeUnderTransaction(Connection delegate, Method method, Object[] args) throws Exception {
        String mtdName = method.getName();
        if ("setAutoCommit".equals(mtdName) || "commit".equals(mtdName) || "rollback".equals(mtdName) || "setSavepoint".equals(mtdName) || "setReadOnly".equals(mtdName)) {
            throw ManagedConnection.forbiddenCall(mtdName);
        }
        if ("close".equals(mtdName)) {
            return this.close();
        }
        if ("isClosed".equals(mtdName) && this.closed) {
            return true;
        }
        return method.invoke((Object)delegate, args);
    }

    private Object close() {
        this.closed = true;
        return null;
    }

    private static boolean isUnderTransaction(int status) {
        return status == 0 || status == 1;
    }

    private static SQLException forbiddenCall(String mtdName) {
        return new SQLException("can't call " + mtdName + " when the connection is JtaManaged");
    }

    private static void close(Connection connection) {
        try {
            if (!connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static class ClosingSynchronization
    implements Synchronization {
        private final Connection connection;

        public ClosingSynchronization(Connection delegate) {
            this.connection = delegate;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            ManagedConnection.close(this.connection);
            try {
                Transaction tx = OpenEJB.getTransactionManager().getTransaction();
                CONNECTION_BY_TX.remove(tx);
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }
}

