/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.Properties;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.loader.Zips;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class JarExtractor {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");

    public static File extract(File file, String pathname) throws IOException {
        Properties properties = SystemInstance.get().getProperties();
        String key = "tomee.unpack.dir";
        File unpackDir = file.getParentFile();
        if (properties.containsKey("tomee.unpack.dir")) {
            FileUtils base = SystemInstance.get().getBase();
            unpackDir = base.getDirectory(properties.getProperty("tomee.unpack.dir"), true);
        }
        File docBase = new File(unpackDir, pathname);
        JarExtractor.extract(file, docBase);
        return docBase;
    }

    public static void extract(File file, File destinationDir) throws IOException {
        if (destinationDir.exists()) {
            if (destinationDir.lastModified() > file.lastModified()) {
                return;
            }
            JarExtractor.deleteDir(destinationDir);
        }
        logger.info("Extracting jar: " + file.getAbsolutePath());
        Files.mkdirs((File)destinationDir);
        try {
            Zips.unzip((File)file, (File)destinationDir);
        }
        catch (IOException e) {
            JarExtractor.deleteDir(destinationDir);
            throw e;
        }
        logger.info("Extracted path: " + destinationDir.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyRecursively(File src, File dest) {
        String[] files;
        boolean result = true;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            File fileSrc = new File(src, files[i]);
            File fileDest = new File(dest, files[i]);
            if (fileSrc.isDirectory()) {
                result = JarExtractor.copyRecursively(fileSrc, fileDest);
                continue;
            }
            FileChannel ic = null;
            FileChannel oc = null;
            try {
                ic = new FileInputStream(fileSrc).getChannel();
                oc = new FileOutputStream(fileDest).getChannel();
                ic.transferTo(0L, ic.size(), oc);
            }
            catch (IOException e) {
                try {
                    logger.error("Copy failed: src: " + fileSrc + ", dest: " + fileDest, e);
                    result = false;
                }
                catch (Throwable throwable) {
                    IO.close(ic);
                    IO.close(oc);
                    throw throwable;
                }
                IO.close((Closeable)ic);
                IO.close((Closeable)oc);
                continue;
            }
            IO.close((Closeable)ic);
            IO.close((Closeable)oc);
            continue;
        }
        return result;
    }

    public static boolean delete(File dir) {
        return JarExtractor.deleteDir(dir);
    }

    public static boolean deleteDir(File dir) {
        File[] files;
        if (dir == null) {
            return true;
        }
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                JarExtractor.deleteDir(file);
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File extract(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        FilterOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, n);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
        }
        return file;
    }
}

