/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.openejb.server.cxf.OpenEJBLoginValidator;
import org.apache.openejb.server.cxf.WSSPassThroughInterceptor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ConfigureCxfSecurity {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.CXF, ConfigureCxfSecurity.class);
    private static final Map<QName, Object> DEFAULT_VALIDATOR_MAP = new HashMap<QName, Object>(){
        {
            this.put(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken"), new OpenEJBLoginValidator());
        }
    };

    public static final void setupWSS4JChain(Endpoint endpoint, Properties inProps) {
        Map<String, Object> in = ConfigureCxfSecurity.getPropsFromProperties(inProps, "wss4j.in.");
        Map<String, Object> out = ConfigureCxfSecurity.getPropsFromProperties(inProps, "wss4j.out.");
        if (!in.containsKey("wss4j.validator.map")) {
            in.put("wss4j.validator.map", DEFAULT_VALIDATOR_MAP);
        }
        ConfigureCxfSecurity.setupWSS4JChain(endpoint, in, out);
    }

    public static Map<String, Object> getPropsFromProperties(Properties inProps, String pattern) {
        String validatorPrefix = pattern + "validator";
        String processorPrefix = pattern + "processor";
        HashMap<QName, Object> validatorMap = new HashMap<QName, Object>();
        HashMap<QName, String> processorMap = new HashMap<QName, String>();
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : inProps.entrySet()) {
            SplitInfo infos;
            String key = String.valueOf(entry.getKey()).trim();
            String val = String.valueOf(entry.getValue()).trim();
            if (key.startsWith(validatorPrefix)) {
                infos = new SplitInfo(key, val);
                try {
                    validatorMap.put(infos.qname, ConfigureCxfSecurity.getValidator(infos.value));
                }
                catch (Exception e) {
                    LOGGER.warning("validator not found " + val, (Throwable)e);
                }
            }
            if (key.startsWith(processorPrefix)) {
                infos = new SplitInfo(key, val);
                processorMap.put(infos.qname, infos.value);
                continue;
            }
            if (!key.startsWith(pattern)) continue;
            props.put(key.substring(pattern.length()), val);
        }
        if (!validatorMap.isEmpty()) {
            props.put("wss4j.validator.map", validatorMap);
        }
        if (!processorMap.isEmpty()) {
            props.put("wss4j.processor.map", processorMap);
        }
        return props;
    }

    private static Object getValidator(String validator) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ConfigureCxfSecurity.class.getClassLoader();
        }
        return cl.loadClass(validator).newInstance();
    }

    public static final void setupWSS4JChain(Endpoint endpoint, Map<String, Object> inProps, Map<String, Object> outProps) {
        if (null != inProps && !inProps.isEmpty()) {
            endpoint.getInInterceptors().add(new SAAJInInterceptor());
            endpoint.getInInterceptors().add(new WSS4JInInterceptor(inProps));
            endpoint.getInInterceptors().add(new WSSPassThroughInterceptor());
        }
        if (null != outProps && !outProps.isEmpty()) {
            endpoint.getOutInterceptors().add(new SAAJOutInterceptor());
            endpoint.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
        }
    }

    public static final void configure(Endpoint endpoint, Properties p) {
        ConfigureCxfSecurity.setupWSS4JChain(endpoint, p);
    }

    private static class SplitInfo {
        public QName qname;
        public String value;

        public SplitInfo(String key, String val) {
            String k = key;
            int startIdx = k.indexOf(123);
            if (startIdx > 0) {
                k = k.substring(startIdx);
            }
            this.value = val;
            int idx = this.value.indexOf("=");
            if (idx > 0) {
                k = k + ':' + this.value.substring(0, idx);
                this.value = this.value.substring(idx + 1);
            }
            k = k.trim();
            this.value = this.value.trim();
            int start = k.indexOf(123);
            int end = k.indexOf(125);
            String ns = k.substring(start + 1, end);
            String local = k.substring(end + 1);
            this.qname = new QName(ns, local);
        }
    }
}

