/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.ejb;

import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerInInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.webservices.JaxWsUtils;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.cxf.ConfigureCxfSecurity;
import org.apache.openejb.server.cxf.CxfEndpoint;
import org.apache.openejb.server.cxf.CxfServiceConfiguration;
import org.apache.openejb.server.cxf.JaxWsImplementorInfoImpl;
import org.apache.openejb.server.cxf.ejb.EjbMethodInvoker;

public class EjbEndpoint
extends CxfEndpoint {
    private final BeanContext beanContext;

    public EjbEndpoint(Bus bus, PortData portData, BeanContext beanContext, HTTPTransportFactory httpTransportFactory, ServiceConfiguration config) {
        super(bus, portData, beanContext.getJndiEnc(), beanContext.getBeanClass(), httpTransportFactory, config);
        this.beanContext = beanContext;
        String bindingURI = JaxWsUtils.getBindingURI((String)portData.getBindingID());
        this.implInfo = new JaxWsImplementorInfoImpl((Class)this.implementor, bindingURI);
        this.serviceFactory = new JaxWsServiceFactoryBean(this.implInfo);
        this.serviceFactory.setBus(bus);
        this.serviceFactory.setServiceClass(beanContext.getBeanClass());
        CxfServiceConfiguration configuration = new CxfServiceConfiguration(portData);
        this.serviceFactory.getConfigurations().add(0, configuration);
        this.service = this.serviceFactory.create();
    }

    @Override
    protected Class getImplementorClass() {
        return (Class)this.implementor;
    }

    @Override
    protected void init() {
        try {
            this.initHandlers();
        }
        catch (Exception e) {
            throw new WebServiceException("Error configuring handlers", (Throwable)e);
        }
        this.service.setInvoker((Invoker)new EjbMethodInvoker(this.bus, this.beanContext));
        Endpoint endpoint = this.getEndpoint();
        EjbEndpoint.removeHandlerInterceptors(this.bus.getInInterceptors());
        EjbEndpoint.removeHandlerInterceptors(endpoint.getInInterceptors());
        EjbEndpoint.removeHandlerInterceptors(endpoint.getBinding().getInInterceptors());
        EjbEndpoint.removeHandlerInterceptors(endpoint.getService().getInInterceptors());
        if (endpoint.getBinding() instanceof SoapBinding && !this.implInfo.isWebServiceProvider()) {
            endpoint.getService().getInInterceptors().add(new SAAJInInterceptor());
        }
        ConfigureCxfSecurity.configure(endpoint, this.port);
    }

    private static void removeHandlerInterceptors(List<? extends Interceptor> interceptors) {
        for (Interceptor interceptor : interceptors) {
            if (!(interceptor instanceof MustUnderstandInterceptor) && !(interceptor instanceof LogicalHandlerInInterceptor) && !(interceptor instanceof SOAPHandlerInterceptor)) continue;
            interceptors.remove(interceptor);
        }
    }

    @Override
    public void stop() {
        this.destroyHandlers();
        super.stop();
    }
}

