/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.pojo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.context.WebServiceContextResourceResolver;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.webservices.JaxWsUtils;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.cxf.CxfEndpoint;
import org.apache.openejb.server.cxf.CxfServiceConfiguration;
import org.apache.openejb.server.cxf.JaxWsImplementorInfoImpl;

public class PojoEndpoint
extends CxfEndpoint {
    private InjectionProcessor<Object> injectionProcessor;

    public PojoEndpoint(ClassLoader loader, Bus bus, PortData port, Context context, Class<?> instance, HTTPTransportFactory httpTransportFactory, Map<String, Object> bindings, ServiceConfiguration config) {
        super(bus, port, context, instance, httpTransportFactory, config);
        String bindingURI = null;
        if (port.getBindingID() != null) {
            bindingURI = JaxWsUtils.getBindingURI((String)port.getBindingID());
        }
        this.implInfo = new JaxWsImplementorInfoImpl(instance, bindingURI);
        this.serviceFactory = PojoEndpoint.configureService(new JaxWsServiceFactoryBean(this.implInfo), config, "cxf.jaxws.");
        this.serviceFactory.setBus(bus);
        this.serviceFactory.setServiceClass(instance);
        CxfServiceConfiguration configuration = new CxfServiceConfiguration(port);
        this.serviceFactory.getConfigurations().add(0, configuration);
        this.service = this.doServiceCreate();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            this.injectionProcessor = new InjectionProcessor(instance, (Collection)port.getInjections(), null, null, InjectionProcessor.unwrap((Context)context), bindings);
            this.injectionProcessor.createInstance();
            this.injectionProcessor.postConstruct();
            this.implementor = this.injectionProcessor.getInstance();
            this.injectCxfResources(this.implementor);
        }
        catch (Exception e) {
            throw new WebServiceException("Service resource injection failed", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        this.service.setInvoker((Invoker)new JAXWSMethodInvoker(this.implementor));
    }

    private void injectCxfResources(Object implementor) {
        ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
        List resolvers = resourceManager.getResourceResolvers();
        resourceManager = new DefaultResourceManager(resolvers);
        resourceManager.addResourceResolver((ResourceResolver)new WebServiceContextResourceResolver());
        ResourceInjector injector = new ResourceInjector(resourceManager);
        injector.inject(implementor);
    }

    @Override
    protected void init() {
        try {
            this.initHandlers();
        }
        catch (Exception e) {
            throw new WebServiceException("Error configuring handlers", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.destroyHandlers();
        if (this.injectionProcessor != null) {
            this.injectionProcessor.preDestroy();
        }
        super.stop();
    }
}

