/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.handler.PortInfoImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.assembler.classic.util.ServiceInfos;
import org.apache.openejb.core.webservices.HandlerResolverImpl;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;

public abstract class CxfEndpoint {
    public static final String CXF_JAXWS_PREFIX = "cxf.jaxws.";
    protected static final Logger FACTORY_BEAN_LOG = LogUtils.getLogger(ReflectionServiceFactoryBean.class);
    private static final Logger SERVER_IMPL_LOGGER = LogUtils.getL7dLogger(ServerImpl.class);
    protected Bus bus;
    protected PortData port;
    protected Context context;
    protected Object implementor;
    protected Server server;
    protected Service service;
    protected JaxWsImplementorInfo implInfo;
    protected JaxWsServiceFactoryBean serviceFactory;
    protected HandlerResolverImpl handlerResolver;
    protected HTTPTransportFactory httpTransportFactory;
    protected ServiceConfiguration serviceConfiguration;

    public CxfEndpoint(Bus bus, PortData port, Context context, Object implementor, HTTPTransportFactory httpTransportFactory, ServiceConfiguration configuration) {
        this.bus = bus;
        this.port = port;
        this.context = context;
        this.implementor = implementor;
        this.httpTransportFactory = httpTransportFactory;
        this.serviceConfiguration = configuration;
        this.bus.setExtension((Object)this, CxfEndpoint.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Service doServiceCreate() {
        Level level = FACTORY_BEAN_LOG.getLevel();
        try {
            FACTORY_BEAN_LOG.setLevel(Level.SEVERE);
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.service = this.serviceFactory.create();
        }
        finally {
            try {
                FACTORY_BEAN_LOG.setLevel(level);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return this.service;
    }

    protected Class getImplementorClass() {
        return this.implementor.getClass();
    }

    protected Endpoint getEndpoint() {
        return this.getServer().getEndpoint();
    }

    public boolean isSOAP11() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http".equals(this.implInfo.getBindingType()) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(this.implInfo.getBindingType());
    }

    public boolean isHTTP() {
        return "http://www.w3.org/2004/08/wsdl/http".equals(this.implInfo.getBindingType());
    }

    public ServerImpl getServer() {
        return (ServerImpl)this.server;
    }

    public Binding getBinding() {
        return ((JaxWsEndpointImpl)this.getEndpoint()).getJaxwsBinding();
    }

    public void setExecutor(Executor executor) {
        this.service.setExecutor(executor);
    }

    public Executor getExecutor() {
        return this.service.getExecutor();
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public List<Source> getMetadata() {
        return null;
    }

    public Map<String, Object> getProperties() {
        return null;
    }

    public boolean isPublished() {
        return this.server != null;
    }

    public void publish(Object arg0) {
    }

    public void publish(String address) {
        this.doPublish(address);
    }

    public void setMetadata(List<Source> arg0) {
    }

    public void setProperties(Map<String, Object> arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPublish(String address) {
        NoInitJaxWsServerFactoryBean svrFactory = new NoInitJaxWsServerFactoryBean();
        svrFactory.setBus(this.bus);
        svrFactory.setAddress(address);
        svrFactory.setServiceFactory((ReflectionServiceFactoryBean)this.serviceFactory);
        svrFactory.setStart(false);
        svrFactory.setServiceBean(this.implementor);
        svrFactory.setDestinationFactory((DestinationFactory)this.httpTransportFactory);
        svrFactory.setServiceClass(this.serviceFactory.getServiceClass());
        Properties beanConfig = this.serviceConfiguration.getProperties();
        if (beanConfig != null) {
            String wsdlLocation;
            String schemaLocations = beanConfig.getProperty("cxf.jaxws.schema-locations");
            if (schemaLocations != null) {
                svrFactory.setSchemaLocations(Arrays.asList(schemaLocations.split(",")));
            }
            if ((wsdlLocation = beanConfig.getProperty("cxf.jaxws.wsdl-location")) != null) {
                svrFactory.setWsdlLocation(wsdlLocation);
            }
        }
        CxfUtil.configureEndpoint((AbstractEndpointFactory)svrFactory, (ServiceConfiguration)this.serviceConfiguration, (String)CXF_JAXWS_PREFIX);
        if ("http://www.w3.org/2004/08/wsdl/http".equals(this.implInfo.getBindingType())) {
            svrFactory.setTransportId("http://cxf.apache.org/bindings/xformat");
        }
        Level level = SERVER_IMPL_LOGGER.getLevel();
        try {
            SERVER_IMPL_LOGGER.setLevel(Level.SEVERE);
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.server = svrFactory.create();
        }
        finally {
            try {
                SERVER_IMPL_LOGGER.setLevel(level);
            }
            catch (UnsupportedOperationException uoe) {}
        }
        this.init();
        if (this.getBinding() instanceof SOAPBinding) {
            ((SOAPBinding)this.getBinding()).setMTOMEnabled(this.port.isMtomEnabled());
        }
        this.server.start();
    }

    protected void init() {
    }

    protected void initHandlers() throws Exception {
        PortInfoImpl portInfo = new PortInfoImpl(this.implInfo.getBindingType(), this.serviceFactory.getEndpointName(), this.service.getName());
        this.handlerResolver = new HandlerResolverImpl(this.port.getHandlerChains(), (Collection)this.port.getInjections(), this.context);
        List chain = this.handlerResolver.getHandlerChain((PortInfo)portInfo);
        this.getBinding().setHandlerChain(chain);
    }

    protected void destroyHandlers() {
        if (this.handlerResolver != null) {
            this.handlerResolver.destroyHandlers();
            this.handlerResolver = null;
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    protected static JaxWsServiceFactoryBean configureService(JaxWsServiceFactoryBean serviceFactory, ServiceConfiguration configuration, String prefix) {
        List instances;
        String wsFeatures;
        Properties beanConfig = configuration.getProperties();
        if (beanConfig == null || beanConfig.isEmpty()) {
            return serviceFactory;
        }
        Collection availableServices = configuration.getAvailableServices();
        String databinding = beanConfig.getProperty(prefix + "databinding");
        if (databinding != null && !databinding.trim().isEmpty()) {
            Object instance = ServiceInfos.resolve((Collection)availableServices, (String)databinding);
            if (instance == null) {
                try {
                    instance = Thread.currentThread().getContextClassLoader().loadClass(databinding).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!DataBinding.class.isInstance(instance)) {
                throw new OpenEJBRuntimeException(instance + " is not a " + DataBinding.class.getName() + ", please check configuration of service [id=" + databinding + "]");
            }
            serviceFactory.setDataBinding((DataBinding)instance);
        }
        if ((wsFeatures = beanConfig.getProperty(prefix + "wsFeatures")) != null && (instances = ServiceInfos.resolve((Collection)availableServices, (String[])wsFeatures.split(" *, *"))) != null && !instances.isEmpty()) {
            ArrayList features = new ArrayList(instances.size());
            for (Object i : instances) {
                if (!WebServiceFeature.class.isInstance(i)) {
                    throw new IllegalArgumentException("Not a WebServiceFeature: " + i);
                }
                features.add(WebServiceFeature.class.cast(i));
            }
            serviceFactory.setWsFeatures(features);
        }
        return serviceFactory;
    }

    private class NoInitJaxWsServerFactoryBean
    extends JaxWsServerFactoryBean {
        public NoInitJaxWsServerFactoryBean() {
            this.doInit = false;
        }
    }
}

