/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;

public class OpenEJBRuntimeDelegateImpl
extends RuntimeDelegateImpl {
    public UriBuilder createUriBuilder() {
        return new OpenEJBUriBuilderImpl();
    }

    private static class OpenEJBUriBuilderImpl
    extends UriBuilderImpl {
        private static final String[][] PREFIX = new String[][]{{"http:/", "http://"}, {"https:/", "https://"}};
        private boolean init = false;

        private OpenEJBUriBuilderImpl() {
        }

        public UriBuilder replacePath(String value) {
            if (value == null && !this.init) {
                throw new IllegalArgumentException("value is null");
            }
            this.init = true;
            return super.replacePath(value);
        }

        public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
            return this.getFixedUri(super.build(values).toString());
        }

        private URI getFixedUri(String s) throws UriBuilderException {
            String uri = s;
            for (String[] prefix : PREFIX) {
                if (!uri.startsWith(prefix[0]) || uri.startsWith(prefix[1])) continue;
                uri = uri.replaceFirst(prefix[0], prefix[1]);
                break;
            }
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new UriBuilderException((Throwable)e);
            }
        }

        public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
            return this.getFixedUri(super.buildFromEncoded(values).toString());
        }

        public URI buildFromEncodedMap(Map<String, ?> map) throws IllegalArgumentException, UriBuilderException {
            return this.getFixedUri(super.buildFromEncodedMap(map).toString());
        }

        public URI buildFromMap(Map<String, ?> map) throws IllegalArgumentException, UriBuilderException {
            return this.getFixedUri(super.buildFromMap(map).toString());
        }
    }
}

