/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.transport.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.bus.CXFBusImpl;
import org.apache.cxf.bus.managers.BindingFactoryManagerImpl;
import org.apache.cxf.configuration.spring.MapProvider;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.assembler.classic.util.ServiceInfos;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.cxf.transport.util.CxfContainerClassLoader;
import org.apache.openejb.util.PropertiesHelper;

public final class CxfUtil {
    public static final String ENDPOINT_PROPERTIES = "properties";
    public static final String FEATURES = "features";
    public static final String IN_INTERCEPTORS = "in-interceptors";
    public static final String IN_FAULT_INTERCEPTORS = "in-fault-interceptors";
    public static final String OUT_INTERCEPTORS = "out-interceptors";
    public static final String OUT_FAULT_INTERCEPTORS = "out-fault-interceptors";
    public static final String DATABINDING = "databinding";
    public static final String ADDRESS = "address";
    public static final String DEBUG = "debug";
    public static final String BUS_PREFIX = "org.apache.openejb.cxf.bus.";
    public static final String BUS_CONFIGURED_FLAG = "openejb.cxf.bus.configured";
    private static final Map<String, BindingFactory> bindingFactoryMap = new ConcurrentHashMap<String, BindingFactory>(8, 0.75f, 4);
    private static final Bus DEFAULT_BUS = CxfUtil.initDefaultBus();
    private static volatile boolean usingBindingFactoryMap = false;

    private CxfUtil() {
    }

    public static boolean hasService(String name) {
        return usingBindingFactoryMap && bindingFactoryMap.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bus initDefaultBus() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.class.getClassLoader());
        try {
            Bus bus = BusFactory.newInstance((String)CXFBusFactory.class.getName()).createBus();
            BindingFactoryManager bfm = (BindingFactoryManager)bus.getExtension(BindingFactoryManager.class);
            if (BindingFactoryManagerImpl.class.isInstance(bfm) && !usingBindingFactoryMap) {
                ((BindingFactoryManagerImpl)BindingFactoryManagerImpl.class.cast(bfm)).setMapProvider((MapProvider)new MapProvider<String, BindingFactory>(){

                    public Map<String, BindingFactory> createMap() {
                        usingBindingFactoryMap = true;
                        return bindingFactoryMap;
                    }
                });
            }
            CXFBusFactory.setDefaultBus((Bus)((Bus)Bus.class.cast(Proxy.newProxyInstance(CxfUtil.class.getClassLoader(), new Class[]{Bus.class}, (InvocationHandler)new ClientAwareBusHandler()))));
            Bus bus2 = bus;
            return bus2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static Bus getBus() {
        return DEFAULT_BUS;
    }

    @Deprecated
    public static Bus getDefaultBus() {
        return CxfUtil.getBus();
    }

    public static ClassLoader initBusLoader() {
        ClassLoader loader = (ClassLoader)CxfUtil.getBus().getExtension(ClassLoader.class);
        if (loader != null) {
            if (CxfContainerClassLoader.class.isInstance(loader)) {
                ((CxfContainerClassLoader)CxfContainerClassLoader.class.cast(loader)).tccl(Thread.currentThread().getContextClassLoader());
            }
            return loader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static void clearBusLoader(ClassLoader old) {
        ClassLoader loader = (ClassLoader)CxfUtil.getBus().getExtension(ClassLoader.class);
        if (loader != null && CxfContainerClassLoader.class.isInstance(loader) && (old == null || !CxfContainerClassLoader.class.isInstance(old))) {
            ((CxfContainerClassLoader)CxfContainerClassLoader.class.cast(loader)).clear();
        }
        Thread.currentThread().setContextClassLoader(old);
    }

    public static void configureEndpoint(AbstractEndpointFactory svrFactory, ServiceConfiguration configuration, String prefix) {
        String changedAddress;
        String featuresIds;
        String debugKey;
        Properties beanConfig = configuration.getProperties();
        if (beanConfig == null || beanConfig.isEmpty()) {
            return;
        }
        Collection availableServices = configuration.getAvailableServices();
        Properties properties = ServiceInfos.serviceProperties((Collection)availableServices, (String)beanConfig.getProperty(prefix + ENDPOINT_PROPERTIES));
        if (properties != null) {
            svrFactory.setProperties(PropertiesHelper.map((Properties)properties));
        }
        if ("true".equalsIgnoreCase(beanConfig.getProperty(debugKey = prefix + DEBUG, SystemInstance.get().getOptions().get(debugKey, "false")))) {
            svrFactory.getProperties(true).put("faultStackTraceEnabled", "true");
        }
        if ((featuresIds = beanConfig.getProperty(prefix + FEATURES)) != null) {
            List<AbstractFeature> features = CxfUtil.createFeatures(availableServices, featuresIds);
            svrFactory.setFeatures(features);
        }
        CxfUtil.configureInterceptors((AbstractBasicInterceptorProvider)svrFactory, prefix, availableServices, beanConfig);
        String databinding = beanConfig.getProperty(prefix + DATABINDING);
        if (databinding != null && !databinding.trim().isEmpty()) {
            Object instance = ServiceInfos.resolve((Collection)availableServices, (String)databinding);
            if (instance == null) {
                try {
                    instance = Thread.currentThread().getContextClassLoader().loadClass(databinding).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!DataBinding.class.isInstance(instance)) {
                throw new OpenEJBRuntimeException(instance + " is not a " + DataBinding.class.getName() + ", please check configuration of service [id=" + databinding + "]");
            }
            svrFactory.setDataBinding((DataBinding)instance);
        }
        if ((changedAddress = beanConfig.getProperty(prefix + ADDRESS)) != null && !changedAddress.trim().isEmpty()) {
            svrFactory.setAddress(changedAddress);
        }
    }

    public static void configureInterceptors(AbstractBasicInterceptorProvider abip, String prefix, Collection<ServiceInfo> availableServices, Properties beanConfig) {
        String outFaultInterceptorsIds;
        String outInterceptorsIds;
        String inFaultInterceptorsIds;
        String inInterceptorsIds = beanConfig.getProperty(prefix + IN_INTERCEPTORS);
        if (inInterceptorsIds != null && !inInterceptorsIds.trim().isEmpty()) {
            abip.getInInterceptors().addAll(CxfUtil.createInterceptors(availableServices, inInterceptorsIds));
        }
        if ((inFaultInterceptorsIds = beanConfig.getProperty(prefix + IN_FAULT_INTERCEPTORS)) != null && !inFaultInterceptorsIds.trim().isEmpty()) {
            abip.getInFaultInterceptors().addAll(CxfUtil.createInterceptors(availableServices, inFaultInterceptorsIds));
        }
        if ((outInterceptorsIds = beanConfig.getProperty(prefix + OUT_INTERCEPTORS)) != null && !outInterceptorsIds.trim().isEmpty()) {
            abip.getOutInterceptors().addAll(CxfUtil.createInterceptors(availableServices, outInterceptorsIds));
        }
        if ((outFaultInterceptorsIds = beanConfig.getProperty(prefix + OUT_FAULT_INTERCEPTORS)) != null && !outFaultInterceptorsIds.trim().isEmpty()) {
            abip.getOutFaultInterceptors().addAll(CxfUtil.createInterceptors(availableServices, outFaultInterceptorsIds));
        }
    }

    public static List<AbstractFeature> createFeatures(Collection<ServiceInfo> availableServices, String featuresIds) {
        List features = ServiceInfos.resolve(availableServices, (String[])featuresIds.split(","));
        for (Object instance : features) {
            if (AbstractFeature.class.isInstance(instance)) continue;
            throw new OpenEJBRuntimeException("feature should inherit from " + AbstractFeature.class.getName());
        }
        return features;
    }

    public static List<Interceptor<? extends Message>> createInterceptors(Collection<ServiceInfo> availableServices, String ids) {
        List instances = ServiceInfos.resolve(availableServices, (String[])ids.split(","));
        for (Object instance : instances) {
            if (Interceptor.class.isInstance(instance)) continue;
            throw new OpenEJBRuntimeException("interceptors should implement " + Interceptor.class.getName());
        }
        return instances;
    }

    public static void configureBus() {
        if (SystemInstance.get().getProperties().containsKey(BUS_CONFIGURED_FLAG)) {
            return;
        }
        Bus bus = CxfUtil.getBus();
        bus.setExtension((Object)new CxfContainerClassLoader(), ClassLoader.class);
        if (bus instanceof CXFBusImpl) {
            Properties busProperties;
            List<AbstractFeature> features;
            ServiceConfiguration configuration = new ServiceConfiguration(SystemInstance.get().getProperties(), (Collection)((OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class)).facilities.services);
            CXFBusImpl busImpl = (CXFBusImpl)bus;
            Collection serviceInfos = configuration.getAvailableServices();
            Properties properties = configuration.getProperties();
            if (properties == null || properties.isEmpty()) {
                return;
            }
            String featuresIds = properties.getProperty("org.apache.openejb.cxf.bus.features");
            if (featuresIds != null && (features = CxfUtil.createFeatures(serviceInfos, featuresIds)) != null) {
                features.addAll(busImpl.getFeatures());
                busImpl.setFeatures(features);
            }
            if ((busProperties = ServiceInfos.serviceProperties((Collection)serviceInfos, (String)properties.getProperty("org.apache.openejb.cxf.bus.properties"))) != null) {
                busImpl.getProperties().putAll(PropertiesHelper.map((Properties)busProperties));
            }
            CxfUtil.configureInterceptors((AbstractBasicInterceptorProvider)busImpl, BUS_PREFIX, serviceInfos, configuration.getProperties());
            SystemInstance.get().getProperties().setProperty(BUS_CONFIGURED_FLAG, "true");
        }
    }

    private static class ClientAwareBusHandler
    implements InvocationHandler {
        private ClientAwareBusHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Bus bus = CxfUtil.getBus();
            if ("getExtension".equals(method.getName()) && args != null && args.length == 1 && ClassLoader.class.equals(args[0])) {
                ClassLoader extensionLoader = (ClassLoader)ClassLoader.class.cast(method.invoke((Object)bus, args));
                if (CxfContainerClassLoader.class.isInstance(extensionLoader) && !((CxfContainerClassLoader)CxfContainerClassLoader.class.cast(extensionLoader)).hasTccl()) {
                    return null;
                }
                return extensionLoader;
            }
            return method.invoke((Object)bus, args);
        }
    }
}

