/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.daemon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.cli.Bootstrap;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.Server;

public class NTService {
    private static final NTService instance = new NTService();
    private final AtomicBoolean running = new AtomicBoolean(false);

    public static void start(String[] args) {
        try {
            instance.startImpl(args);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }

    public static void stop(String[] args) {
        try {
            instance.stopImpl();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }

    private NTService() {
    }

    private void startImpl(String[] args) {
        if (!this.running.getAndSet(true)) {
            if (null == args) {
                args = new String[]{};
            }
            if (null == System.getProperty("openejb.home")) {
                System.setProperty("openejb.home", System.getProperty("user.dir"));
            }
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(Arrays.asList(args));
            if (!list.contains("start")) {
                list.add("start");
            }
            try {
                System.out.println("Starting NTService: " + list);
                Bootstrap.main((String[])list.toArray(new String[list.size()]));
                this.running.set(false);
            }
            catch (Exception e) {
                this.running.set(false);
                throw new RuntimeException("Failed to Bootstrap OpenEJB", e);
            }
        }
    }

    private void stopImpl() {
        Server server;
        if (this.running.getAndSet(false) && null != (server = (Server)SystemInstance.get().getComponent(Server.class))) {
            try {
                System.out.println("Stopping NTService");
                server.stop();
            }
            catch (Exception e) {
                this.running.set(true);
                e.printStackTrace(System.err);
            }
        }
    }
}

