/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EjbObjectInputStream;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.server.ejbd.AuthRequestHandler;
import org.apache.openejb.server.ejbd.ClientObjectFactory;
import org.apache.openejb.server.ejbd.ClusterRequestHandler;
import org.apache.openejb.server.ejbd.EjbRequestHandler;
import org.apache.openejb.server.ejbd.JndiRequestHandler;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;

public class EjbDaemon
implements ApplicationServer {
    private static final ProtocolMetaData PROTOCOL_VERSION = new ProtocolMetaData("3.1");
    private static final Messages _messages = new Messages("org.apache.openejb.server.util.resources");
    static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE, (String)"org.apache.openejb.server.util.resources");
    private ClientObjectFactory clientObjectFactory;
    private EjbRequestHandler ejbHandler;
    private JndiRequestHandler jndiHandler;
    private AuthRequestHandler authHandler;
    private ClusterRequestHandler clusterHandler;
    boolean stop = false;
    static EjbDaemon thiss;
    private ContainerSystem containerSystem;

    private EjbDaemon() {
    }

    public static EjbDaemon getEjbDaemon() {
        if (thiss == null) {
            thiss = new EjbDaemon();
        }
        return thiss;
    }

    public void init(Properties props) throws Exception {
        this.containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.clientObjectFactory = new ClientObjectFactory(this, props);
        this.ejbHandler = new EjbRequestHandler(this);
        this.jndiHandler = new JndiRequestHandler(this);
        this.authHandler = new AuthRequestHandler(this);
        this.clusterHandler = new ClusterRequestHandler(this);
        DiscoveryAgent discovery = (DiscoveryAgent)SystemInstance.get().getComponent(DiscoveryAgent.class);
        if (discovery != null) {
            discovery.setDiscoveryListener((DiscoveryListener)this.clusterHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Socket socket) throws IOException {
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        try {
            this.service(in, out);
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Throwable t) {
                logger.error("Encountered problem while closing connection with client: " + t.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(InputStream in, OutputStream out) throws IOException {
        ObjectOutputStream oos;
        String requestTypeName;
        ProtocolMetaData protocolMetaData;
        block34: {
            block33: {
                protocolMetaData = new ProtocolMetaData();
                requestTypeName = null;
                EjbObjectInputStream ois = null;
                oos = null;
                try {
                    protocolMetaData.readExternal(in);
                    PROTOCOL_VERSION.writeExternal(out);
                    ois = new EjbObjectInputStream(in);
                    oos = new ObjectOutputStream(out);
                    ServerMetaData serverMetaData = new ServerMetaData();
                    serverMetaData.readExternal((ObjectInput)ois);
                    ClientObjectFactory.serverMetaData.set(serverMetaData);
                    byte requestType = (byte)ois.read();
                    if (requestType == -1) {
                        return;
                    }
                    if (requestType == 3) {
                        this.processClusterRequest((ObjectInputStream)ois, oos);
                    }
                    if ((requestType = (byte)ois.read()) == -1) {
                        ClientObjectFactory.serverMetaData.remove();
                        break block33;
                    }
                    switch (requestType) {
                        case 0: {
                            requestTypeName = "EJB_REQUEST";
                            this.processEjbRequest((ObjectInputStream)ois, oos);
                            break;
                        }
                        case 1: {
                            requestTypeName = "JNDI_REQUEST";
                            this.processJndiRequest((ObjectInputStream)ois, oos);
                            break;
                        }
                        case 2: {
                            requestTypeName = "AUTH_REQUEST";
                            this.processAuthRequest((ObjectInputStream)ois, oos);
                            break;
                        }
                        default: {
                            requestTypeName = requestType + " (UNKNOWN)";
                            logger.error("\"" + requestTypeName + " " + protocolMetaData.getSpec() + "\" FAIL \"Unknown request type " + requestType);
                        }
                    }
                    ClientObjectFactory.serverMetaData.remove();
                    break block34;
                }
                catch (SecurityException e) {
                    logger.error("\"" + requestTypeName + " " + protocolMetaData.getSpec() + "\" FAIL \"Security error - " + e.getMessage() + "\"", (Throwable)e);
                    return;
                }
                catch (Throwable e) {
                    logger.error("\"" + requestTypeName + " " + protocolMetaData.getSpec() + "\" FAIL \"Unexpected error - " + e.getMessage() + "\"", e);
                    return;
                }
            }
            try {
                if (oos != null) {
                    oos.flush();
                    oos.close();
                    return;
                }
                if (out == null) return;
                out.flush();
                out.close();
                return;
            }
            catch (Throwable t) {
                logger.error("\"" + requestTypeName + " " + protocolMetaData.getSpec() + "\" FAIL \"" + t.getMessage() + "\"");
            }
            return;
        }
        try {
            if (oos != null) {
                oos.flush();
                oos.close();
                return;
            }
            if (out == null) return;
            out.flush();
            out.close();
            return;
        }
        catch (Throwable t) {
            logger.error("\"" + requestTypeName + " " + protocolMetaData.getSpec() + "\" FAIL \"" + t.getMessage() + "\"");
            return;
        }
        finally {
            block35: {
                ClientObjectFactory.serverMetaData.remove();
                try {
                    if (oos != null) {
                        oos.flush();
                        oos.close();
                        break block35;
                    }
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                }
                catch (Throwable t) {
                    logger.error("\"" + requestTypeName + " " + protocolMetaData.getSpec() + "\" FAIL \"" + t.getMessage() + "\"");
                }
            }
        }
    }

    private void processClusterRequest(ObjectInputStream in, ObjectOutputStream out) throws IOException {
        this.clusterHandler.processRequest(in, out);
    }

    protected DeploymentInfo getDeployment(EJBRequest req) throws RemoteException {
        String deploymentId = req.getDeploymentId();
        DeploymentInfo deploymentInfo = this.containerSystem.getDeploymentInfo((Object)deploymentId);
        if (deploymentInfo == null) {
            throw new RemoteException("No deployment: " + deploymentId);
        }
        return deploymentInfo;
    }

    public void processEjbRequest(ObjectInputStream in, ObjectOutputStream out) {
        this.ejbHandler.processRequest(in, out);
    }

    public void processJndiRequest(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        this.jndiHandler.processRequest(in, out);
    }

    public void processAuthRequest(ObjectInputStream in, ObjectOutputStream out) {
        this.authHandler.processRequest(in, out);
    }

    public EJBMetaData getEJBMetaData(ProxyInfo info) {
        return this.clientObjectFactory.getEJBMetaData(info);
    }

    public Handle getHandle(ProxyInfo info) {
        return this.clientObjectFactory.getHandle(info);
    }

    public HomeHandle getHomeHandle(ProxyInfo info) {
        return this.clientObjectFactory.getHomeHandle(info);
    }

    public EJBObject getEJBObject(ProxyInfo info) {
        return this.clientObjectFactory.getEJBObject(info);
    }

    public Object getBusinessObject(ProxyInfo info) {
        return this.clientObjectFactory.getBusinessObject(info);
    }

    public EJBHome getEJBHome(ProxyInfo info) {
        return this.clientObjectFactory.getEJBHome(info);
    }
}

