/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.util.HashMap;
import org.apache.openejb.BeanContext;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.ServerMetaData;

public class CallContext {
    private static final ThreadLocal threads = new ThreadLocal();
    private final HashMap<Class, Object> data = new HashMap();

    public void reset() {
        this.data.clear();
    }

    public <T> T get(Class<T> type) {
        return (T)this.data.get(type);
    }

    public <T> T set(Class<T> type, T value) {
        return (T)this.data.put(type, value);
    }

    public BeanContext getBeanContext() {
        return this.get(BeanContext.class);
    }

    public void setBeanContext(BeanContext info) {
        this.set(BeanContext.class, info);
    }

    public void setServerMetaData(ServerMetaData serverMetaData) {
        this.set(ServerMetaData.class, serverMetaData);
    }

    public ServerMetaData getServerMetaData() {
        return this.get(ServerMetaData.class);
    }

    public EJBRequest getEJBRequest() {
        return this.get(EJBRequest.class);
    }

    public void setEJBRequest(EJBRequest request) {
        this.set(EJBRequest.class, request);
    }

    public static void setCallContext(CallContext ctx) {
        if (ctx == null) {
            ctx = (CallContext)threads.get();
            if (ctx != null) {
                ctx.reset();
            }
        } else {
            threads.set(ctx);
        }
    }

    public static CallContext getCallContext() {
        CallContext ctx = (CallContext)threads.get();
        if (ctx == null) {
            ctx = new CallContext();
            threads.set(ctx);
        }
        return ctx;
    }
}

