/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.apache.openejb.BeanContext;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.util.Messages;

public class DeploymentIndex {
    Messages messages = new Messages("org.apache.openejb.server.ejbd");
    BeanContext[] deployments = null;
    Map index = null;

    public DeploymentIndex(BeanContext[] beanContexts) {
        BeanContext[] ds = beanContexts;
        this.deployments = new BeanContext[ds.length + 1];
        System.arraycopy(ds, 0, this.deployments, 1, ds.length);
        this.index = new HashMap(this.deployments.length);
        for (int i = 1; i < this.deployments.length; ++i) {
            this.index.put(this.deployments[i].getDeploymentID(), new Integer(i));
        }
    }

    public BeanContext getDeployment(EJBRequest req) throws RemoteException {
        BeanContext info = null;
        int deploymentCode = req.getDeploymentCode();
        if (deploymentCode > 0 && deploymentCode < this.deployments.length) {
            info = this.deployments[deploymentCode];
            req.setDeploymentId((String)info.getDeploymentID());
            return info;
        }
        if (req.getDeploymentId() == null) {
            throw new RemoteException(this.messages.format("invalidDeploymentIdAndCode", new Object[]{req.getDeploymentId(), req.getDeploymentCode()}));
        }
        int idCode = this.getDeploymentIndex(req.getDeploymentId());
        if (idCode == -1) {
            throw new RemoteException(this.messages.format("noSuchDeploymentIdAndCode", new Object[]{req.getDeploymentId(), req.getDeploymentCode()}));
        }
        req.setDeploymentCode(idCode);
        if (req.getDeploymentCode() < 0 || req.getDeploymentCode() >= this.deployments.length) {
            throw new RemoteException(this.messages.format("invalidDeploymentIdAndCode", new Object[]{req.getDeploymentId(), req.getDeploymentCode()}));
        }
        return this.deployments[req.getDeploymentCode()];
    }

    public int getDeploymentIndex(BeanContext deployment) {
        return this.getDeploymentIndex((String)deployment.getDeploymentID());
    }

    public int getDeploymentIndex(String deploymentID) {
        Integer idCode = (Integer)this.index.get(deploymentID);
        return idCode == null ? -1 : idCode;
    }

    public BeanContext getDeployment(String deploymentID) {
        return this.getDeployment(this.getDeploymentIndex(deploymentID));
    }

    public BeanContext getDeployment(Integer index) {
        return index == null ? null : this.getDeployment((int)index);
    }

    public BeanContext getDeployment(int index) {
        return this.deployments[index];
    }
}

