/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import org.apache.openejb.client.FlushableGZIPOutputStream;
import org.apache.openejb.client.KeepAliveStyle;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServicePool;
import org.apache.openejb.server.ejbd.EjbServer;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class KeepAliveServer
implements ServerService {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("keepalive"), KeepAliveServer.class);
    private final ServerService service;
    private final long timeout = 10000L;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ConcurrentHashMap<Thread, Session> sessions = new ConcurrentHashMap();
    private BlockingQueue<Runnable> threadQueue;
    private Timer timer;
    private final boolean gzip;

    public KeepAliveServer() {
        this(new EjbServer());
    }

    @Deprecated
    public KeepAliveServer(ServerService service) {
        this(service, false);
    }

    public KeepAliveServer(ServerService service, boolean gzip) {
        this.service = service;
        this.gzip = gzip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void closeInactiveSessions() {
        if (!this.running.get()) {
            return;
        }
        BlockingQueue<Runnable> queue = this.getQueue();
        if (queue == null) {
            return;
        }
        int backlog = queue.size();
        if (backlog <= 0) {
            return;
        }
        long now = System.currentTimeMillis();
        ArrayList<Session> current = new ArrayList<Session>();
        current.addAll(this.sessions.values());
        for (Session session : current) {
            block12: {
                Lock l = session.usage;
                if (l.tryLock()) {
                    try {
                        if (now - session.lastRequest <= 10000L) break block12;
                        --backlog;
                        try {
                            session.socket.close();
                            this.removeSession(session);
                        }
                        catch (Throwable e) {
                            this.removeSession(session);
                            break block12;
                            catch (Throwable throwable) {
                                this.removeSession(session);
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        l.unlock();
                    }
                }
            }
            if (backlog > 0) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSessions() {
        ArrayList<Session> current = new ArrayList<Session>();
        current.addAll(this.sessions.values());
        for (Session session : current) {
            Lock l = session.usage;
            if (l.tryLock()) {
                try {
                    session.socket.close();
                }
                catch (Throwable e) {}
                continue;
                finally {
                    this.removeSession(session);
                    l.unlock();
                    continue;
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Allowing graceful shutdown of " + session.socket.getInetAddress());
        }
        this.sessions.clear();
    }

    private BlockingQueue<Runnable> getQueue() {
        if (this.threadQueue == null) {
            ServicePool incoming = (ServicePool)SystemInstance.get().getComponent(ServicePool.class);
            if (incoming == null) {
                return null;
            }
            ThreadPoolExecutor threadPool = incoming.getThreadPool();
            this.threadQueue = threadPool.getQueue();
        }
        return this.threadQueue;
    }

    public Session addSession(Session session) {
        return this.sessions.put(session.thread, session);
    }

    public Session removeSession(Session session) {
        return this.sessions.remove(session.thread);
    }

    public void service(Socket socket) throws ServiceException, IOException {
        Session session = new Session(this, socket);
        session.service(socket);
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    public String getIP() {
        return this.service.getIP();
    }

    public String getName() {
        return this.service.getName();
    }

    public int getPort() {
        return this.service.getPort();
    }

    public void start() throws ServiceException {
        if (!this.running.getAndSet(true)) {
            this.timer = new Timer("KeepAliveTimer", true);
            this.timer.scheduleAtFixedRate((TimerTask)new KeepAliveTimer(this), this.timeout, this.timeout / 2L);
        }
    }

    public void stop() throws ServiceException {
        if (this.running.getAndSet(false)) {
            try {
                this.closeSessions();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.timer.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void init(Properties props) throws Exception {
        this.service.init(props);
    }

    public class Output
    extends FilterOutputStream {
        public Output(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }

    public class Input
    extends FilterInputStream {
        public Input(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class Session {
        private final Thread thread;
        private final KeepAliveServer kas;
        private final Lock usage = new ReentrantLock();
        private long lastRequest;
        private final Socket socket;

        protected Session(KeepAliveServer kas, Socket socket) {
            this.kas = kas;
            this.socket = socket;
            this.lastRequest = System.currentTimeMillis();
            this.thread = Thread.currentThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void service(Socket socket) throws ServiceException, IOException {
            this.kas.addSession(this);
            int i = -1;
            try {
                BufferedOutputStream out;
                FilterInputStream in;
                if (!KeepAliveServer.this.gzip) {
                    in = new BufferedInputStream(socket.getInputStream());
                    out = new BufferedOutputStream(socket.getOutputStream());
                } else {
                    in = new GZIPInputStream(new BufferedInputStream(socket.getInputStream()));
                    out = new BufferedOutputStream((OutputStream)new FlushableGZIPOutputStream(socket.getOutputStream()));
                }
                while (KeepAliveServer.this.running.get()) {
                    try {
                        i = ((InputStream)in).read();
                    }
                    catch (SocketException e) {
                        break;
                    }
                    if (i == -1) {
                        break;
                    }
                    KeepAliveStyle style = KeepAliveStyle.values()[i];
                    Lock l = this.usage;
                    try {
                        l.lock();
                        switch (style) {
                            case PING_PING: {
                                i = ((InputStream)in).read();
                                break;
                            }
                            case PING_PONG: {
                                ((OutputStream)out).write(style.ordinal());
                                ((OutputStream)out).flush();
                            }
                        }
                        try {
                            KeepAliveServer.this.service.service((InputStream)new Input(in), (OutputStream)new Output(out));
                            ((OutputStream)out).flush();
                        }
                        catch (SocketException e) {
                            this.lastRequest = System.currentTimeMillis();
                            l.unlock();
                            break;
                        }
                    }
                    finally {
                        this.lastRequest = System.currentTimeMillis();
                        l.unlock();
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Unexpected byte " + i);
            }
            catch (InterruptedIOException e) {
                Thread.interrupted();
            }
            finally {
                this.kas.removeSession(this);
            }
        }
    }

    public class KeepAliveTimer
    extends TimerTask {
        private final KeepAliveServer kas;

        public KeepAliveTimer(KeepAliveServer kas) {
            this.kas = kas;
        }

        @Override
        public void run() {
            this.kas.closeInactiveSessions();
        }
    }
}

