/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.HttpSession;

public class HttpResponseImpl
implements HttpResponse {
    private String responseString = "OK";
    private int code = 200;
    private final Map<String, String> headers = new HashMap<String, String>();
    private byte[] body = new byte[0];
    private transient PrintWriter writer;
    private transient ByteArrayOutputStream baos;
    public static final String HTTP_VERSION = "HTTP/1.1";
    public static final String CRLF = "\r\n";
    public static final String SP = " ";
    public static final String CSP = ": ";
    public static String server;
    private HttpRequestImpl request;
    private URLConnection content;

    protected void setRequest(HttpRequestImpl request) {
        this.request = request;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public OutputStream getOutputStream() {
        return this.baos;
    }

    public void flushBuffer() throws IOException {
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setResponseString(String responseString) {
        this.responseString = responseString;
    }

    public void reset() {
        this.initBody();
    }

    public void reset(int code, String responseString) {
        this.setCode(code);
        this.setResponseString(responseString);
        this.initBody();
    }

    protected HttpResponseImpl() {
        this(200, "OK", "text/html");
    }

    protected HttpResponseImpl(int code, String responseString, String contentType) {
        this.responseString = responseString;
        this.code = code;
        this.setHeader("Server", this.getServerName());
        this.setHeader("Connection", "close");
        this.setHeader("Content-Type", contentType);
        this.initBody();
    }

    protected void writeMessage(OutputStream output) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        this.closeMessage();
        this.writeResponseLine(out);
        this.writeHeaders(out);
        this.writeBody(out);
        out.flush();
        output.write(baos.toByteArray());
        output.flush();
    }

    private void initBody() {
        this.baos = new ByteArrayOutputStream();
        this.writer = new PrintWriter(this.baos);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(40);
        buf.append(HTTP_VERSION);
        buf.append(SP);
        buf.append(this.code);
        buf.append(SP);
        buf.append(this.responseString);
        return buf.toString();
    }

    private void closeMessage() {
        this.setContentLengthHeader();
        this.setCookieHeader();
    }

    private void setContentLengthHeader() {
        if (this.content == null) {
            this.writer.flush();
            this.writer.close();
            this.body = this.baos.toByteArray();
            this.setHeader("Content-Length", this.body.length + "");
        } else {
            this.setHeader("Content-Length", this.content.getContentLength() + "");
        }
    }

    private void setCookieHeader() {
        if (this.request == null || this.request.getSession() == null) {
            return;
        }
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return;
        }
        StringBuffer cookie = new StringBuffer();
        cookie.append("EJBSESSIONID");
        cookie.append('=');
        cookie.append(session.getId());
        cookie.append("; Path=/");
        this.headers.put("Set-Cookie", cookie.toString());
    }

    private void writeResponseLine(DataOutput out) throws IOException {
        out.writeBytes(HTTP_VERSION);
        out.writeBytes(SP);
        out.writeBytes(this.code + "");
        out.writeBytes(SP);
        out.writeBytes(this.responseString);
        out.writeBytes(CRLF);
    }

    private void writeHeaders(DataOutput out) throws IOException {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            out.writeBytes("" + entry.getKey());
            out.writeBytes(CSP);
            out.writeBytes("" + entry.getValue());
            out.writeBytes(CRLF);
        }
    }

    private void writeBody(DataOutput out) throws IOException {
        out.writeBytes(CRLF);
        if (this.content == null) {
            out.write(this.body);
        } else {
            int i;
            InputStream in = this.content.getInputStream();
            byte[] buf = new byte[1024];
            while ((i = in.read(buf)) != -1) {
                out.write(buf, 0, i);
            }
        }
    }

    public String getServerName() {
        if (server == null) {
            String version = "???";
            String os = "(unknown os)";
            try {
                Properties versionInfo = new Properties();
                versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
                version = versionInfo.getProperty("version");
                os = System.getProperty("os.name") + "/" + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")";
            }
            catch (IOException iOException) {
                // empty catch block
            }
            server = "OpenEJB/" + version + SP + os;
        }
        return server;
    }

    protected static HttpResponseImpl createError(String message) {
        return HttpResponseImpl.createError(message, null);
    }

    protected static HttpResponseImpl createError(String message, Throwable t) {
        HttpResponseImpl res = new HttpResponseImpl(500, "Internal Server Error", "text/html");
        PrintWriter body = res.getPrintWriter();
        body.println("<html>");
        body.println("<body>");
        body.println("<h3>Internal Server Error</h3>");
        body.println("<br><br>");
        System.out.println("ERROR");
        if (message != null) {
            StringTokenizer msg = new StringTokenizer(message, "\n\r");
            while (msg.hasMoreTokens()) {
                body.print(msg.nextToken());
                body.println("<br>");
            }
        }
        if (t != null) {
            try {
                body.println("<br><br>");
                body.println("Stack Trace:<br>");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter(baos);
                t.printStackTrace(writer);
                writer.flush();
                writer.close();
                message = new String(baos.toByteArray());
                StringTokenizer msg = new StringTokenizer(message, "\n\r");
                while (msg.hasMoreTokens()) {
                    body.print(msg.nextToken());
                    body.println("<br>");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        body.println("</body>");
        body.println("</html>");
        return res;
    }

    protected static HttpResponseImpl createForbidden(String ip) {
        HttpResponseImpl res = new HttpResponseImpl(403, "Forbidden", "text/html");
        PrintWriter body = res.getPrintWriter();
        body.println("<html>");
        body.println("<body>");
        body.println("<h3>Forbidden</h3>");
        body.println("<br><br>");
        body.println("IP address: " + ip + " is not registered on this server, please contact your system administrator.");
        body.println("</body>");
        body.println("</html>");
        return res;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.responseString);
        out.writeInt(this.code);
        out.writeObject(this.headers);
        this.writer.flush();
        this.body = this.baos.toByteArray();
        out.writeObject(this.body);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.responseString = (String)in.readObject();
        this.code = in.readInt();
        Map headers = (Map)in.readObject();
        this.headers.clear();
        this.headers.putAll(headers);
        this.body = (byte[])in.readObject();
        this.baos = new ByteArrayOutputStream();
        this.baos.write(this.body);
        this.writer = new PrintWriter(this.baos);
    }

    public void setContent(URLConnection content) {
        this.content = content;
    }

    public void setStatusCode(int code) {
        this.setCode(code);
    }

    public int getStatusCode() {
        return this.getCode();
    }

    public void setStatusMessage(String responseString) {
        this.setResponseString(responseString);
    }
}

