/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpSession;
import org.apache.openejb.server.httpd.ServletSessionAdapter;

public class ServletRequestAdapter
implements HttpRequest {
    private final HttpServletRequest request;

    public ServletRequestAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public ServletRequestAdapter(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.request = request;
        request.setAttribute(HttpRequest.SERVLET_REQUEST, (Object)request);
        request.setAttribute(HttpRequest.SERVLET_RESPONSE, (Object)response);
        request.setAttribute(HttpRequest.SERVLET_CONTEXT, (Object)servletContext);
    }

    public HttpSession getSession(boolean create) {
        javax.servlet.http.HttpSession session = this.request.getSession(create);
        if (session != null) {
            return new ServletSessionAdapter(session);
        }
        return null;
    }

    public HttpSession getSession() {
        javax.servlet.http.HttpSession session = this.request.getSession();
        if (session != null) {
            return new ServletSessionAdapter(session);
        }
        return null;
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public URI getURI() {
        try {
            return new URI(this.request.getScheme(), null, this.request.getServerName(), this.request.getServerPort(), this.request.getRequestURI(), this.request.getQueryString(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public HttpRequest.Method getMethod() {
        try {
            return HttpRequest.Method.valueOf(this.request.getMethod());
        }
        catch (IllegalArgumentException e) {
            return HttpRequest.Method.UNSUPPORTED;
        }
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public Map getParameters() {
        return this.request.getParameterMap();
    }

    public Object getAttribute(String s) {
        Object o = this.request.getAttribute(s);
        return o;
    }

    public void setAttribute(String s, Object o) {
        this.request.setAttribute(s, o);
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }
}

