/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.openejb.cdi.OpenEJBLifecycle;
import org.apache.openejb.cdi.ThreadSingletonServiceImpl;
import org.apache.openejb.cdi.WebappWebBeansContext;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.util.WebBeansUtil;

public class BeginWebBeansListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener,
HttpSessionActivationListener {
    private final String contextKey;
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_CDI, BeginWebBeansListener.class);
    protected FailOverService failoverService;
    protected WebBeansContext webBeansContext;

    public BeginWebBeansListener(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.failoverService = (FailOverService)this.webBeansContext.getService(FailOverService.class);
        this.contextKey = "org.apache.tomee.catalina.WebBeansListener@" + webBeansContext.hashCode();
    }

    public void requestDestroyed(ServletRequestEvent event) {
    }

    public void requestInitialized(ServletRequestEvent event) {
        WebBeansContext oldContext = ThreadSingletonServiceImpl.enter((WebBeansContext)this.webBeansContext);
        event.getServletRequest().setAttribute(this.contextKey, (Object)oldContext);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting a new request : [{0}]", new Object[]{event.getServletRequest().getRemoteAddr()});
            }
            if (this.webBeansContext instanceof WebappWebBeansContext) {
                ((WebappWebBeansContext)this.webBeansContext).getParent().getContextsService().startContext(RequestScoped.class, (Object)event);
            }
            this.webBeansContext.getContextsService().startContext(RequestScoped.class, (Object)event);
        }
        catch (Exception e) {
            logger.error("ERROR_0019", new Object[]{event.getServletRequest()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting a session with session id : [{0}]", new Object[]{event.getSession().getId()});
            }
            if (this.webBeansContext instanceof WebappWebBeansContext) {
                ((WebappWebBeansContext)this.webBeansContext).getParent().getContextsService().startContext(SessionScoped.class, (Object)event.getSession());
            }
            this.webBeansContext.getContextsService().startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            logger.error("ERROR_0020", new Object[]{event.getSession()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        if (this.failoverService.isSupportFailOver() || this.failoverService.isSupportPassivation()) {
            this.failoverService.sessionDidActivate(event.getSession());
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            OpenEJBLifecycle.initializeServletContext((ServletContext)servletContextEvent.getServletContext(), (WebBeansContext)this.webBeansContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

