/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.openejb.cdi.ThreadSingletonServiceImpl;
import org.apache.openejb.cdi.WebappWebBeansContext;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.web.context.WebContextsService;

public class EndWebBeansListener
implements ServletRequestListener,
HttpSessionListener,
HttpSessionActivationListener {
    private final String contextKey;
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_CDI, EndWebBeansListener.class);
    protected FailOverService failoverService;
    protected WebBeansContext webBeansContext;

    public EndWebBeansListener(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.failoverService = (FailOverService)this.webBeansContext.getService(FailOverService.class);
        this.contextKey = "org.apache.tomee.catalina.WebBeansListener@" + webBeansContext.hashCode();
    }

    private void cleanupRequestThreadLocals() {
        InjectionPointBean.removeThreadLocal();
        WebContextsService.removeThreadLocals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequestEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying a request : [{0}]", new Object[]{event.getServletRequest().getRemoteAddr()});
        }
        Object oldContext = event.getServletRequest().getAttribute(this.contextKey);
        try {
            ELContextStore elStore;
            HttpServletRequest httpRequest;
            HttpSession session;
            ServletRequest request;
            if (this.failoverService != null && this.failoverService.isSupportFailOver() && (request = event.getServletRequest()) instanceof HttpServletRequest && (session = (httpRequest = (HttpServletRequest)request).getSession(false)) != null) {
                this.failoverService.sessionIsIdle(session);
            }
            if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
                elStore.destroyELContextStore();
            }
            this.webBeansContext.getContextsService().endContext(RequestScoped.class, (Object)event);
            if (this.webBeansContext instanceof WebappWebBeansContext) {
                ((WebappWebBeansContext)this.webBeansContext).getParent().getContextsService().endContext(RequestScoped.class, (Object)event);
            }
            this.cleanupRequestThreadLocals();
        }
        finally {
            ThreadSingletonServiceImpl.enter((WebBeansContext)((WebBeansContext)oldContext));
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying a session with session id : [{0}]", new Object[]{event.getSession().getId()});
        }
        this.webBeansContext.getContextsService().endContext(SessionScoped.class, (Object)event.getSession());
        if (this.webBeansContext instanceof WebappWebBeansContext) {
            ((WebappWebBeansContext)this.webBeansContext).getParent().getContextsService().endContext(SessionScoped.class, (Object)event.getSession());
        }
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        conversationManager.destroyConversationContextWithSessionId(event.getSession().getId());
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        if (this.failoverService != null && this.failoverService.isSupportPassivation()) {
            this.failoverService.sessionWillPassivate(event.getSession());
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
    }
}

