/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.Socket;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponseImpl;
import org.apache.openejb.server.httpd.HttpServer;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.OptionsLog;

public class OpenEJBHttpServer
implements HttpServer {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.HTTPSERVER, (String)"org.apache.openejb.util.resources");
    private HttpListener listener;
    private Set<Output> print;
    private boolean indent;

    public OpenEJBHttpServer() {
        this(OpenEJBHttpServer.getHttpListenerRegistry());
    }

    public static HttpListenerRegistry getHttpListenerRegistry() {
        SystemInstance systemInstance = SystemInstance.get();
        HttpListenerRegistry registry = (HttpListenerRegistry)systemInstance.getComponent(HttpListenerRegistry.class);
        if (registry == null) {
            registry = new HttpListenerRegistry();
            systemInstance.setComponent(HttpListenerRegistry.class, (Object)registry);
        }
        return registry;
    }

    public OpenEJBHttpServer(HttpListener listener) {
        this.listener = listener;
    }

    public static boolean isTextXml(Map<String, String> headers) {
        String contentType = headers.get("Content-Type");
        return contentType != null && contentType.contains("text/xml");
    }

    @Override
    public HttpListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Socket socket) throws ServiceException, IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = socket.getInputStream();
            out = socket.getOutputStream();
            URI socketURI = new URI("http://" + socket.getLocalAddress().getHostAddress() + ":" + socket.getLocalPort());
            this.processRequest(socketURI, in, out);
        }
        catch (Throwable e) {
            log.error("Unexpected error", e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                }
                catch (Throwable e) {}
                try {
                    out.close();
                }
                catch (Throwable e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable e) {}
            }
            try {
                socket.close();
            }
            catch (Throwable e) {
                log.error("Encountered problem while closing connection with client: " + e.getMessage());
            }
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException("Method not implemented: service(InputStream in, OutputStream out)");
    }

    public void init(Properties props) throws Exception {
        Options options = new Options(props);
        options.setLogger((Options.Log)new OptionsLog(log));
        this.print = options.getAll("print", Output.class);
        this.indent = this.print.size() > 0 && options.get("indent.xml", false);
    }

    public void start() throws ServiceException {
    }

    public void stop() throws ServiceException {
    }

    public String getName() {
        return "httpd";
    }

    public int getPort() {
        return 0;
    }

    public String getIP() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(URI socketURI, InputStream in, OutputStream out) {
        HttpResponseImpl response = null;
        try {
            response = this.process(socketURI, in);
        }
        catch (Throwable t) {
            response = HttpResponseImpl.createError(t.getMessage(), t);
        }
        finally {
            try {
                if (response != null) {
                    response.writeMessage(out, false);
                    if (this.print.size() > 0 && this.print.contains((Object)Output.RESPONSE)) {
                        response.writeMessage(new LoggerOutputStream(log, "debug"), this.indent);
                    }
                }
            }
            catch (Throwable t2) {
                log.error("Could not write response", t2);
            }
        }
    }

    private HttpResponseImpl process(URI socketURI, InputStream in) throws OpenEJBException {
        HttpRequestImpl req = new HttpRequestImpl(socketURI);
        HttpResponseImpl res = new HttpResponseImpl();
        try {
            req.readMessage(in);
            if (this.print.size() > 0 && this.print.contains((Object)Output.REQUEST)) {
                req.print(log, this.indent);
            }
            res.setRequest(req);
        }
        catch (Throwable t) {
            res.setCode(400);
            res.setResponseString("Could not read the request");
            try {
                res.getWriter().println(t.getMessage());
                t.printStackTrace(res.getWriter());
            }
            catch (IOException e) {
                // empty catch block
            }
            log.error("BAD REQUEST", t);
            throw new OpenEJBException("Could not read the request.\n" + t.getClass().getName() + ":\n" + t.getMessage(), t);
        }
        String location = null;
        try {
            URI uri = req.getURI();
            location = uri.getPath();
            int querry = location.indexOf("?");
            if (querry != -1) {
                location = location.substring(0, querry);
            }
        }
        catch (Throwable t) {
            throw new OpenEJBException("Could not determine the module " + location + "\n" + t.getClass().getName() + ":\n" + t.getMessage());
        }
        try {
            this.listener.onMessage(req, res);
        }
        catch (Throwable t) {
            throw new OpenEJBException("Error occurred while executing the module " + location + "\n" + t.getClass().getName() + ":\n" + t.getMessage(), t);
        }
        return res;
    }

    public static String reformat(String raw) {
        if (raw.length() == 0) {
            return raw;
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(new StreamSource(new StringReader(raw)), result);
            return result.getWriter().toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return raw;
        }
    }

    private static class LoggerOutputStream
    extends OutputStream {
        private final Logger logger;
        private final String level;

        public LoggerOutputStream(Logger log, String lvl) {
            this.logger = log;
            this.level = lvl;
        }

        @Override
        public void write(int b) throws IOException {
            this.logger.log(this.level, Character.toString((char)b));
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.logger.log(this.level, new String(b));
        }
    }

    public static enum Output {
        REQUEST,
        RESPONSE;

    }
}

