/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.object.OperationsPolicy;

public class BasicCmpBean
implements EntityBean {
    private static int nextId;
    public Integer primaryKey;
    public String firstName;
    public String lastName;
    public EntityContext ejbContext;
    public Map<String, OperationsPolicy> allowedOperationsTable = new HashMap<String, OperationsPolicy>();

    public int ejbHomeSum(int x, int y) {
        this.testAllowedOperations("ejbHome");
        return x + y;
    }

    public void ejbHomeVoidSelect() {
    }

    public Integer ejbCreateObject(String name) throws CreateException {
        this.primaryKey = nextId++;
        StringTokenizer st = new StringTokenizer(name, " ");
        this.firstName = st.nextToken();
        this.lastName = st.nextToken();
        return null;
    }

    public void ejbPostCreateObject(String name) throws CreateException {
    }

    public int getPrimaryKey() {
        return this.primaryKey;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String businessMethod(String text) {
        this.testAllowedOperations("businessMethod");
        StringBuffer b = new StringBuffer(text);
        return b.reverse().toString();
    }

    public void throwApplicationException() throws ApplicationException {
        throw new ApplicationException("Testing ability to throw Application Exceptions");
    }

    public void throwSystemException_NullPointer() {
        throw new NullPointerException("Testing ability to throw System Exceptions");
    }

    public Properties getPermissionsReport() {
        return null;
    }

    public OperationsPolicy getAllowedOperationsReport(String methodName) {
        return this.allowedOperationsTable.get(methodName);
    }

    public void ejbLoad() throws EJBException, RemoteException {
    }

    public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
        this.ejbContext = ctx;
        this.testAllowedOperations("setEntityContext");
    }

    public void unsetEntityContext() throws EJBException, RemoteException {
        this.testAllowedOperations("unsetEntityContext");
    }

    public void ejbStore() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws RemoveException, EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbActivate");
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbPassivate");
    }

    protected void testAllowedOperations(String methodName) {
        OperationsPolicy policy = new OperationsPolicy();
        try {
            this.ejbContext.getEJBHome();
            policy.allow(0);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getCallerPrincipal();
            policy.allow(1);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.isCallerInRole("TheMan");
            policy.allow(2);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getRollbackOnly();
            policy.allow(3);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.setRollbackOnly();
            policy.allow(4);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getUserTransaction();
            policy.allow(5);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.ejbContext.getEJBObject();
            policy.allow(6);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getPrimaryKey();
            policy.allow(7);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.allowedOperationsTable.put(methodName, policy);
    }
}

