/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Stateless;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;
import org.apache.openejb.test.SuperInterceptedBean;
import org.apache.openejb.test.interceptor.ClassInterceptor;
import org.apache.openejb.test.interceptor.Interceptor;
import org.apache.openejb.test.interceptor.MethodInterceptor;
import org.apache.openejb.test.stateless.BasicStatelessInterceptedLocal;
import org.apache.openejb.test.stateless.BasicStatelessInterceptedRemote;

@Stateless(name="BasicStatelessIntercepted")
@Interceptors(value={ClassInterceptor.class})
public class BasicStatelessInterceptedBean
extends SuperInterceptedBean
implements BasicStatelessInterceptedLocal,
BasicStatelessInterceptedRemote {
    private static Map<String, Object> contextData = new LinkedHashMap<String, Object>();

    @Override
    public String concat(String str1, String str2) {
        return str1.concat(str2);
    }

    @Override
    @Interceptors(value={MethodInterceptor.class})
    public String reverse(String str) {
        StringBuffer b = new StringBuffer(str);
        return b.reverse().toString();
    }

    private void setContextData(Map<String, Object> ctxData) {
        contextData.putAll(ctxData);
    }

    @Override
    @ExcludeClassInterceptors
    public Map<String, Object> getContextData() {
        return contextData;
    }

    @AroundInvoke
    public Object inBeanInterceptor(InvocationContext ctx) throws Exception {
        Map<String, Object> ctxData = Interceptor.profile(ctx, "inBeanInterceptor");
        this.setContextData(ctxData);
        return ctx.proceed();
    }

    @PostConstruct
    public void inBeanInterceptorPostConstruct() throws Exception {
        Map<String, Object> ctxData = Interceptor.profile(this, "inBeanInterceptorPostConstruct");
        this.setContextData(ctxData);
    }

    @PreDestroy
    public void inBeanInterceptorPreDestroy() throws Exception {
        Map<String, Object> ctxData = Interceptor.profile(this, "inBeanInterceptorPreDestroy");
        this.setContextData(ctxData);
    }
}

