/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import org.apache.openejb.test.object.Account;
import org.apache.openejb.test.object.Transaction;

public class BeanTxStatelessBean
implements SessionBean {
    private String name;
    private SessionContext ejbContext;
    private InitialContext jndiContext;
    public final String jndiDatabaseEntry = "jdbc/stateless/beanManagedTransaction/database";

    public Transaction getUserTransaction() throws RemoteException {
        UserTransaction ut = null;
        try {
            ut = this.ejbContext.getUserTransaction();
        }
        catch (IllegalStateException ise) {
            throw new RemoteException(ise.getMessage());
        }
        if (ut == null) {
            return null;
        }
        return new Transaction(ut);
    }

    public Transaction jndiUserTransaction() throws RemoteException {
        UserTransaction ut = null;
        try {
            ut = (UserTransaction)this.jndiContext.lookup("java:comp/UserTransaction");
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        if (ut == null) {
            return null;
        }
        return new Transaction(ut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openAccount(Account acct, Boolean rollback) throws RemoteException, RollbackException {
        try {
            DataSource ds = (DataSource)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/database"), DataSource.class);
            Connection con = ds.getConnection();
            try {
                UserTransaction ut = this.ejbContext.getUserTransaction();
                ut.begin();
                PreparedStatement stmt = con.prepareStatement("insert into Account (SSN, First_name, Last_name, Balance) values (?,?,?,?)");
                try {
                    stmt.setString(1, acct.getSsn());
                    stmt.setString(2, acct.getFirstName());
                    stmt.setString(3, acct.getLastName());
                    stmt.setInt(4, acct.getBalance());
                    stmt.executeUpdate();
                }
                finally {
                    stmt.close();
                }
                if (rollback.booleanValue()) {
                    ut.setRollbackOnly();
                }
                ut.commit();
            }
            finally {
                con.close();
            }
        }
        catch (RollbackException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException("[Bean] " + e.getClass().getName() + " : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Account retreiveAccount(String ssn) throws RemoteException {
        Account acct = new Account();
        try {
            DataSource ds = (DataSource)PortableRemoteObject.narrow((Object)this.jndiContext.lookup("java:comp/env/database"), DataSource.class);
            Connection con = ds.getConnection();
            try {
                PreparedStatement stmt = con.prepareStatement("select * from Account where SSN = ?");
                try {
                    stmt.setString(1, ssn);
                    ResultSet rs = stmt.executeQuery();
                    if (!rs.next()) {
                        Account account = null;
                        return account;
                    }
                    acct.setSsn(rs.getString(1));
                    acct.setFirstName(rs.getString(2));
                    acct.setLastName(rs.getString(3));
                    acct.setBalance(rs.getInt(4));
                    return acct;
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                con.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException("[Bean] " + e.getClass().getName() + " : " + e.getMessage());
        }
    }

    public void ejbCreate() throws CreateException {
        try {
            this.jndiContext = new InitialContext();
        }
        catch (Exception e) {
            throw new CreateException("Can not get the initial context: " + e.getMessage());
        }
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.ejbContext = ctx;
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public String remove(String arg) {
        return arg;
    }
}

