/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.TestDatabase;
import org.apache.openejb.test.TestManager;
import org.apache.openejb.test.TestServer;
import org.apache.openejb.test.beans.Database;
import org.apache.openejb.test.beans.DatabaseHome;

public class HsqldbTestDatabase
implements TestDatabase {
    protected Database database;
    protected InitialContext initialContext;
    private static String _createAccount = "CREATE TABLE account ( ssn VARCHAR(255), first_name VARCHAR(255), last_name VARCHAR(255), balance integer)";
    private static String _dropAccount = "DROP TABLE account";
    private static String _createEntity = "CREATE TABLE entity ( id IDENTITY, first_name VARCHAR(255), last_name VARCHAR(255) )";
    private static String _dropEntity = "DROP TABLE entity";
    private static final String CREATE_ONE_OWNING = "CREATE TABLE oneowning (col_id INTEGER, col_field1 INTEGER)";
    private static final String DROP_ONE_OWNING = "DROP TABLE oneowning";
    private static final String CREATE_ONE_INVERSE = "CREATE TABLE oneinverse (col_id INTEGER)";
    private static final String DROP_ONE_INVERSE = "DROP TABLE oneinverse";
    private static final String CREATE_MANY_OWNING = "CREATE TABLE manyowning (col_id INTEGER, col_field1 INTEGER)";
    private static final String DROP_MANY_OWNING = "DROP TABLE manyowning";
    private static final String[] AUTO_CREATED_TABLES = new String[]{"BasicCmpBean", "BasicCmpBeanX", "ComplexCmpBean", "ComplexCmpBeanX", "UnknownCmpBean", "UnknownCmpBeanX", "BasicCmp2Bean", "ComplexCmp2Bean", "UnknownCmp2Bean", "AOBasicCmpBean", "AllowedOperationsCmp2Bean", "EncCmpBean", "EncCmp2Bean", "ContextLookupCmpBean", "Cmp_RMI_IIOP_Bean", "RmiIiopCmp2Bean", "Person", "License", "ComplexPerson", "ComplexLicense", "Artist", "Song", "ComplexArtist", "Complexsong", "Game", "Platform", "ComplexGame", "ComplexPlatform", "Query", "QueryData"};

    @Override
    public void createEntityTable() throws SQLException {
        this.createTable(_createEntity, _dropEntity);
        this.createTable(CREATE_ONE_OWNING, DROP_ONE_OWNING);
        this.createTable(CREATE_ONE_INVERSE, DROP_ONE_INVERSE);
        this.createTable(CREATE_MANY_OWNING, DROP_MANY_OWNING);
        this.clearTables(AUTO_CREATED_TABLES);
    }

    @Override
    public void dropEntityTable() throws SQLException {
        this.dropTable(_dropEntity);
        this.dropTable(DROP_ONE_OWNING);
        this.dropTable(DROP_ONE_INVERSE);
        this.dropTable(DROP_MANY_OWNING);
        this.clearTables(AUTO_CREATED_TABLES);
    }

    private void createTable(String create, String drop) throws SQLException {
        try {
            try {
                this.database.execute(drop);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.database.execute(create);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Cannot create table: " + re.getMessage(), create);
        }
    }

    private void clearTables(String ... autoCreatedTables) {
        for (String tableName : autoCreatedTables) {
            try {
                this.database.execute("DELETE FROM " + tableName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void dropTable(String drop) throws SQLException {
        try {
            this.database.execute(drop);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Unable to drop table: " + re.getMessage(), drop);
        }
    }

    @Override
    public void createAccountTable() throws SQLException {
        try {
            try {
                this.database.execute(_dropAccount);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.database.execute(_createAccount);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Cannot create account table: " + re.getMessage(), _createAccount);
        }
    }

    @Override
    public void dropAccountTable() throws SQLException {
        try {
            this.database.execute(_dropAccount);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Cannot drop account table: " + re.getMessage(), _dropAccount);
        }
    }

    @Override
    public void start() throws IllegalStateException {
        try {
            TestServer server = TestManager.getServer();
            Properties properties = server.getContextEnvironment();
            this.initialContext = new InitialContext(properties);
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException("Cannot create initial context: " + e.getClass().getName() + " " + e.getMessage()).initCause(e);
        }
        String databaseHomeJndiName = "client/tools/DatabaseHome";
        Object obj = null;
        DatabaseHome databaseHome = null;
        try {
            obj = this.initialContext.lookup("client/tools/DatabaseHome");
            databaseHome = (DatabaseHome)PortableRemoteObject.narrow((Object)obj, DatabaseHome.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot find client/tools/DatabaseHome: " + e.getClass().getName() + " " + e.getMessage());
        }
        try {
            this.database = databaseHome.create();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot start database: " + e.getClass().getName() + " " + e.getMessage());
        }
    }

    @Override
    public void stop() throws IllegalStateException {
    }

    @Override
    public void init(Properties props) throws IllegalStateException {
    }

    static {
        System.setProperty("noBanner", "true");
    }
}

